/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter.management;

import be.maximvdw.tabcore.twitter.management.APIStatistics;
import be.maximvdw.tabcore.twitter.management.APIStatisticsMBean;
import be.maximvdw.tabcore.twitter.management.InvocationStatistics;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class APIStatisticsOpenMBean
implements DynamicMBean {
    private static final String[] ITEM_NAMES = new String[]{"methodName", "callCount", "errorCount", "totalTime", "avgTime"};
    private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"The method name", "The number of times this method has been called", "The number of calls that failed", "The total amount of time spent invoking this method in milliseconds", "The average amount of time spent invoking this method in milliseconds"};
    private final CompositeType METHOD_STATS_TYPE;
    private final APIStatisticsMBean API_STATISTICS;
    private final TabularType API_STATISTICS_TYPE;

    public APIStatisticsOpenMBean(APIStatistics aPIStatistics) {
        this.API_STATISTICS = aPIStatistics;
        try {
            this.METHOD_STATS_TYPE = new CompositeType("method statistics", "method statistics", ITEM_NAMES, ITEM_DESCRIPTIONS, ITEM_TYPES);
            String[] stringArray = new String[]{"methodName"};
            this.API_STATISTICS_TYPE = new TabularType("API statistics", "list of methods", this.METHOD_STATS_TYPE, stringArray);
        }
        catch (OpenDataException openDataException) {
            throw new RuntimeException(openDataException);
        }
    }

    public MBeanInfo getMBeanInfo() {
        OpenMBeanAttributeInfo[] openMBeanAttributeInfoArray = new OpenMBeanAttributeInfoSupport[5];
        OpenMBeanConstructorInfo[] openMBeanConstructorInfoArray = new OpenMBeanConstructorInfoSupport[1];
        OpenMBeanOperationInfo[] openMBeanOperationInfoArray = new OpenMBeanOperationInfoSupport[1];
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{};
        int n2 = 0;
        openMBeanAttributeInfoArray[n2++] = new OpenMBeanAttributeInfoSupport("callCount", "Total number of API calls", SimpleType.LONG, true, false, false);
        openMBeanAttributeInfoArray[n2++] = new OpenMBeanAttributeInfoSupport("errorCount", "The number of failed API calls", SimpleType.LONG, true, false, false);
        openMBeanAttributeInfoArray[n2++] = new OpenMBeanAttributeInfoSupport("averageTime", "Average time spent invoking any API method", SimpleType.LONG, true, false, false);
        openMBeanAttributeInfoArray[n2++] = new OpenMBeanAttributeInfoSupport("totalTime", "Average time spent invoking any API method", SimpleType.LONG, true, false, false);
        openMBeanAttributeInfoArray[n2++] = new OpenMBeanAttributeInfoSupport("statisticsTable", "Table of statisics for all API methods", this.API_STATISTICS_TYPE, true, false, false);
        openMBeanConstructorInfoArray[0] = new OpenMBeanConstructorInfoSupport("APIStatisticsOpenMBean", "Constructs an APIStatisticsOpenMBean instance", new OpenMBeanParameterInfoSupport[0]);
        OpenMBeanParameterInfo[] openMBeanParameterInfoArray = new OpenMBeanParameterInfoSupport[]{};
        openMBeanOperationInfoArray[0] = new OpenMBeanOperationInfoSupport("reset", "reset the statistics", openMBeanParameterInfoArray, SimpleType.VOID, 0);
        OpenMBeanInfoSupport openMBeanInfoSupport = new OpenMBeanInfoSupport(this.getClass().getName(), "API Statistics Open MBean", openMBeanAttributeInfoArray, openMBeanConstructorInfoArray, openMBeanOperationInfoArray, mBeanNotificationInfoArray);
        return openMBeanInfoSupport;
    }

    public synchronized TabularDataSupport getStatistics() {
        TabularDataSupport tabularDataSupport = new TabularDataSupport(this.API_STATISTICS_TYPE);
        for (InvocationStatistics invocationStatistics : this.API_STATISTICS.getInvocationStatistics()) {
            Object[] objectArray = new Object[]{invocationStatistics.getName(), invocationStatistics.getCallCount(), invocationStatistics.getErrorCount(), invocationStatistics.getTotalTime(), invocationStatistics.getAverageTime()};
            try {
                CompositeDataSupport compositeDataSupport = new CompositeDataSupport(this.METHOD_STATS_TYPE, ITEM_NAMES, objectArray);
                tabularDataSupport.put(compositeDataSupport);
            }
            catch (OpenDataException openDataException) {
                throw new RuntimeException(openDataException);
            }
        }
        return tabularDataSupport;
    }

    public void reset() {
        this.API_STATISTICS.reset();
    }

    public Object getAttribute(String string) {
        if (string.equals("statisticsTable")) {
            return this.getStatistics();
        }
        if (string.equals("callCount")) {
            return this.API_STATISTICS.getCallCount();
        }
        if (string.equals("errorCount")) {
            return this.API_STATISTICS.getErrorCount();
        }
        if (string.equals("totalTime")) {
            return this.API_STATISTICS.getTotalTime();
        }
        if (string.equals("averageTime")) {
            return this.API_STATISTICS.getAverageTime();
        }
        throw new AttributeNotFoundException("Cannot find " + string + " attribute ");
    }

    public AttributeList getAttributes(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        for (String string : stringArray) {
            try {
                Object object = this.getAttribute(string);
                attributeList.add(new Attribute(string, object));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return attributeList;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) {
        if (string.equals("reset")) {
            this.reset();
            return "Statistics reset";
        }
        throw new ReflectionException(new NoSuchMethodException(string), "Cannot find the operation " + string);
    }

    public void setAttribute(Attribute attribute) {
        throw new AttributeNotFoundException("No attributes can be set in this MBean");
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        return new AttributeList();
    }
}

