/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter.conf;

import be.maximvdw.tabcore.twitter.conf.Configuration;
import be.maximvdw.tabcore.twitter.conf.ConfigurationBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;

public final class PropertyConfiguration
extends ConfigurationBase
implements Serializable {
    private static final String DEBUG = "debug";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String HTTP_PRETTY_DEBUG = "http.prettyDebug";
    private static final String HTTP_GZIP = "http.gzip";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_HOST_FALLBACK = "http.proxyHost";
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_PROXY_PORT_FALLBACK = "http.proxyPort";
    private static final String HTTP_CONNECTION_TIMEOUT = "http.connectionTimeout";
    private static final String HTTP_READ_TIMEOUT = "http.readTimeout";
    private static final String HTTP_STREAMING_READ_TIMEOUT = "http.streamingReadTimeout";
    private static final String HTTP_RETRY_COUNT = "http.retryCount";
    private static final String HTTP_RETRY_INTERVAL_SECS = "http.retryIntervalSecs";
    private static final String OAUTH_CONSUMER_KEY = "oauth.consumerKey";
    private static final String OAUTH_CONSUMER_SECRET = "oauth.consumerSecret";
    private static final String OAUTH_ACCESS_TOKEN = "oauth.accessToken";
    private static final String OAUTH_ACCESS_TOKEN_SECRET = "oauth.accessTokenSecret";
    private static final String OAUTH2_TOKEN_TYPE = "oauth2.tokenType";
    private static final String OAUTH2_ACCESS_TOKEN = "oauth2.accessToken";
    private static final String OAUTH2_SCOPE = "oauth2.scope";
    private static final String OAUTH_REQUEST_TOKEN_URL = "oauth.requestTokenURL";
    private static final String OAUTH_AUTHORIZATION_URL = "oauth.authorizationURL";
    private static final String OAUTH_ACCESS_TOKEN_URL = "oauth.accessTokenURL";
    private static final String OAUTH_AUTHENTICATION_URL = "oauth.authenticationURL";
    private static final String OAUTH2_TOKEN_URL = "oauth2.tokenURL";
    private static final String OAUTH2_INVALIDATE_TOKEN_URL = "oauth2.invalidateTokenURL";
    private static final String REST_BASE_URL = "restBaseURL";
    private static final String STREAM_BASE_URL = "streamBaseURL";
    private static final String USER_STREAM_BASE_URL = "userStreamBaseURL";
    private static final String SITE_STREAM_BASE_URL = "siteStreamBaseURL";
    private static final String ASYNC_NUM_THREADS = "async.numThreads";
    private static final String ASYNC_DAEMON_ENABLED = "async.daemonEnabled";
    private static final String CONTRIBUTING_TO = "contributingTo";
    private static final String ASYNC_DISPATCHER_IMPL = "async.dispatcherImpl";
    private static final String INCLUDE_MY_RETWEET = "includeMyRetweet";
    private static final String INCLUDE_ENTITIES = "includeEntities";
    private static final String LOGGER_FACTORY = "loggerFactory";
    private static final String JSON_STORE_ENABLED = "jsonStoreEnabled";
    private static final String MBEAN_ENABLED = "mbeanEnabled";
    private static final String STREAM_USER_REPLIES_ALL = "stream.user.repliesAll";
    private static final String STREAM_USER_WITH_FOLLOWINGS = "stream.user.withFollowings";
    private static final String STREAM_STALL_WARNINGS_ENABLED = "stream.enableStallWarnings";
    private static final String APPLICATION_ONLY_AUTH_ENABLED = "enableApplicationOnlyAuth";
    private static final String MEDIA_PROVIDER = "media.provider";
    private static final String MEDIA_PROVIDER_API_KEY = "media.providerAPIKey";
    private static final String MEDIA_PROVIDER_PARAMETERS = "media.providerParameters";
    private static final long serialVersionUID = -7262615247923693252L;
    private String OAuth2Scope;

    public PropertyConfiguration(InputStream inputStream) {
        Properties properties = new Properties();
        this.loadProperties(properties, inputStream);
        this.setFieldsWithTreePath(properties, "/");
    }

    public PropertyConfiguration(Properties properties) {
        this(properties, "/");
    }

    public PropertyConfiguration(Properties properties, String string) {
        this.setFieldsWithTreePath(properties, string);
    }

    PropertyConfiguration(String string) {
        Object object;
        Properties properties;
        try {
            properties = (Properties)System.getProperties().clone();
            try {
                object = System.getenv();
                for (String string2 : object.keySet()) {
                    properties.setProperty(string2, (String)object.get(string2));
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.normalize(properties);
        }
        catch (SecurityException securityException) {
            properties = new Properties();
        }
        object = "be.maximvdw.tabcore.twitter.properties";
        this.loadProperties(properties, "." + File.separatorChar + "be.maximvdw.tabcore.twitter.properties");
        this.loadProperties(properties, Configuration.class.getResourceAsStream("/be/maximvdw/tabcore/twitter.properties"));
        this.loadProperties(properties, Configuration.class.getResourceAsStream("/WEB-INF/twitter4j.properties"));
        try {
            this.loadProperties(properties, new FileInputStream("WEB-INF/twitter4j.properties"));
        }
        catch (SecurityException securityException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.setFieldsWithTreePath(properties, string);
    }

    PropertyConfiguration() {
        this("/");
    }

    private boolean notNull(Properties properties, String string, String string2) {
        return properties.getProperty(string + string2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadProperties(Properties properties, String string) {
        FileInputStream fileInputStream = null;
        try {
            File file = new File(string);
            if (file.exists() && file.isFile()) {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                this.normalize(properties);
                boolean bl2 = true;
                return bl2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private boolean loadProperties(Properties properties, InputStream inputStream) {
        try {
            properties.load(inputStream);
            this.normalize(properties);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void normalize(Properties properties) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>(10);
        for (Object object : properties.keySet()) {
            string = (String)object;
            if (-1 == string.indexOf("be.maximvdw.tabcore.twitter.")) continue;
            arrayList.add(string);
        }
        for (String string2 : arrayList) {
            string = properties.getProperty(string2);
            int n2 = string2.indexOf("be.maximvdw.tabcore.twitter.");
            String string3 = string2.substring(0, n2) + string2.substring(n2 + 10);
            properties.setProperty(string3, string);
        }
    }

    private void setFieldsWithTreePath(Properties properties, String string) {
        this.setFieldsWithPrefix(properties, "");
        String[] stringArray = string.split("/");
        String string2 = null;
        for (String string3 : stringArray) {
            if ("".equals(string3)) continue;
            string2 = null == string2 ? string3 + "." : string2 + string3 + ".";
            this.setFieldsWithPrefix(properties, string2);
        }
    }

    private void setFieldsWithPrefix(Properties properties, String string) {
        if (this.notNull(properties, string, DEBUG)) {
            this.setDebug(this.getBoolean(properties, string, DEBUG));
        }
        if (this.notNull(properties, string, USER)) {
            this.setUser(this.getString(properties, string, USER));
        }
        if (this.notNull(properties, string, PASSWORD)) {
            this.setPassword(this.getString(properties, string, PASSWORD));
        }
        if (this.notNull(properties, string, HTTP_PRETTY_DEBUG)) {
            this.setPrettyDebugEnabled(this.getBoolean(properties, string, HTTP_PRETTY_DEBUG));
        }
        if (this.notNull(properties, string, HTTP_GZIP)) {
            this.setGZIPEnabled(this.getBoolean(properties, string, HTTP_GZIP));
        }
        if (this.notNull(properties, string, "http.proxyHost")) {
            this.setHttpProxyHost(this.getString(properties, string, "http.proxyHost"));
        } else if (this.notNull(properties, string, "http.proxyHost")) {
            this.setHttpProxyHost(this.getString(properties, string, "http.proxyHost"));
        }
        if (this.notNull(properties, string, HTTP_PROXY_USER)) {
            this.setHttpProxyUser(this.getString(properties, string, HTTP_PROXY_USER));
        }
        if (this.notNull(properties, string, HTTP_PROXY_PASSWORD)) {
            this.setHttpProxyPassword(this.getString(properties, string, HTTP_PROXY_PASSWORD));
        }
        if (this.notNull(properties, string, "http.proxyPort")) {
            this.setHttpProxyPort(this.getIntProperty(properties, string, "http.proxyPort"));
        } else if (this.notNull(properties, string, "http.proxyPort")) {
            this.setHttpProxyPort(this.getIntProperty(properties, string, "http.proxyPort"));
        }
        if (this.notNull(properties, string, HTTP_CONNECTION_TIMEOUT)) {
            this.setHttpConnectionTimeout(this.getIntProperty(properties, string, HTTP_CONNECTION_TIMEOUT));
        }
        if (this.notNull(properties, string, HTTP_READ_TIMEOUT)) {
            this.setHttpReadTimeout(this.getIntProperty(properties, string, HTTP_READ_TIMEOUT));
        }
        if (this.notNull(properties, string, HTTP_STREAMING_READ_TIMEOUT)) {
            this.setHttpStreamingReadTimeout(this.getIntProperty(properties, string, HTTP_STREAMING_READ_TIMEOUT));
        }
        if (this.notNull(properties, string, HTTP_RETRY_COUNT)) {
            this.setHttpRetryCount(this.getIntProperty(properties, string, HTTP_RETRY_COUNT));
        }
        if (this.notNull(properties, string, HTTP_RETRY_INTERVAL_SECS)) {
            this.setHttpRetryIntervalSeconds(this.getIntProperty(properties, string, HTTP_RETRY_INTERVAL_SECS));
        }
        if (this.notNull(properties, string, OAUTH_CONSUMER_KEY)) {
            this.setOAuthConsumerKey(this.getString(properties, string, OAUTH_CONSUMER_KEY));
        }
        if (this.notNull(properties, string, OAUTH_CONSUMER_SECRET)) {
            this.setOAuthConsumerSecret(this.getString(properties, string, OAUTH_CONSUMER_SECRET));
        }
        if (this.notNull(properties, string, OAUTH_ACCESS_TOKEN)) {
            this.setOAuthAccessToken(this.getString(properties, string, OAUTH_ACCESS_TOKEN));
        }
        if (this.notNull(properties, string, OAUTH_ACCESS_TOKEN_SECRET)) {
            this.setOAuthAccessTokenSecret(this.getString(properties, string, OAUTH_ACCESS_TOKEN_SECRET));
        }
        if (this.notNull(properties, string, OAUTH2_TOKEN_TYPE)) {
            this.setOAuth2TokenType(this.getString(properties, string, OAUTH2_TOKEN_TYPE));
        }
        if (this.notNull(properties, string, OAUTH2_ACCESS_TOKEN)) {
            this.setOAuth2AccessToken(this.getString(properties, string, OAUTH2_ACCESS_TOKEN));
        }
        if (this.notNull(properties, string, OAUTH2_SCOPE)) {
            this.setOAuth2Scope(this.getString(properties, string, OAUTH2_SCOPE));
        }
        if (this.notNull(properties, string, ASYNC_NUM_THREADS)) {
            this.setAsyncNumThreads(this.getIntProperty(properties, string, ASYNC_NUM_THREADS));
        }
        if (this.notNull(properties, string, ASYNC_DAEMON_ENABLED)) {
            this.setDaemonEnabled(this.getBoolean(properties, string, ASYNC_DAEMON_ENABLED));
        }
        if (this.notNull(properties, string, CONTRIBUTING_TO)) {
            this.setContributingTo(this.getLongProperty(properties, string, CONTRIBUTING_TO));
        }
        if (this.notNull(properties, string, ASYNC_DISPATCHER_IMPL)) {
            this.setDispatcherImpl(this.getString(properties, string, ASYNC_DISPATCHER_IMPL));
        }
        if (this.notNull(properties, string, OAUTH_REQUEST_TOKEN_URL)) {
            this.setOAuthRequestTokenURL(this.getString(properties, string, OAUTH_REQUEST_TOKEN_URL));
        }
        if (this.notNull(properties, string, OAUTH_AUTHORIZATION_URL)) {
            this.setOAuthAuthorizationURL(this.getString(properties, string, OAUTH_AUTHORIZATION_URL));
        }
        if (this.notNull(properties, string, OAUTH_ACCESS_TOKEN_URL)) {
            this.setOAuthAccessTokenURL(this.getString(properties, string, OAUTH_ACCESS_TOKEN_URL));
        }
        if (this.notNull(properties, string, OAUTH_AUTHENTICATION_URL)) {
            this.setOAuthAuthenticationURL(this.getString(properties, string, OAUTH_AUTHENTICATION_URL));
        }
        if (this.notNull(properties, string, OAUTH2_TOKEN_URL)) {
            this.setOAuth2TokenURL(this.getString(properties, string, OAUTH2_TOKEN_URL));
        }
        if (this.notNull(properties, string, OAUTH2_INVALIDATE_TOKEN_URL)) {
            this.setOAuth2InvalidateTokenURL(this.getString(properties, string, OAUTH2_INVALIDATE_TOKEN_URL));
        }
        if (this.notNull(properties, string, REST_BASE_URL)) {
            this.setRestBaseURL(this.getString(properties, string, REST_BASE_URL));
        }
        if (this.notNull(properties, string, STREAM_BASE_URL)) {
            this.setStreamBaseURL(this.getString(properties, string, STREAM_BASE_URL));
        }
        if (this.notNull(properties, string, USER_STREAM_BASE_URL)) {
            this.setUserStreamBaseURL(this.getString(properties, string, USER_STREAM_BASE_URL));
        }
        if (this.notNull(properties, string, SITE_STREAM_BASE_URL)) {
            this.setSiteStreamBaseURL(this.getString(properties, string, SITE_STREAM_BASE_URL));
        }
        if (this.notNull(properties, string, INCLUDE_MY_RETWEET)) {
            this.setIncludeMyRetweetEnabled(this.getBoolean(properties, string, INCLUDE_MY_RETWEET));
        }
        if (this.notNull(properties, string, INCLUDE_ENTITIES)) {
            this.setIncludeEntitiesEnabled(this.getBoolean(properties, string, INCLUDE_ENTITIES));
        }
        if (this.notNull(properties, string, LOGGER_FACTORY)) {
            this.setLoggerFactory(this.getString(properties, string, LOGGER_FACTORY));
        }
        if (this.notNull(properties, string, JSON_STORE_ENABLED)) {
            this.setJSONStoreEnabled(this.getBoolean(properties, string, JSON_STORE_ENABLED));
        }
        if (this.notNull(properties, string, MBEAN_ENABLED)) {
            this.setMBeanEnabled(this.getBoolean(properties, string, MBEAN_ENABLED));
        }
        if (this.notNull(properties, string, STREAM_USER_REPLIES_ALL)) {
            this.setUserStreamRepliesAllEnabled(this.getBoolean(properties, string, STREAM_USER_REPLIES_ALL));
        }
        if (this.notNull(properties, string, STREAM_USER_WITH_FOLLOWINGS)) {
            this.setUserStreamWithFollowingsEnabled(this.getBoolean(properties, string, STREAM_USER_WITH_FOLLOWINGS));
        }
        if (this.notNull(properties, string, STREAM_STALL_WARNINGS_ENABLED)) {
            this.setStallWarningsEnabled(this.getBoolean(properties, string, STREAM_STALL_WARNINGS_ENABLED));
        }
        if (this.notNull(properties, string, APPLICATION_ONLY_AUTH_ENABLED)) {
            this.setApplicationOnlyAuthEnabled(this.getBoolean(properties, string, APPLICATION_ONLY_AUTH_ENABLED));
        }
        if (this.notNull(properties, string, MEDIA_PROVIDER)) {
            this.setMediaProvider(this.getString(properties, string, MEDIA_PROVIDER));
        }
        if (this.notNull(properties, string, MEDIA_PROVIDER_API_KEY)) {
            this.setMediaProviderAPIKey(this.getString(properties, string, MEDIA_PROVIDER_API_KEY));
        }
        if (this.notNull(properties, string, MEDIA_PROVIDER_PARAMETERS)) {
            String[] stringArray = this.getString(properties, string, MEDIA_PROVIDER_PARAMETERS).split("&");
            Properties properties2 = new Properties();
            for (String string2 : stringArray) {
                String[] stringArray2 = string2.split("=");
                properties2.setProperty(stringArray2[0], stringArray2[1]);
            }
            this.setMediaProviderParameters(properties2);
        }
        this.cacheInstance();
    }

    boolean getBoolean(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string + string2);
        return Boolean.valueOf(string3);
    }

    int getIntProperty(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string + string2);
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    long getLongProperty(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string + string2);
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    String getString(Properties properties, String string, String string2) {
        return properties.getProperty(string + string2);
    }

    protected Object readResolve() {
        return super.readResolve();
    }
}

