/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter.auth;

import be.maximvdw.tabcore.twitter.auth.AccessToken;
import be.maximvdw.tabcore.twitter.auth.Authorization;
import be.maximvdw.tabcore.twitter.auth.BasicAuthorization;
import be.maximvdw.tabcore.twitter.auth.NullAuthorization;
import be.maximvdw.tabcore.twitter.auth.OAuth2Authorization;
import be.maximvdw.tabcore.twitter.auth.OAuth2Token;
import be.maximvdw.tabcore.twitter.auth.OAuthAuthorization;
import be.maximvdw.tabcore.twitter.conf.Configuration;

public final class AuthorizationFactory {
    public static Authorization getInstance(Configuration configuration) {
        Authorization authorization = null;
        String string = configuration.getOAuthConsumerKey();
        String string2 = configuration.getOAuthConsumerSecret();
        if (string != null && string2 != null) {
            if (configuration.isApplicationOnlyAuthEnabled()) {
                OAuth2Authorization oAuth2Authorization = new OAuth2Authorization(configuration);
                String string3 = configuration.getOAuth2TokenType();
                String string4 = configuration.getOAuth2AccessToken();
                if (string3 != null && string4 != null) {
                    oAuth2Authorization.setOAuth2Token(new OAuth2Token(string3, string4));
                }
                authorization = oAuth2Authorization;
            } else {
                OAuthAuthorization oAuthAuthorization = new OAuthAuthorization(configuration);
                String string5 = configuration.getOAuthAccessToken();
                String string6 = configuration.getOAuthAccessTokenSecret();
                if (string5 != null && string6 != null) {
                    oAuthAuthorization.setOAuthAccessToken(new AccessToken(string5, string6));
                }
                authorization = oAuthAuthorization;
            }
        } else {
            String string7 = configuration.getUser();
            String string8 = configuration.getPassword();
            if (string7 != null && string8 != null) {
                authorization = new BasicAuthorization(string7, string8);
            }
        }
        if (null == authorization) {
            authorization = NullAuthorization.getInstance();
        }
        return authorization;
    }
}

