/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.HTMLEntity;
import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.JSONArray;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.PagableResponseList;
import be.maximvdw.tabcore.twitter.PagableResponseListImpl;
import be.maximvdw.tabcore.twitter.ParseUtil;
import be.maximvdw.tabcore.twitter.ResponseList;
import be.maximvdw.tabcore.twitter.ResponseListImpl;
import be.maximvdw.tabcore.twitter.Status;
import be.maximvdw.tabcore.twitter.StatusJSONImpl;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.TwitterObjectFactory;
import be.maximvdw.tabcore.twitter.TwitterResponseImpl;
import be.maximvdw.tabcore.twitter.URLEntity;
import be.maximvdw.tabcore.twitter.URLEntityJSONImpl;
import be.maximvdw.tabcore.twitter.User;
import be.maximvdw.tabcore.twitter.conf.Configuration;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UserJSONImpl
extends TwitterResponseImpl
implements User,
Serializable {
    private static final long serialVersionUID = -5448266606847617015L;
    private long id;
    private String name;
    private String screenName;
    private String location;
    private String description;
    private URLEntity[] descriptionURLEntities;
    private URLEntity urlEntity;
    private boolean isContributorsEnabled;
    private String profileImageUrl;
    private String profileImageUrlHttps;
    private boolean isDefaultProfileImage;
    private String url;
    private boolean isProtected;
    private int followersCount;
    private Status status;
    private String profileBackgroundColor;
    private String profileTextColor;
    private String profileLinkColor;
    private String profileSidebarFillColor;
    private String profileSidebarBorderColor;
    private boolean profileUseBackgroundImage;
    private boolean isDefaultProfile;
    private boolean showAllInlineMedia;
    private int friendsCount;
    private Date createdAt;
    private int favouritesCount;
    private int utcOffset;
    private String timeZone;
    private String profileBackgroundImageUrl;
    private String profileBackgroundImageUrlHttps;
    private String profileBannerImageUrl;
    private boolean profileBackgroundTiled;
    private String lang;
    private int statusesCount;
    private boolean isGeoEnabled;
    private boolean isVerified;
    private boolean translator;
    private int listedCount;
    private boolean isFollowRequestSent;
    private String[] withheldInCountries;

    UserJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
        }
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.registerJSONObject(this, jSONObject);
        }
    }

    UserJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    UserJSONImpl() {
    }

    private void init(JSONObject jSONObject) {
        try {
            Object object;
            this.id = ParseUtil.getLong("id", jSONObject);
            this.name = ParseUtil.getRawString("name", jSONObject);
            this.screenName = ParseUtil.getRawString("screen_name", jSONObject);
            this.location = ParseUtil.getRawString("location", jSONObject);
            this.descriptionURLEntities = UserJSONImpl.getURLEntitiesFromJSON(jSONObject, "description");
            URLEntity[] uRLEntityArray = UserJSONImpl.getURLEntitiesFromJSON(jSONObject, "url");
            if (uRLEntityArray.length > 0) {
                this.urlEntity = uRLEntityArray[0];
            }
            this.description = ParseUtil.getRawString("description", jSONObject);
            if (this.description != null) {
                this.description = HTMLEntity.unescapeAndSlideEntityIncdices(this.description, null, this.descriptionURLEntities, null, null);
            }
            this.isContributorsEnabled = ParseUtil.getBoolean("contributors_enabled", jSONObject);
            this.profileImageUrl = ParseUtil.getRawString("profile_image_url", jSONObject);
            this.profileImageUrlHttps = ParseUtil.getRawString("profile_image_url_https", jSONObject);
            this.isDefaultProfileImage = ParseUtil.getBoolean("default_profile_image", jSONObject);
            this.url = ParseUtil.getRawString("url", jSONObject);
            this.isProtected = ParseUtil.getBoolean("protected", jSONObject);
            this.isGeoEnabled = ParseUtil.getBoolean("geo_enabled", jSONObject);
            this.isVerified = ParseUtil.getBoolean("verified", jSONObject);
            this.translator = ParseUtil.getBoolean("is_translator", jSONObject);
            this.followersCount = ParseUtil.getInt("followers_count", jSONObject);
            this.profileBackgroundColor = ParseUtil.getRawString("profile_background_color", jSONObject);
            this.profileTextColor = ParseUtil.getRawString("profile_text_color", jSONObject);
            this.profileLinkColor = ParseUtil.getRawString("profile_link_color", jSONObject);
            this.profileSidebarFillColor = ParseUtil.getRawString("profile_sidebar_fill_color", jSONObject);
            this.profileSidebarBorderColor = ParseUtil.getRawString("profile_sidebar_border_color", jSONObject);
            this.profileUseBackgroundImage = ParseUtil.getBoolean("profile_use_background_image", jSONObject);
            this.isDefaultProfile = ParseUtil.getBoolean("default_profile", jSONObject);
            this.showAllInlineMedia = ParseUtil.getBoolean("show_all_inline_media", jSONObject);
            this.friendsCount = ParseUtil.getInt("friends_count", jSONObject);
            this.createdAt = ParseUtil.getDate("created_at", jSONObject, "EEE MMM dd HH:mm:ss z yyyy");
            this.favouritesCount = ParseUtil.getInt("favourites_count", jSONObject);
            this.utcOffset = ParseUtil.getInt("utc_offset", jSONObject);
            this.timeZone = ParseUtil.getRawString("time_zone", jSONObject);
            this.profileBackgroundImageUrl = ParseUtil.getRawString("profile_background_image_url", jSONObject);
            this.profileBackgroundImageUrlHttps = ParseUtil.getRawString("profile_background_image_url_https", jSONObject);
            this.profileBannerImageUrl = ParseUtil.getRawString("profile_banner_url", jSONObject);
            this.profileBackgroundTiled = ParseUtil.getBoolean("profile_background_tile", jSONObject);
            this.lang = ParseUtil.getRawString("lang", jSONObject);
            this.statusesCount = ParseUtil.getInt("statuses_count", jSONObject);
            this.listedCount = ParseUtil.getInt("listed_count", jSONObject);
            this.isFollowRequestSent = ParseUtil.getBoolean("follow_request_sent", jSONObject);
            if (!jSONObject.isNull("status")) {
                object = jSONObject.getJSONObject("status");
                this.status = new StatusJSONImpl((JSONObject)object);
            }
            if (!jSONObject.isNull("withheld_in_countries")) {
                object = jSONObject.getJSONArray("withheld_in_countries");
                int n2 = ((JSONArray)object).length();
                this.withheldInCountries = new String[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.withheldInCountries[i2] = ((JSONArray)object).getString(i2);
                }
            }
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    private static URLEntity[] getURLEntitiesFromJSON(JSONObject jSONObject, String string) {
        JSONObject jSONObject2;
        JSONObject jSONObject3;
        if (!(jSONObject.isNull("entities") || (jSONObject3 = jSONObject.getJSONObject("entities")).isNull(string) || (jSONObject2 = jSONObject3.getJSONObject(string)).isNull("urls"))) {
            JSONArray jSONArray = jSONObject2.getJSONArray("urls");
            int n2 = jSONArray.length();
            URLEntity[] uRLEntityArray = new URLEntity[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                uRLEntityArray[i2] = new URLEntityJSONImpl(jSONArray.getJSONObject(i2));
            }
            return uRLEntityArray;
        }
        return new URLEntity[0];
    }

    @Override
    public int compareTo(User user) {
        return (int)(this.id - user.getId());
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScreenName() {
        return this.screenName;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isContributorsEnabled() {
        return this.isContributorsEnabled;
    }

    @Override
    public String getProfileImageURL() {
        return this.profileImageUrl;
    }

    @Override
    public String getBiggerProfileImageURL() {
        return this.toResizedURL(this.profileImageUrl, "_bigger");
    }

    @Override
    public String getMiniProfileImageURL() {
        return this.toResizedURL(this.profileImageUrl, "_mini");
    }

    @Override
    public String getOriginalProfileImageURL() {
        return this.toResizedURL(this.profileImageUrl, "");
    }

    private String toResizedURL(String string, String string2) {
        if (null != string) {
            int n2 = string.lastIndexOf("_");
            int n3 = string.lastIndexOf(".");
            int n4 = string.lastIndexOf("/");
            String string3 = string.substring(0, n2) + string2;
            if (n3 > n4) {
                string3 = string3 + string.substring(n3);
            }
            return string3;
        }
        return null;
    }

    @Override
    public String getProfileImageURLHttps() {
        return this.profileImageUrlHttps;
    }

    @Override
    public String getBiggerProfileImageURLHttps() {
        return this.toResizedURL(this.profileImageUrlHttps, "_bigger");
    }

    @Override
    public String getMiniProfileImageURLHttps() {
        return this.toResizedURL(this.profileImageUrlHttps, "_mini");
    }

    @Override
    public String getOriginalProfileImageURLHttps() {
        return this.toResizedURL(this.profileImageUrlHttps, "");
    }

    @Override
    public boolean isDefaultProfileImage() {
        return this.isDefaultProfileImage;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public int getFollowersCount() {
        return this.followersCount;
    }

    @Override
    public String getProfileBackgroundColor() {
        return this.profileBackgroundColor;
    }

    @Override
    public String getProfileTextColor() {
        return this.profileTextColor;
    }

    @Override
    public String getProfileLinkColor() {
        return this.profileLinkColor;
    }

    @Override
    public String getProfileSidebarFillColor() {
        return this.profileSidebarFillColor;
    }

    @Override
    public String getProfileSidebarBorderColor() {
        return this.profileSidebarBorderColor;
    }

    @Override
    public boolean isProfileUseBackgroundImage() {
        return this.profileUseBackgroundImage;
    }

    @Override
    public boolean isDefaultProfile() {
        return this.isDefaultProfile;
    }

    @Override
    public boolean isShowAllInlineMedia() {
        return this.showAllInlineMedia;
    }

    @Override
    public int getFriendsCount() {
        return this.friendsCount;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    @Override
    public int getUtcOffset() {
        return this.utcOffset;
    }

    @Override
    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public String getProfileBackgroundImageURL() {
        return this.profileBackgroundImageUrl;
    }

    @Override
    public String getProfileBackgroundImageUrlHttps() {
        return this.profileBackgroundImageUrlHttps;
    }

    @Override
    public String getProfileBannerURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/web" : null;
    }

    @Override
    public String getProfileBannerRetinaURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/web_retina" : null;
    }

    @Override
    public String getProfileBannerIPadURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/ipad" : null;
    }

    @Override
    public String getProfileBannerIPadRetinaURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/ipad_retina" : null;
    }

    @Override
    public String getProfileBannerMobileURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/mobile" : null;
    }

    @Override
    public String getProfileBannerMobileRetinaURL() {
        return this.profileBannerImageUrl != null ? this.profileBannerImageUrl + "/mobile_retina" : null;
    }

    @Override
    public boolean isProfileBackgroundTiled() {
        return this.profileBackgroundTiled;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public int getStatusesCount() {
        return this.statusesCount;
    }

    @Override
    public boolean isGeoEnabled() {
        return this.isGeoEnabled;
    }

    @Override
    public boolean isVerified() {
        return this.isVerified;
    }

    @Override
    public boolean isTranslator() {
        return this.translator;
    }

    @Override
    public int getListedCount() {
        return this.listedCount;
    }

    @Override
    public boolean isFollowRequestSent() {
        return this.isFollowRequestSent;
    }

    @Override
    public URLEntity[] getDescriptionURLEntities() {
        return this.descriptionURLEntities;
    }

    @Override
    public URLEntity getURLEntity() {
        if (this.urlEntity == null) {
            String string = this.url == null ? "" : this.url;
            this.urlEntity = new URLEntityJSONImpl(0, string.length(), string, string, string);
        }
        return this.urlEntity;
    }

    @Override
    public String[] getWithheldInCountries() {
        return this.withheldInCountries;
    }

    static PagableResponseList<User> createPagableUserList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("users");
            int n2 = jSONArray.length();
            PagableResponseListImpl<User> pagableResponseListImpl = new PagableResponseListImpl<User>(n2, jSONObject, httpResponse);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                UserJSONImpl userJSONImpl = new UserJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    TwitterObjectFactory.registerJSONObject(userJSONImpl, jSONObject2);
                }
                pagableResponseListImpl.add(userJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(pagableResponseListImpl, jSONObject);
            }
            return pagableResponseListImpl;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    static ResponseList<User> createUserList(HttpResponse httpResponse, Configuration configuration) {
        return UserJSONImpl.createUserList(httpResponse.asJSONArray(), httpResponse, configuration);
    }

    static ResponseList<User> createUserList(JSONArray jSONArray, HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.clearThreadLocalMap();
            }
            int n2 = jSONArray.length();
            ResponseListImpl<User> responseListImpl = new ResponseListImpl<User>(n2, httpResponse);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                UserJSONImpl userJSONImpl = new UserJSONImpl(jSONObject);
                responseListImpl.add(userJSONImpl);
                if (!configuration.isJSONStoreEnabled()) continue;
                TwitterObjectFactory.registerJSONObject(userJSONImpl, jSONObject);
            }
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return object instanceof User && ((User)object).getId() == this.id;
    }

    public String toString() {
        return "UserJSONImpl{id=" + this.id + ", name='" + this.name + '\'' + ", screenName='" + this.screenName + '\'' + ", location='" + this.location + '\'' + ", description='" + this.description + '\'' + ", isContributorsEnabled=" + this.isContributorsEnabled + ", profileImageUrl='" + this.profileImageUrl + '\'' + ", profileImageUrlHttps='" + this.profileImageUrlHttps + '\'' + ", isDefaultProfileImage=" + this.isDefaultProfileImage + ", url='" + this.url + '\'' + ", isProtected=" + this.isProtected + ", followersCount=" + this.followersCount + ", status=" + this.status + ", profileBackgroundColor='" + this.profileBackgroundColor + '\'' + ", profileTextColor='" + this.profileTextColor + '\'' + ", profileLinkColor='" + this.profileLinkColor + '\'' + ", profileSidebarFillColor='" + this.profileSidebarFillColor + '\'' + ", profileSidebarBorderColor='" + this.profileSidebarBorderColor + '\'' + ", profileUseBackgroundImage=" + this.profileUseBackgroundImage + ", isDefaultProfile=" + this.isDefaultProfile + ", showAllInlineMedia=" + this.showAllInlineMedia + ", friendsCount=" + this.friendsCount + ", createdAt=" + this.createdAt + ", favouritesCount=" + this.favouritesCount + ", utcOffset=" + this.utcOffset + ", timeZone='" + this.timeZone + '\'' + ", profileBackgroundImageUrl='" + this.profileBackgroundImageUrl + '\'' + ", profileBackgroundImageUrlHttps='" + this.profileBackgroundImageUrlHttps + '\'' + ", profileBackgroundTiled=" + this.profileBackgroundTiled + ", lang='" + this.lang + '\'' + ", statusesCount=" + this.statusesCount + ", isGeoEnabled=" + this.isGeoEnabled + ", isVerified=" + this.isVerified + ", translator=" + this.translator + ", listedCount=" + this.listedCount + ", isFollowRequestSent=" + this.isFollowRequestSent + ", withheldInCountries=" + Arrays.toString(this.withheldInCountries) + '}';
    }
}

