/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.JSONArray;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.MediaEntity;
import be.maximvdw.tabcore.twitter.MediaEntityJSONImpl;
import be.maximvdw.tabcore.twitter.ParseUtil;
import be.maximvdw.tabcore.twitter.TwitterAPIConfiguration;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.TwitterObjectFactory;
import be.maximvdw.tabcore.twitter.TwitterResponseImpl;
import be.maximvdw.tabcore.twitter.conf.Configuration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TwitterAPIConfigurationJSONImpl
extends TwitterResponseImpl
implements TwitterAPIConfiguration {
    private static final long serialVersionUID = -3588904550808591686L;
    private int photoSizeLimit;
    private int shortURLLength;
    private int shortURLLengthHttps;
    private int charactersReservedPerMedia;
    private Map<Integer, MediaEntity.Size> photoSizes;
    private String[] nonUsernamePaths;
    private int maxMediaPerUpload;

    TwitterAPIConfigurationJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        try {
            JSONObject jSONObject = httpResponse.asJSONObject();
            this.photoSizeLimit = ParseUtil.getInt("photo_size_limit", jSONObject);
            this.shortURLLength = ParseUtil.getInt("short_url_length", jSONObject);
            this.shortURLLengthHttps = ParseUtil.getInt("short_url_length_https", jSONObject);
            this.charactersReservedPerMedia = ParseUtil.getInt("characters_reserved_per_media", jSONObject);
            JSONObject jSONObject2 = jSONObject.getJSONObject("photo_sizes");
            this.photoSizes = new HashMap<Integer, MediaEntity.Size>(4);
            this.photoSizes.put(MediaEntity.Size.LARGE, new MediaEntityJSONImpl.Size(jSONObject2.getJSONObject("large")));
            JSONObject jSONObject3 = jSONObject2.isNull("med") ? jSONObject2.getJSONObject("medium") : jSONObject2.getJSONObject("med");
            this.photoSizes.put(MediaEntity.Size.MEDIUM, new MediaEntityJSONImpl.Size(jSONObject3));
            this.photoSizes.put(MediaEntity.Size.SMALL, new MediaEntityJSONImpl.Size(jSONObject2.getJSONObject("small")));
            this.photoSizes.put(MediaEntity.Size.THUMB, new MediaEntityJSONImpl.Size(jSONObject2.getJSONObject("thumb")));
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.clearThreadLocalMap();
                TwitterObjectFactory.registerJSONObject(this, httpResponse.asJSONObject());
            }
            JSONArray jSONArray = jSONObject.getJSONArray("non_username_paths");
            this.nonUsernamePaths = new String[jSONArray.length()];
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                this.nonUsernamePaths[i2] = jSONArray.getString(i2);
            }
            this.maxMediaPerUpload = ParseUtil.getInt("max_media_per_upload", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    @Override
    public int getPhotoSizeLimit() {
        return this.photoSizeLimit;
    }

    @Override
    public int getShortURLLength() {
        return this.shortURLLength;
    }

    @Override
    public int getShortURLLengthHttps() {
        return this.shortURLLengthHttps;
    }

    @Override
    public int getCharactersReservedPerMedia() {
        return this.charactersReservedPerMedia;
    }

    @Override
    public Map<Integer, MediaEntity.Size> getPhotoSizes() {
        return this.photoSizes;
    }

    @Override
    public String[] getNonUsernamePaths() {
        return this.nonUsernamePaths;
    }

    @Override
    public int getMaxMediaPerUpload() {
        return this.maxMediaPerUpload;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TwitterAPIConfigurationJSONImpl)) {
            return false;
        }
        TwitterAPIConfigurationJSONImpl twitterAPIConfigurationJSONImpl = (TwitterAPIConfigurationJSONImpl)object;
        if (this.charactersReservedPerMedia != twitterAPIConfigurationJSONImpl.charactersReservedPerMedia) {
            return false;
        }
        if (this.maxMediaPerUpload != twitterAPIConfigurationJSONImpl.maxMediaPerUpload) {
            return false;
        }
        if (this.photoSizeLimit != twitterAPIConfigurationJSONImpl.photoSizeLimit) {
            return false;
        }
        if (this.shortURLLength != twitterAPIConfigurationJSONImpl.shortURLLength) {
            return false;
        }
        if (this.shortURLLengthHttps != twitterAPIConfigurationJSONImpl.shortURLLengthHttps) {
            return false;
        }
        if (!Arrays.equals(this.nonUsernamePaths, twitterAPIConfigurationJSONImpl.nonUsernamePaths)) {
            return false;
        }
        return !(this.photoSizes != null ? !this.photoSizes.equals(twitterAPIConfigurationJSONImpl.photoSizes) : twitterAPIConfigurationJSONImpl.photoSizes != null);
    }

    public int hashCode() {
        int n2 = this.photoSizeLimit;
        n2 = 31 * n2 + this.shortURLLength;
        n2 = 31 * n2 + this.shortURLLengthHttps;
        n2 = 31 * n2 + this.charactersReservedPerMedia;
        n2 = 31 * n2 + (this.photoSizes != null ? this.photoSizes.hashCode() : 0);
        n2 = 31 * n2 + (this.nonUsernamePaths != null ? Arrays.hashCode(this.nonUsernamePaths) : 0);
        n2 = 31 * n2 + this.maxMediaPerUpload;
        return n2;
    }

    public String toString() {
        return "TwitterAPIConfigurationJSONImpl{photoSizeLimit=" + this.photoSizeLimit + ", shortURLLength=" + this.shortURLLength + ", shortURLLengthHttps=" + this.shortURLLengthHttps + ", charactersReservedPerMedia=" + this.charactersReservedPerMedia + ", photoSizes=" + this.photoSizes + ", nonUsernamePaths=" + (this.nonUsernamePaths == null ? null : Arrays.asList(this.nonUsernamePaths)) + ", maxMediaPerUpload=" + this.maxMediaPerUpload + '}';
    }
}

