/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.JSONArray;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.ParseUtil;
import be.maximvdw.tabcore.twitter.Relationship;
import be.maximvdw.tabcore.twitter.ResponseList;
import be.maximvdw.tabcore.twitter.ResponseListImpl;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.TwitterObjectFactory;
import be.maximvdw.tabcore.twitter.TwitterResponseImpl;
import be.maximvdw.tabcore.twitter.conf.Configuration;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RelationshipJSONImpl
extends TwitterResponseImpl
implements Relationship,
Serializable {
    private static final long serialVersionUID = -2001484553401916448L;
    private final long targetUserId;
    private final String targetUserScreenName;
    private final boolean sourceBlockingTarget;
    private final boolean sourceNotificationsEnabled;
    private final boolean sourceFollowingTarget;
    private final boolean sourceFollowedByTarget;
    private final boolean sourceCanDm;
    private final boolean sourceMutingTarget;
    private final long sourceUserId;
    private final String sourceUserScreenName;
    private boolean wantRetweets;

    RelationshipJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        this(httpResponse, httpResponse.asJSONObject());
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, httpResponse.asJSONObject());
        }
    }

    RelationshipJSONImpl(JSONObject jSONObject) {
        this(null, jSONObject);
    }

    RelationshipJSONImpl(HttpResponse httpResponse, JSONObject jSONObject) {
        super(httpResponse);
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject("relationship");
            JSONObject jSONObject3 = jSONObject2.getJSONObject("source");
            JSONObject jSONObject4 = jSONObject2.getJSONObject("target");
            this.sourceUserId = ParseUtil.getLong("id", jSONObject3);
            this.targetUserId = ParseUtil.getLong("id", jSONObject4);
            this.sourceUserScreenName = ParseUtil.getUnescapedString("screen_name", jSONObject3);
            this.targetUserScreenName = ParseUtil.getUnescapedString("screen_name", jSONObject4);
            this.sourceBlockingTarget = ParseUtil.getBoolean("blocking", jSONObject3);
            this.sourceFollowingTarget = ParseUtil.getBoolean("following", jSONObject3);
            this.sourceFollowedByTarget = ParseUtil.getBoolean("followed_by", jSONObject3);
            this.sourceCanDm = ParseUtil.getBoolean("can_dm", jSONObject3);
            this.sourceMutingTarget = ParseUtil.getBoolean("muting", jSONObject3);
            this.sourceNotificationsEnabled = ParseUtil.getBoolean("notifications_enabled", jSONObject3);
            this.wantRetweets = ParseUtil.getBoolean("want_retweets", jSONObject3);
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    static ResponseList<Relationship> createRelationshipList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.clearThreadLocalMap();
            }
            JSONArray jSONArray = httpResponse.asJSONArray();
            int n2 = jSONArray.length();
            ResponseListImpl<Relationship> responseListImpl = new ResponseListImpl<Relationship>(n2, httpResponse);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                RelationshipJSONImpl relationshipJSONImpl = new RelationshipJSONImpl(jSONObject);
                if (configuration.isJSONStoreEnabled()) {
                    TwitterObjectFactory.registerJSONObject(relationshipJSONImpl, jSONObject);
                }
                responseListImpl.add(relationshipJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    @Override
    public long getSourceUserId() {
        return this.sourceUserId;
    }

    @Override
    public long getTargetUserId() {
        return this.targetUserId;
    }

    @Override
    public boolean isSourceBlockingTarget() {
        return this.sourceBlockingTarget;
    }

    @Override
    public String getSourceUserScreenName() {
        return this.sourceUserScreenName;
    }

    @Override
    public String getTargetUserScreenName() {
        return this.targetUserScreenName;
    }

    @Override
    public boolean isSourceFollowingTarget() {
        return this.sourceFollowingTarget;
    }

    @Override
    public boolean isTargetFollowingSource() {
        return this.sourceFollowedByTarget;
    }

    @Override
    public boolean isSourceFollowedByTarget() {
        return this.sourceFollowedByTarget;
    }

    @Override
    public boolean isTargetFollowedBySource() {
        return this.sourceFollowingTarget;
    }

    @Override
    public boolean canSourceDm() {
        return this.sourceCanDm;
    }

    @Override
    public boolean isSourceMutingTarget() {
        return this.sourceMutingTarget;
    }

    @Override
    public boolean isSourceNotificationsEnabled() {
        return this.sourceNotificationsEnabled;
    }

    @Override
    public boolean isSourceWantRetweets() {
        return this.wantRetweets;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RelationshipJSONImpl relationshipJSONImpl = (RelationshipJSONImpl)object;
        if (this.sourceBlockingTarget != relationshipJSONImpl.sourceBlockingTarget) {
            return false;
        }
        if (this.sourceCanDm != relationshipJSONImpl.sourceCanDm) {
            return false;
        }
        if (this.sourceFollowedByTarget != relationshipJSONImpl.sourceFollowedByTarget) {
            return false;
        }
        if (this.sourceFollowingTarget != relationshipJSONImpl.sourceFollowingTarget) {
            return false;
        }
        if (this.sourceMutingTarget != relationshipJSONImpl.sourceMutingTarget) {
            return false;
        }
        if (this.sourceNotificationsEnabled != relationshipJSONImpl.sourceNotificationsEnabled) {
            return false;
        }
        if (this.sourceUserId != relationshipJSONImpl.sourceUserId) {
            return false;
        }
        if (this.targetUserId != relationshipJSONImpl.targetUserId) {
            return false;
        }
        if (this.wantRetweets != relationshipJSONImpl.wantRetweets) {
            return false;
        }
        if (this.sourceUserScreenName != null ? !this.sourceUserScreenName.equals(relationshipJSONImpl.sourceUserScreenName) : relationshipJSONImpl.sourceUserScreenName != null) {
            return false;
        }
        return !(this.targetUserScreenName != null ? !this.targetUserScreenName.equals(relationshipJSONImpl.targetUserScreenName) : relationshipJSONImpl.targetUserScreenName != null);
    }

    public int hashCode() {
        int n2 = (int)(this.targetUserId ^ this.targetUserId >>> 32);
        n2 = 31 * n2 + (this.targetUserScreenName != null ? this.targetUserScreenName.hashCode() : 0);
        n2 = 31 * n2 + (this.sourceBlockingTarget ? 1 : 0);
        n2 = 31 * n2 + (this.sourceNotificationsEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.sourceFollowingTarget ? 1 : 0);
        n2 = 31 * n2 + (this.sourceFollowedByTarget ? 1 : 0);
        n2 = 31 * n2 + (this.sourceCanDm ? 1 : 0);
        n2 = 31 * n2 + (this.sourceMutingTarget ? 1 : 0);
        n2 = 31 * n2 + (int)(this.sourceUserId ^ this.sourceUserId >>> 32);
        n2 = 31 * n2 + (this.sourceUserScreenName != null ? this.sourceUserScreenName.hashCode() : 0);
        n2 = 31 * n2 + (this.wantRetweets ? 1 : 0);
        return n2;
    }

    public String toString() {
        return "RelationshipJSONImpl{targetUserId=" + this.targetUserId + ", targetUserScreenName='" + this.targetUserScreenName + '\'' + ", sourceBlockingTarget=" + this.sourceBlockingTarget + ", sourceNotificationsEnabled=" + this.sourceNotificationsEnabled + ", sourceFollowingTarget=" + this.sourceFollowingTarget + ", sourceFollowedByTarget=" + this.sourceFollowedByTarget + ", sourceCanDm=" + this.sourceCanDm + ", sourceMutingTarget=" + this.sourceMutingTarget + ", sourceUserId=" + this.sourceUserId + ", sourceUserScreenName='" + this.sourceUserScreenName + '\'' + ", wantRetweets=" + this.wantRetweets + '}';
    }
}

