/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.OEmbed;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.TwitterObjectFactory;
import be.maximvdw.tabcore.twitter.TwitterResponseImpl;
import be.maximvdw.tabcore.twitter.conf.Configuration;
import java.io.Serializable;

public class OEmbedJSONImpl
extends TwitterResponseImpl
implements OEmbed,
Serializable {
    private static final long serialVersionUID = -2207801480251709819L;
    private String html;
    private String authorName;
    private String url;
    private String version;
    private long cacheAge;
    private String authorURL;
    private int width;

    OEmbedJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, jSONObject);
        }
    }

    OEmbedJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            this.html = jSONObject.getString("html");
            this.authorName = jSONObject.getString("author_name");
            this.url = jSONObject.getString("url");
            this.version = jSONObject.getString("version");
            this.cacheAge = jSONObject.getLong("cache_age");
            this.authorURL = jSONObject.getString("author_url");
            this.width = jSONObject.getInt("width");
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public String getHtml() {
        return this.html;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getURL() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public long getCacheAge() {
        return this.cacheAge;
    }

    public String getAuthorURL() {
        return this.authorURL;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OEmbedJSONImpl oEmbedJSONImpl = (OEmbedJSONImpl)object;
        if (this.cacheAge != oEmbedJSONImpl.cacheAge) {
            return false;
        }
        if (this.width != oEmbedJSONImpl.width) {
            return false;
        }
        if (this.authorName != null ? !this.authorName.equals(oEmbedJSONImpl.authorName) : oEmbedJSONImpl.authorName != null) {
            return false;
        }
        if (this.authorURL != null ? !this.authorURL.equals(oEmbedJSONImpl.authorURL) : oEmbedJSONImpl.authorURL != null) {
            return false;
        }
        if (this.html != null ? !this.html.equals(oEmbedJSONImpl.html) : oEmbedJSONImpl.html != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(oEmbedJSONImpl.url) : oEmbedJSONImpl.url != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(oEmbedJSONImpl.version) : oEmbedJSONImpl.version != null);
    }

    public int hashCode() {
        int n2 = this.html != null ? this.html.hashCode() : 0;
        n2 = 31 * n2 + (this.authorName != null ? this.authorName.hashCode() : 0);
        n2 = 31 * n2 + (this.url != null ? this.url.hashCode() : 0);
        n2 = 31 * n2 + (this.version != null ? this.version.hashCode() : 0);
        n2 = 31 * n2 + (int)(this.cacheAge ^ this.cacheAge >>> 32);
        n2 = 31 * n2 + (this.authorURL != null ? this.authorURL.hashCode() : 0);
        n2 = 31 * n2 + this.width;
        return n2;
    }

    public String toString() {
        return "OEmbedJSONImpl{html='" + this.html + '\'' + ", authorName='" + this.authorName + '\'' + ", url='" + this.url + '\'' + ", version='" + this.version + '\'' + ", cacheAge=" + this.cacheAge + ", authorURL='" + this.authorURL + '\'' + ", width=" + this.width + '}';
    }
}

