/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.IDs;
import be.maximvdw.tabcore.twitter.JSONArray;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.ParseUtil;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.TwitterObjectFactory;
import be.maximvdw.tabcore.twitter.TwitterResponseImpl;
import be.maximvdw.tabcore.twitter.conf.Configuration;
import java.util.Arrays;

final class IDsJSONImpl
extends TwitterResponseImpl
implements IDs {
    private static final long serialVersionUID = 6999637496007165672L;
    private long[] ids;
    private long previousCursor = -1L;
    private long nextCursor = -1L;

    IDsJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        String string = httpResponse.asString();
        this.init(string);
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, string);
        }
    }

    IDsJSONImpl(String string) {
        this.init(string);
    }

    private void init(String string) {
        try {
            if (string.startsWith("{")) {
                JSONObject jSONObject = new JSONObject(string);
                JSONArray jSONArray = jSONObject.getJSONArray("ids");
                this.ids = new long[jSONArray.length()];
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    try {
                        this.ids[i2] = Long.parseLong(jSONArray.getString(i2));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new TwitterException("Twitter API returned malformed response: " + jSONObject, numberFormatException);
                    }
                }
                this.previousCursor = ParseUtil.getLong("previous_cursor", jSONObject);
                this.nextCursor = ParseUtil.getLong("next_cursor", jSONObject);
            } else {
                JSONArray jSONArray = new JSONArray(string);
                this.ids = new long[jSONArray.length()];
                for (int i3 = 0; i3 < jSONArray.length(); ++i3) {
                    try {
                        this.ids[i3] = Long.parseLong(jSONArray.getString(i3));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new TwitterException("Twitter API returned malformed response: " + jSONArray, numberFormatException);
                    }
                }
            }
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public long[] getIDs() {
        return this.ids;
    }

    public boolean hasPrevious() {
        return 0L != this.previousCursor;
    }

    public long getPreviousCursor() {
        return this.previousCursor;
    }

    public boolean hasNext() {
        return 0L != this.nextCursor;
    }

    public long getNextCursor() {
        return this.nextCursor;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IDs)) {
            return false;
        }
        IDs iDs = (IDs)object;
        return Arrays.equals(this.ids, iDs.getIDs());
    }

    public int hashCode() {
        return this.ids != null ? Arrays.hashCode(this.ids) : 0;
    }

    public String toString() {
        return "IDsJSONImpl{ids=" + Arrays.toString(this.ids) + ", previousCursor=" + this.previousCursor + ", nextCursor=" + this.nextCursor + '}';
    }
}

