/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.HttpParameter;
import be.maximvdw.tabcore.twitter.RequestMethod;
import be.maximvdw.tabcore.twitter.auth.Authorization;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpRequest
implements Serializable {
    private static final long serialVersionUID = 3365496352032493020L;
    private final RequestMethod method;
    private final String url;
    private final HttpParameter[] parameters;
    private final Authorization authorization;
    private final Map<String, String> requestHeaders;
    private static final HttpParameter[] NULL_PARAMETERS = new HttpParameter[0];

    public HttpRequest(RequestMethod requestMethod, String string, HttpParameter[] httpParameterArray, Authorization authorization, Map<String, String> map) {
        this.method = requestMethod;
        if (requestMethod != RequestMethod.POST && httpParameterArray != null && httpParameterArray.length != 0) {
            this.url = string + "?" + HttpParameter.encodeParameters(httpParameterArray);
            this.parameters = NULL_PARAMETERS;
        } else {
            this.url = string;
            this.parameters = httpParameterArray;
        }
        this.authorization = authorization;
        this.requestHeaders = map;
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public HttpParameter[] getParameters() {
        return this.parameters;
    }

    public String getURL() {
        return this.url;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HttpRequest httpRequest = (HttpRequest)object;
        if (this.authorization != null ? !this.authorization.equals(httpRequest.authorization) : httpRequest.authorization != null) {
            return false;
        }
        if (!Arrays.equals(this.parameters, httpRequest.parameters)) {
            return false;
        }
        if (this.requestHeaders != null ? !this.requestHeaders.equals(httpRequest.requestHeaders) : httpRequest.requestHeaders != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals((Object)httpRequest.method) : httpRequest.method != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(httpRequest.url) : httpRequest.url != null);
    }

    public int hashCode() {
        int n2 = this.method != null ? this.method.hashCode() : 0;
        n2 = 31 * n2 + (this.url != null ? this.url.hashCode() : 0);
        n2 = 31 * n2 + (this.parameters != null ? Arrays.hashCode(this.parameters) : 0);
        n2 = 31 * n2 + (this.authorization != null ? this.authorization.hashCode() : 0);
        n2 = 31 * n2 + (this.requestHeaders != null ? this.requestHeaders.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "HttpRequest{requestMethod=" + (Object)((Object)this.method) + ", url='" + this.url + '\'' + ", postParams=" + (this.parameters == null ? null : Arrays.asList(this.parameters)) + ", authentication=" + this.authorization + ", requestHeaders=" + this.requestHeaders + '}';
    }
}

