/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.ExtendedMediaEntity;
import be.maximvdw.tabcore.twitter.JSONArray;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.MediaEntityJSONImpl;
import be.maximvdw.tabcore.twitter.TwitterException;
import java.util.Arrays;

public class ExtendedMediaEntityJSONImpl
extends MediaEntityJSONImpl
implements ExtendedMediaEntity {
    private static final long serialVersionUID = -3889082303259253211L;
    private int videoAspectRatioWidth;
    private int videoAspectRatioHeight;
    private long videoDurationMillis;
    private Variant[] videoVariants;

    ExtendedMediaEntityJSONImpl(JSONObject jSONObject) {
        super(jSONObject);
        try {
            if (jSONObject.has("video_info")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("video_info");
                JSONArray jSONArray = jSONObject2.getJSONArray("aspect_ratio");
                this.videoAspectRatioWidth = jSONArray.getInt(0);
                this.videoAspectRatioHeight = jSONArray.getInt(1);
                if (!jSONObject2.isNull("duration_millis")) {
                    this.videoDurationMillis = jSONObject2.getLong("duration_millis");
                }
                JSONArray jSONArray2 = jSONObject2.getJSONArray("variants");
                this.videoVariants = new Variant[jSONArray2.length()];
                for (int i2 = 0; i2 < jSONArray2.length(); ++i2) {
                    this.videoVariants[i2] = new Variant(jSONArray2.getJSONObject(i2));
                }
            } else {
                this.videoVariants = new Variant[0];
            }
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    ExtendedMediaEntityJSONImpl() {
    }

    public int getVideoAspectRatioWidth() {
        return this.videoAspectRatioWidth;
    }

    public int getVideoAspectRatioHeight() {
        return this.videoAspectRatioHeight;
    }

    public long getVideoDurationMillis() {
        return this.videoDurationMillis;
    }

    public ExtendedMediaEntity.Variant[] getVideoVariants() {
        return this.videoVariants;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExtendedMediaEntityJSONImpl)) {
            return false;
        }
        ExtendedMediaEntityJSONImpl extendedMediaEntityJSONImpl = (ExtendedMediaEntityJSONImpl)object;
        return this.id == extendedMediaEntityJSONImpl.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "ExtendedMediaEntityJSONImpl{id=" + this.id + ", url=" + this.url + ", mediaURL=" + this.mediaURL + ", mediaURLHttps=" + this.mediaURLHttps + ", expandedURL=" + this.expandedURL + ", displayURL='" + this.displayURL + '\'' + ", sizes=" + this.sizes + ", type=" + this.type + ", videoAspectRatioWidth=" + this.videoAspectRatioWidth + ", videoAspectRatioHeight=" + this.videoAspectRatioHeight + ", videoDurationMillis=" + this.videoDurationMillis + ", videoVariants=" + Arrays.toString(this.videoVariants) + '}';
    }

    static class Variant
    implements ExtendedMediaEntity.Variant {
        private static final long serialVersionUID = 1027236588556797980L;
        int bitrate;
        String contentType;
        String url;

        Variant(JSONObject jSONObject) {
            this.bitrate = jSONObject.has("bitrate") ? jSONObject.getInt("bitrate") : 0;
            this.contentType = jSONObject.getString("content_type");
            this.url = jSONObject.getString("url");
        }

        Variant() {
        }

        public int getBitrate() {
            return this.bitrate;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Variant)) {
                return false;
            }
            Variant variant = (Variant)object;
            if (this.bitrate != variant.bitrate) {
                return false;
            }
            if (!this.contentType.equals(variant.contentType)) {
                return false;
            }
            return this.url.equals(variant.url);
        }

        public int hashCode() {
            int n2 = this.bitrate;
            n2 = 31 * n2 + (this.contentType != null ? this.contentType.hashCode() : 0);
            n2 = 31 * n2 + (this.url != null ? this.url.hashCode() : 0);
            return n2;
        }

        public String toString() {
            return "Variant{bitrate=" + this.bitrate + ", contentType=" + this.contentType + ", url=" + this.url + '}';
        }
    }
}

