/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.AccountSettings;
import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.JSONArray;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.Location;
import be.maximvdw.tabcore.twitter.LocationJSONImpl;
import be.maximvdw.tabcore.twitter.ParseUtil;
import be.maximvdw.tabcore.twitter.TimeZone;
import be.maximvdw.tabcore.twitter.TimeZoneJSONImpl;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.TwitterObjectFactory;
import be.maximvdw.tabcore.twitter.TwitterResponseImpl;
import be.maximvdw.tabcore.twitter.conf.Configuration;
import java.io.Serializable;

class AccountSettingsJSONImpl
extends TwitterResponseImpl
implements AccountSettings,
Serializable {
    private static final long serialVersionUID = 603189815663175766L;
    private final boolean SLEEP_TIME_ENABLED;
    private final String SLEEP_START_TIME;
    private final String SLEEP_END_TIME;
    private final Location[] TREND_LOCATION;
    private final boolean GEO_ENABLED;
    private final String LANGUAGE;
    private final TimeZone TIMEZONE;
    private final boolean ALWAYS_USE_HTTPS;
    private final boolean DISCOVERABLE_BY_EMAIL;
    private final String SCREEN_NAME;

    private AccountSettingsJSONImpl(HttpResponse httpResponse, JSONObject jSONObject) {
        super(httpResponse);
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject("sleep_time");
            this.SLEEP_TIME_ENABLED = ParseUtil.getBoolean("enabled", jSONObject2);
            this.SLEEP_START_TIME = jSONObject2.getString("start_time");
            this.SLEEP_END_TIME = jSONObject2.getString("end_time");
            if (jSONObject.isNull("trend_location")) {
                this.TREND_LOCATION = new Location[0];
            } else {
                JSONArray jSONArray = jSONObject.getJSONArray("trend_location");
                this.TREND_LOCATION = new Location[jSONArray.length()];
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    this.TREND_LOCATION[i2] = new LocationJSONImpl(jSONArray.getJSONObject(i2));
                }
            }
            this.GEO_ENABLED = ParseUtil.getBoolean("geo_enabled", jSONObject);
            this.LANGUAGE = jSONObject.getString("language");
            this.ALWAYS_USE_HTTPS = ParseUtil.getBoolean("always_use_https", jSONObject);
            this.DISCOVERABLE_BY_EMAIL = ParseUtil.getBoolean("discoverable_by_email", jSONObject);
            this.TIMEZONE = jSONObject.isNull("time_zone") ? null : new TimeZoneJSONImpl(jSONObject.getJSONObject("time_zone"));
            this.SCREEN_NAME = jSONObject.getString("screen_name");
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    AccountSettingsJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        this(httpResponse, httpResponse.asJSONObject());
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, httpResponse.asJSONObject());
        }
    }

    AccountSettingsJSONImpl(JSONObject jSONObject) {
        this(null, jSONObject);
    }

    public boolean isSleepTimeEnabled() {
        return this.SLEEP_TIME_ENABLED;
    }

    public String getSleepStartTime() {
        return this.SLEEP_START_TIME;
    }

    public String getSleepEndTime() {
        return this.SLEEP_END_TIME;
    }

    public Location[] getTrendLocations() {
        return this.TREND_LOCATION;
    }

    public boolean isGeoEnabled() {
        return this.GEO_ENABLED;
    }

    public boolean isDiscoverableByEmail() {
        return this.DISCOVERABLE_BY_EMAIL;
    }

    public boolean isAlwaysUseHttps() {
        return this.ALWAYS_USE_HTTPS;
    }

    public String getScreenName() {
        return this.SCREEN_NAME;
    }

    public String getLanguage() {
        return this.LANGUAGE;
    }

    public TimeZone getTimeZone() {
        return this.TIMEZONE;
    }
}

