/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.TestUser;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TestUserJSONImpl
implements TestUser,
Serializable {
    private static final long serialVersionUID = -5704997286478031118L;
    private String id;
    private String accessToken;
    private String loginUrl;
    private String email;
    private String password;

    TestUserJSONImpl(HttpResponse httpResponse) {
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
    }

    TestUserJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    static ResponseList<TestUser> createTestUserList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<TestUser> responseListImpl = new ResponseListImpl<TestUser>(n2, jSONObject, new TestUser[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                TestUserJSONImpl testUserJSONImpl = new TestUserJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(testUserJSONImpl, jSONObject2);
                }
                responseListImpl.add(testUserJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    private void init(JSONObject jSONObject) {
        this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
        this.accessToken = z_F4JInternalParseUtil.getRawString("access_token", jSONObject);
        this.loginUrl = z_F4JInternalParseUtil.getRawString("login_url", jSONObject);
        if (!jSONObject.isNull("email")) {
            this.email = z_F4JInternalParseUtil.getRawString("email", jSONObject);
        }
        if (!jSONObject.isNull("password")) {
            this.password = z_F4JInternalParseUtil.getRawString("password", jSONObject);
        }
    }

    @Override
    public int compareTo(TestUser testUser) {
        return this.id.compareTo(testUser.getId());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getLoginUrl() {
        return this.loginUrl;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TestUserJSONImpl testUserJSONImpl = (TestUserJSONImpl)object;
        return !(this.id == null ? testUserJSONImpl.id != null : !this.id.equals(testUserJSONImpl.id));
    }

    public String toString() {
        return "TestUserJSONImpl [id=" + this.id + ", accessToken=" + this.accessToken + ", loginUrl=" + this.loginUrl + ", email=" + this.email + ", password=" + this.password + "]";
    }
}

