/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.Category;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.Photo;
import be.maximvdw.tabcore.facebook.Post;
import be.maximvdw.tabcore.facebook.Privacy;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.Tag;
import be.maximvdw.tabcore.facebook.Tagged;
import be.maximvdw.tabcore.facebook.Video;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.CategoryJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.PhotoJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.PostJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.PrivacyJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.json.TagJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.VideoJSONImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedJSONImpl
extends FacebookResponseImpl
implements Tagged,
Serializable {
    private static final long serialVersionUID = -6025394310112011794L;
    private String id;
    private String type;
    private Post post;
    private Photo photo;
    private Video video;
    private String message;
    private Map<String, Tag[]> messageTags;
    private String objectId;
    private Privacy privacy;
    private List<Category> to;
    private Date updatedTime;

    TaggedJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    TaggedJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            Object object;
            Object object2;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            this.type = z_F4JInternalParseUtil.getRawString("type", jSONObject);
            if (this.type.equals("photo")) {
                this.photo = new PhotoJSONImpl(jSONObject);
            } else if (this.type.equals("video")) {
                this.video = new VideoJSONImpl(jSONObject);
            } else {
                this.post = new PostJSONImpl(jSONObject);
            }
            if (!jSONObject.isNull("message")) {
                this.message = z_F4JInternalParseUtil.getRawString("message", jSONObject);
            }
            if (!jSONObject.isNull("message_tags")) {
                object2 = jSONObject.getJSONObject("message_tags");
                this.messageTags = new HashMap<String, Tag[]>();
                Iterator iterator = ((JSONObject)object2).keys();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    JSONArray jSONArray = ((JSONObject)object2).getJSONArray((String)object);
                    Tag[] tagArray = new Tag[jSONArray.length()];
                    for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                        JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                        tagArray[i2] = new TagJSONImpl(jSONObject2);
                    }
                    this.messageTags.put((String)object, tagArray);
                }
            } else {
                this.messageTags = Collections.emptyMap();
            }
            if (!jSONObject.isNull("object_id")) {
                this.objectId = z_F4JInternalParseUtil.getRawString("object_id", jSONObject);
            }
            this.privacy = new PrivacyJSONImpl(jSONObject.getJSONObject("privacy"));
            if (!jSONObject.isNull("to")) {
                object2 = jSONObject.getJSONObject("to").getJSONArray("data");
                this.to = new ArrayList<Category>();
                for (int i3 = 0; i3 < ((JSONArray)object2).length(); ++i3) {
                    object = ((JSONArray)object2).getJSONObject(i3);
                    this.to.add(new CategoryJSONImpl((JSONObject)object));
                }
            } else {
                this.to = Collections.emptyList();
            }
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Post getPost() {
        return this.post;
    }

    @Override
    public Photo getPhoto() {
        return this.photo;
    }

    @Override
    public Video getVideo() {
        return this.video;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Map<String, Tag[]> getMessageTags() {
        return this.messageTags;
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public Privacy getPrivacy() {
        return this.privacy;
    }

    @Override
    public List<Category> getTo() {
        return this.to;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    static ResponseList<Tagged> createTaggedList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Tagged> responseListImpl = new ResponseListImpl<Tagged>(n2, jSONObject, new Tagged[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                TaggedJSONImpl taggedJSONImpl = new TaggedJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(taggedJSONImpl, jSONObject2);
                }
                responseListImpl.add(taggedJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TaggedJSONImpl)) {
            return false;
        }
        TaggedJSONImpl taggedJSONImpl = (TaggedJSONImpl)object;
        return !(this.id != null ? !this.id.equals(taggedJSONImpl.id) : taggedJSONImpl.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "TaggedJSONImpl{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", post=" + this.post + ", photo=" + this.photo + ", video=" + this.video + ", message='" + this.message + '\'' + ", messageTags=" + this.messageTags + ", objectId='" + this.objectId + '\'' + ", privacy=" + this.privacy + ", to=" + this.to + ", updatedTime=" + this.updatedTime + '}';
    }
}

