/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.Category;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.Place;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.CategoryJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlaceJSONImpl
extends FacebookResponseImpl
implements Place,
Serializable {
    private static final long serialVersionUID = 859565077681007052L;
    private String id;
    private String name;
    private List<Category> categories;
    private Place.Location location;

    PlaceJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    PlaceJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            Object object;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
            if (z_F4JInternalParseUtil.isJSONArray("category_list", jSONObject)) {
                object = jSONObject.getJSONArray("category_list");
                this.categories = new ArrayList<Category>();
                for (int i2 = 0; i2 < ((JSONArray)object).length(); ++i2) {
                    this.categories.add(new CategoryJSONImpl(((JSONArray)object).getJSONObject(i2)));
                }
            }
            if (z_F4JInternalParseUtil.isJSONObject("location", jSONObject)) {
                object = jSONObject.getJSONObject("location");
                this.location = new LocationJSONImpl((JSONObject)object);
            } else {
                this.location = new LocationJSONImpl(z_F4JInternalParseUtil.getRawString("location", jSONObject));
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Category> getCategories() {
        return this.categories;
    }

    @Override
    public Place.Location getLocation() {
        return this.location;
    }

    static ResponseList<Place> createPlaceList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Place> responseListImpl = new ResponseListImpl<Place>(n2, jSONObject, new Place[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                PlaceJSONImpl placeJSONImpl = new PlaceJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(placeJSONImpl, jSONObject2);
                }
                responseListImpl.add(placeJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PlaceJSONImpl placeJSONImpl = (PlaceJSONImpl)object;
        return !(this.id == null ? placeJSONImpl.id != null : !this.id.equals(placeJSONImpl.id));
    }

    public String toString() {
        return "PlaceJSONImpl{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", categories=" + this.categories + ", location=" + this.location + '}';
    }

    static final class LocationJSONImpl
    implements Place.Location,
    Serializable {
        private static final long serialVersionUID = 1578695411333203753L;
        private String street;
        private String city;
        private String state;
        private String country;
        private String zip;
        private Double latitude;
        private Double longitude;
        private String text;

        LocationJSONImpl(JSONObject jSONObject) {
            this.street = z_F4JInternalParseUtil.getRawString("street", jSONObject);
            this.city = z_F4JInternalParseUtil.getRawString("city", jSONObject);
            this.state = z_F4JInternalParseUtil.getRawString("state", jSONObject);
            this.country = z_F4JInternalParseUtil.getRawString("country", jSONObject);
            this.zip = z_F4JInternalParseUtil.getRawString("zip", jSONObject);
            this.latitude = z_F4JInternalParseUtil.getDouble("latitude", jSONObject);
            this.longitude = z_F4JInternalParseUtil.getDouble("longitude", jSONObject);
        }

        LocationJSONImpl(String string) {
            this.text = string;
        }

        public String getStreet() {
            return this.street;
        }

        public String getCity() {
            return this.city;
        }

        public String getState() {
            return this.state;
        }

        public String getCountry() {
            return this.country;
        }

        public String getZip() {
            return this.zip;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        public String getText() {
            return this.text;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof LocationJSONImpl)) {
                return false;
            }
            LocationJSONImpl locationJSONImpl = (LocationJSONImpl)object;
            if (this.city != null ? !this.city.equals(locationJSONImpl.city) : locationJSONImpl.city != null) {
                return false;
            }
            if (this.country != null ? !this.country.equals(locationJSONImpl.country) : locationJSONImpl.country != null) {
                return false;
            }
            if (this.latitude != null ? !this.latitude.equals(locationJSONImpl.latitude) : locationJSONImpl.latitude != null) {
                return false;
            }
            if (this.longitude != null ? !this.longitude.equals(locationJSONImpl.longitude) : locationJSONImpl.longitude != null) {
                return false;
            }
            if (this.state != null ? !this.state.equals(locationJSONImpl.state) : locationJSONImpl.state != null) {
                return false;
            }
            if (this.street != null ? !this.street.equals(locationJSONImpl.street) : locationJSONImpl.street != null) {
                return false;
            }
            if (this.text != null ? !this.text.equals(locationJSONImpl.text) : locationJSONImpl.text != null) {
                return false;
            }
            return !(this.zip != null ? !this.zip.equals(locationJSONImpl.zip) : locationJSONImpl.zip != null);
        }

        public int hashCode() {
            int n2 = this.street != null ? this.street.hashCode() : 0;
            n2 = 31 * n2 + (this.city != null ? this.city.hashCode() : 0);
            n2 = 31 * n2 + (this.state != null ? this.state.hashCode() : 0);
            n2 = 31 * n2 + (this.country != null ? this.country.hashCode() : 0);
            n2 = 31 * n2 + (this.zip != null ? this.zip.hashCode() : 0);
            n2 = 31 * n2 + (this.latitude != null ? this.latitude.hashCode() : 0);
            n2 = 31 * n2 + (this.longitude != null ? this.longitude.hashCode() : 0);
            n2 = 31 * n2 + (this.text != null ? this.text.hashCode() : 0);
            return n2;
        }

        public String toString() {
            return "LocationJSONImpl{street='" + this.street + '\'' + ", city='" + this.city + '\'' + ", state='" + this.state + '\'' + ", country='" + this.country + '\'' + ", zip='" + this.zip + '\'' + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", text='" + this.text + '\'' + '}';
        }
    }
}

