/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.Category;
import be.maximvdw.tabcore.facebook.Comment;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.Note;
import be.maximvdw.tabcore.facebook.PagableList;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.CategoryJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.CommentJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.PagableListImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NoteJSONImpl
extends FacebookResponseImpl
implements Note,
Serializable {
    private static final long serialVersionUID = -4829935468293079130L;
    private String id;
    private Category from;
    private String subject;
    private String message;
    private PagableList<Comment> comments;
    private Date createdTime;
    private Date updatedTime;
    private URL icon;

    NoteJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    NoteJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("from")) {
                jSONObject2 = jSONObject.getJSONObject("from");
                this.from = new CategoryJSONImpl(jSONObject2);
            }
            this.subject = z_F4JInternalParseUtil.getRawString("subject", jSONObject);
            this.message = z_F4JInternalParseUtil.getRawString("message", jSONObject);
            if (!jSONObject.isNull("comments")) {
                jSONObject2 = jSONObject.getJSONObject("comments");
                if (!jSONObject2.isNull("data")) {
                    JSONArray jSONArray = jSONObject2.getJSONArray("data");
                    int n2 = jSONArray.length();
                    this.comments = new PagableListImpl<Comment>(n2, jSONObject2, new Comment[0]);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        CommentJSONImpl commentJSONImpl = new CommentJSONImpl(jSONArray.getJSONObject(i2));
                        this.comments.add(commentJSONImpl);
                    }
                } else {
                    this.comments = new PagableListImpl<Comment>(1, jSONObject2, new Comment[0]);
                }
            } else {
                this.comments = new PagableListImpl<Comment>(0);
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", jSONObject);
            this.icon = z_F4JInternalParseUtil.getURL("icon", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getFrom() {
        return this.from;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    static ResponseList<Note> createNoteList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Note> responseListImpl = new ResponseListImpl<Note>(n2, jSONObject, new Note[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                NoteJSONImpl noteJSONImpl = new NoteJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(noteJSONImpl, jSONObject2);
                }
                responseListImpl.add(noteJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NoteJSONImpl noteJSONImpl = (NoteJSONImpl)object;
        return !(this.id == null ? noteJSONImpl.id != null : !this.id.equals(noteJSONImpl.id));
    }

    public String toString() {
        return "NoteJSONImpl [id=" + this.id + ", from=" + this.from + ", subject=" + this.subject + ", message=" + this.message + ", comments=" + this.comments + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", icon=" + this.icon + "]";
    }
}

