/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.Insight;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InsightJSONImpl
extends FacebookResponseImpl
implements Insight,
Serializable {
    private static final long serialVersionUID = 5220288371199505577L;
    private String id;
    private String name;
    private String period;
    private List<Insight.Value> values;
    private String title;
    private String description;

    InsightJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    InsightJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
        this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
        this.period = z_F4JInternalParseUtil.getRawString("period", jSONObject);
        this.values = this.createValueList(jSONObject);
        this.title = z_F4JInternalParseUtil.getRawString("title", jSONObject);
        this.description = z_F4JInternalParseUtil.getRawString("description", jSONObject);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPeriod() {
        return this.period;
    }

    @Override
    public List<Insight.Value> getValues() {
        return this.values;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    static ResponseList<Insight> createInsightList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Insight> responseListImpl = new ResponseListImpl<Insight>(n2, jSONObject, new Insight[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                InsightJSONImpl insightJSONImpl = new InsightJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(insightJSONImpl, jSONObject2);
                }
                responseListImpl.add(insightJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        InsightJSONImpl insightJSONImpl = (InsightJSONImpl)object;
        return !(this.id == null ? insightJSONImpl.id != null : !this.id.equals(insightJSONImpl.id));
    }

    public String toString() {
        return "InsightJSONImpl [id=" + this.id + ", name=" + this.name + ", period=" + this.period + ", values=" + this.values + ", title=" + this.title + ", description=" + this.description + "]";
    }

    private List<Insight.Value> createValueList(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("values");
            int n2 = jSONArray.length();
            ArrayList<Insight.Value> arrayList = new ArrayList<Insight.Value>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                ValueJSONImpl valueJSONImpl = new ValueJSONImpl(jSONArray.getJSONObject(i2));
                arrayList.add(valueJSONImpl);
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    private final class ValueJSONImpl
    implements Insight.Value,
    Serializable {
        private static final long serialVersionUID = 764579592511865193L;
        private Insight.Value.Entry value;
        private Date endTime;

        ValueJSONImpl(JSONObject jSONObject) {
            this.value = new ValueEntryJSONImpl(jSONObject);
            this.endTime = z_F4JInternalParseUtil.getISO8601Datetime("end_time", jSONObject);
        }

        public Insight.Value.Entry getValue() {
            return this.value;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public String toString() {
            return "ValueJSONImpl [value=" + this.value + ", endTime=" + this.endTime + "]";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ValueEntryJSONImpl
        implements Insight.Value.Entry,
        Serializable {
            private Map<String, Long> value;

            ValueEntryJSONImpl(JSONObject jSONObject) {
                String string = z_F4JInternalParseUtil.getRawString("value", jSONObject);
                if (string.startsWith("{")) {
                    this.value = z_F4JInternalParseUtil.getLongMap("value", jSONObject);
                } else {
                    this.value = new HashMap<String, Long>();
                    this.value.put("", z_F4JInternalParseUtil.getLong("value", jSONObject));
                }
            }

            @Override
            public Long get() {
                return this.value.values().iterator().next();
            }

            @Override
            public Long get(String string) {
                return this.value.get(string);
            }

            @Override
            public Iterator<String> keys() {
                return this.value.keySet().iterator();
            }

            @Override
            public int size() {
                return this.value.size();
            }
        }
    }
}

