/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.InboxResponseList;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InboxResponseListImpl<T>
extends ResponseListImpl<T>
implements InboxResponseList<T> {
    private static final long serialVersionUID = -392100352680662139L;
    private InboxResponseList.InboxSummary inboxSummary;

    InboxResponseListImpl(JSONObject jSONObject, T ... TArray) {
        super(jSONObject, TArray);
        this.init(jSONObject);
    }

    InboxResponseListImpl(int n2, JSONObject jSONObject, T ... TArray) {
        super(n2, jSONObject, TArray);
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            if (!jSONObject.isNull("summary")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("summary");
                this.inboxSummary = new InboxSummaryJSONImpl(jSONObject2);
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public InboxResponseList.InboxSummary getInboxSummary() {
        return this.inboxSummary;
    }

    @Override
    public String toString() {
        return "InboxResponseListImpl [summary=" + this.inboxSummary + "]";
    }

    private class InboxSummaryJSONImpl
    implements InboxResponseList.InboxSummary,
    Serializable {
        private static final long serialVersionUID = 1988071486977638655L;
        private Integer unseenCount;
        private Integer unreadCount;
        private Date updatedTime;

        public InboxSummaryJSONImpl(JSONObject jSONObject) {
            if (!jSONObject.isNull("unseen_count")) {
                this.unseenCount = z_F4JInternalParseUtil.getPrimitiveInt("unseen_count", jSONObject);
            }
            if (!jSONObject.isNull("unread_count")) {
                this.unreadCount = z_F4JInternalParseUtil.getPrimitiveInt("unread_count", jSONObject);
            }
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", jSONObject);
        }

        public Integer getUnseenCount() {
            return this.unseenCount;
        }

        public Integer getUnreadCount() {
            return this.unreadCount;
        }

        public Date getUpdatedTime() {
            return this.updatedTime;
        }

        public String toString() {
            return "SummaryJSONImpl [unseenCount=" + this.unseenCount + ", unreadCount=" + this.unreadCount + ", updatedTime=" + this.updatedTime + "]";
        }
    }
}

