/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.Album;
import be.maximvdw.tabcore.facebook.Category;
import be.maximvdw.tabcore.facebook.Comment;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.Like;
import be.maximvdw.tabcore.facebook.PagableList;
import be.maximvdw.tabcore.facebook.Place;
import be.maximvdw.tabcore.facebook.PrivacyType;
import be.maximvdw.tabcore.facebook.Reaction;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.CategoryJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.CommentJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.LikeJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.PagableListImpl;
import be.maximvdw.tabcore.facebook.internal.json.PlaceJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.ReactionJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AlbumJSONImpl
extends FacebookResponseImpl
implements Album,
Serializable {
    private static final long serialVersionUID = 4708626697445405636L;
    private String id;
    private Category from;
    private String name;
    private String description;
    private String location;
    private URL link;
    private String coverPhoto;
    private PrivacyType privacy;
    private Integer count;
    private String type;
    private Date createdTime;
    private Date updatedTime;
    private Boolean canUpload;
    private Place place;
    private PagableList<Like> likes;
    private PagableList<Comment> comments;
    private PagableList<Reaction> reactions;

    AlbumJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    AlbumJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            FacebookResponseImpl facebookResponseImpl;
            int n2;
            int n3;
            JSONArray jSONArray;
            JSONObject jSONObject2;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("from")) {
                jSONObject2 = jSONObject.getJSONObject("from");
                this.from = new CategoryJSONImpl(jSONObject2);
            }
            this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
            this.description = z_F4JInternalParseUtil.getRawString("description", jSONObject);
            this.location = z_F4JInternalParseUtil.getRawString("location", jSONObject);
            this.link = z_F4JInternalParseUtil.getURL("link", jSONObject);
            this.coverPhoto = z_F4JInternalParseUtil.getRawString("cover_photo", jSONObject);
            this.privacy = PrivacyType.getInstance(z_F4JInternalParseUtil.getRawString("privacy", jSONObject));
            this.count = z_F4JInternalParseUtil.getInt("count", jSONObject);
            this.type = z_F4JInternalParseUtil.getRawString("type", jSONObject);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", jSONObject);
            this.canUpload = z_F4JInternalParseUtil.getBoolean("can_upload", jSONObject);
            if (!jSONObject.isNull("place")) {
                jSONObject2 = jSONObject.getJSONObject("place");
                this.place = new PlaceJSONImpl(jSONObject2);
            }
            if (!jSONObject.isNull("likes")) {
                jSONObject2 = jSONObject.getJSONObject("likes");
                if (!jSONObject2.isNull("data")) {
                    jSONArray = jSONObject2.getJSONArray("data");
                    n3 = jSONArray.length();
                    this.likes = new PagableListImpl<Like>(n3, jSONObject2, new Like[0]);
                    for (n2 = 0; n2 < n3; ++n2) {
                        facebookResponseImpl = new LikeJSONImpl(jSONArray.getJSONObject(n2));
                        this.likes.add(facebookResponseImpl);
                    }
                } else {
                    this.likes = new PagableListImpl<Like>(1, jSONObject2, new Like[0]);
                }
            } else {
                this.likes = new PagableListImpl<Like>(0);
            }
            if (!jSONObject.isNull("comments")) {
                jSONObject2 = jSONObject.getJSONObject("comments");
                if (!jSONObject2.isNull("data")) {
                    jSONArray = jSONObject2.getJSONArray("data");
                    n3 = jSONArray.length();
                    this.comments = new PagableListImpl<Comment>(n3, jSONObject2, new Comment[0]);
                    for (n2 = 0; n2 < n3; ++n2) {
                        facebookResponseImpl = new CommentJSONImpl(jSONArray.getJSONObject(n2));
                        this.comments.add(facebookResponseImpl);
                    }
                } else {
                    this.comments = new PagableListImpl<Comment>(1, jSONObject2, new Comment[0]);
                }
            } else {
                this.comments = new PagableListImpl<Comment>(0);
            }
            if (!jSONObject.isNull("reactions")) {
                jSONObject2 = jSONObject.getJSONObject("reactions");
                if (!jSONObject2.isNull("data")) {
                    jSONArray = jSONObject2.getJSONArray("data");
                    n3 = jSONArray.length();
                    this.reactions = new PagableListImpl<Reaction>(n3, jSONObject2, new Reaction[0]);
                    for (n2 = 0; n2 < n3; ++n2) {
                        facebookResponseImpl = new ReactionJSONImpl(jSONArray.getJSONObject(n2));
                        this.reactions.add(facebookResponseImpl);
                    }
                } else {
                    this.reactions = new PagableListImpl<Reaction>(1, jSONObject2, new Reaction[0]);
                }
            } else {
                this.reactions = new PagableListImpl<Reaction>(0);
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getFrom() {
        return this.from;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public String getCoverPhoto() {
        return this.coverPhoto;
    }

    @Override
    public PrivacyType getPrivacy() {
        return this.privacy;
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public Boolean canUpload() {
        return this.canUpload;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public PagableList<Like> getLikes() {
        return this.likes;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public PagableList<Reaction> getReactions() {
        return this.reactions;
    }

    static ResponseList<Album> createAlbumList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Album> responseListImpl = new ResponseListImpl<Album>(n2, jSONObject, new Album[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                AlbumJSONImpl albumJSONImpl = new AlbumJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(albumJSONImpl, jSONObject2);
                }
                responseListImpl.add(albumJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AlbumJSONImpl albumJSONImpl = (AlbumJSONImpl)object;
        return !(this.id == null ? albumJSONImpl.id != null : !this.id.equals(albumJSONImpl.id));
    }

    public String toString() {
        return "AlbumJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", location='" + this.location + '\'' + ", link=" + this.link + ", coverPhoto='" + this.coverPhoto + '\'' + ", privacy=" + (Object)((Object)this.privacy) + ", count=" + this.count + ", type='" + this.type + '\'' + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", canUpload=" + this.canUpload + ", place=" + this.place + ", likes=" + this.likes + ", comments=" + this.comments + '}';
    }
}

