/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.http;

import be.maximvdw.tabcore.facebook.auth.AccessToken;
import be.maximvdw.tabcore.facebook.auth.Authorization;
import be.maximvdw.tabcore.facebook.auth.OAuthAuthorization;
import be.maximvdw.tabcore.facebook.internal.http.HttpParameter;
import be.maximvdw.tabcore.facebook.internal.http.RequestMethod;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpRequest
implements Serializable {
    private final RequestMethod method;
    private final String url;
    private final HttpParameter[] parameters;
    private final Authorization authorization;
    private Map<String, String> requestHeaders;
    private static final long serialVersionUID = -3463594029098858381L;
    private static final HttpParameter[] NULL_PARAMETERS = new HttpParameter[0];

    public HttpRequest(RequestMethod requestMethod, String string, HttpParameter[] httpParameterArray, Authorization authorization, Map<String, String> map) {
        this.method = requestMethod;
        httpParameterArray = this.setAccessTokenParameter(httpParameterArray, authorization);
        httpParameterArray = this.setAppSecretProofParameter(httpParameterArray, authorization);
        if (requestMethod != RequestMethod.POST && httpParameterArray != null && httpParameterArray.length != 0) {
            this.url = string.contains("?") ? string + "&" + HttpParameter.encodeParameters(httpParameterArray) : string + "?" + HttpParameter.encodeParameters(httpParameterArray);
            this.parameters = NULL_PARAMETERS;
        } else {
            this.url = string;
            this.parameters = httpParameterArray == null ? NULL_PARAMETERS : httpParameterArray;
        }
        this.authorization = authorization;
        this.requestHeaders = map;
    }

    private HttpParameter[] setAccessTokenParameter(HttpParameter[] httpParameterArray, Authorization authorization) {
        if (authorization == null) {
            return httpParameterArray;
        }
        if (!(authorization instanceof OAuthAuthorization)) {
            return httpParameterArray;
        }
        AccessToken accessToken = ((OAuthAuthorization)authorization).getOAuthAccessToken();
        if (accessToken == null) {
            return httpParameterArray;
        }
        return HttpParameter.merge(httpParameterArray, new HttpParameter("access_token", accessToken.getToken()));
    }

    private HttpParameter[] setAppSecretProofParameter(HttpParameter[] httpParameterArray, Authorization authorization) {
        if (authorization == null) {
            return httpParameterArray;
        }
        if (!(authorization instanceof OAuthAuthorization)) {
            return httpParameterArray;
        }
        OAuthAuthorization oAuthAuthorization = (OAuthAuthorization)authorization;
        if (!oAuthAuthorization.isAppSecretProofEnabled()) {
            return httpParameterArray;
        }
        String string = oAuthAuthorization.generateAppSecretProof();
        return HttpParameter.merge(httpParameterArray, new HttpParameter("appsecret_proof", string));
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public HttpParameter[] getParameters() {
        return this.parameters;
    }

    public String getURL() {
        return this.url;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HttpRequest httpRequest = (HttpRequest)object;
        if (this.authorization != null ? !this.authorization.equals(httpRequest.authorization) : httpRequest.authorization != null) {
            return false;
        }
        if (!Arrays.equals(this.parameters, httpRequest.parameters)) {
            return false;
        }
        if (this.requestHeaders != null ? !((Object)this.requestHeaders).equals(httpRequest.requestHeaders) : httpRequest.requestHeaders != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(httpRequest.method) : httpRequest.method != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(httpRequest.url) : httpRequest.url != null);
    }

    public int hashCode() {
        int n2 = this.method != null ? this.method.hashCode() : 0;
        n2 = 31 * n2 + (this.url != null ? this.url.hashCode() : 0);
        n2 = 31 * n2 + (this.parameters != null ? Arrays.hashCode(this.parameters) : 0);
        n2 = 31 * n2 + (this.authorization != null ? this.authorization.hashCode() : 0);
        n2 = 31 * n2 + (this.requestHeaders != null ? ((Object)this.requestHeaders).hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "HttpRequest{requestMethod=" + this.method + ", url='" + this.url + '\'' + ", postParams=" + (this.parameters == null ? null : Arrays.asList(this.parameters)) + ", authentication=" + this.authorization + ", requestHeaders=" + this.requestHeaders + '}';
    }
}

