/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.auth;

import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

public class DeviceCode
implements Serializable {
    private static final long serialVersionUID = -1050681649334378859L;
    private final String code;
    private final String userCode;
    private final String verificationUri;
    private final Integer expiresIn;
    private final Integer interval;

    public DeviceCode(HttpResponse httpResponse) {
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.code = z_F4JInternalParseUtil.getRawString("code", jSONObject);
        this.userCode = z_F4JInternalParseUtil.getRawString("user_code", jSONObject);
        this.verificationUri = z_F4JInternalParseUtil.getRawString("verification_uri", jSONObject);
        this.expiresIn = z_F4JInternalParseUtil.getInt("expires_in", jSONObject);
        this.interval = z_F4JInternalParseUtil.getInt("interval", jSONObject);
    }

    public String getCode() {
        return this.code;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public String getVerificationUri() {
        return this.verificationUri;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DeviceCode)) {
            return false;
        }
        DeviceCode deviceCode = (DeviceCode)object;
        if (this.code != null ? !this.code.equals(deviceCode.code) : deviceCode.code != null) {
            return false;
        }
        if (this.expiresIn != null ? !this.expiresIn.equals(deviceCode.expiresIn) : deviceCode.expiresIn != null) {
            return false;
        }
        if (this.interval != null ? !this.interval.equals(deviceCode.interval) : deviceCode.interval != null) {
            return false;
        }
        if (this.userCode != null ? !this.userCode.equals(deviceCode.userCode) : deviceCode.userCode != null) {
            return false;
        }
        return !(this.verificationUri != null ? !this.verificationUri.equals(deviceCode.verificationUri) : deviceCode.verificationUri != null);
    }

    public int hashCode() {
        int n2 = this.code != null ? this.code.hashCode() : 0;
        n2 = 31 * n2 + (this.userCode != null ? this.userCode.hashCode() : 0);
        n2 = 31 * n2 + (this.verificationUri != null ? this.verificationUri.hashCode() : 0);
        n2 = 31 * n2 + (this.expiresIn != null ? this.expiresIn.hashCode() : 0);
        n2 = 31 * n2 + (this.interval != null ? this.interval.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "DeviceCode{code='" + this.code + '\'' + ", userCode='" + this.userCode + '\'' + ", verificationUri='" + this.verificationUri + '\'' + ", expiresIn=" + this.expiresIn + ", interval=" + this.interval + '}';
    }
}

