/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook;

import be.maximvdw.tabcore.facebook.BatchAttachment;
import be.maximvdw.tabcore.facebook.internal.http.RequestMethod;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalStringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchRequest
implements Serializable {
    private static final long serialVersionUID = -7720882981733337599L;
    private final RequestMethod method;
    private final String relativeUrl;
    private String name;
    private String body;
    private Boolean omitResponseOnSuccess;
    private String dependsOn;
    private String accessToken;
    private List<BatchAttachment> attachedFiles;
    private JSONObject json = null;

    public BatchRequest(RequestMethod requestMethod, String string) {
        this.method = requestMethod;
        this.relativeUrl = string;
    }

    public String getMethod() {
        return this.method.name();
    }

    public String getRelativeUrl() {
        return this.relativeUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public BatchRequest name(String string) {
        this.setName(string);
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public BatchRequest body(String string) {
        this.setBody(string);
        return this;
    }

    public Boolean isOmitResponseOnSuccess() {
        return this.omitResponseOnSuccess;
    }

    public void setOmitResponseOnSuccess(Boolean bl2) {
        this.omitResponseOnSuccess = bl2;
    }

    public BatchRequest omitResponseOnSuccess(Boolean bl2) {
        this.setOmitResponseOnSuccess(bl2);
        return this;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String string) {
        this.dependsOn = string;
    }

    public BatchRequest dependsOn(String string) {
        this.setDependsOn(string);
        return this;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String string) {
        this.accessToken = string;
    }

    public BatchRequest accessToken(String string) {
        this.setAccessToken(string);
        return this;
    }

    public List<BatchAttachment> getAttachedFiles() {
        return this.attachedFiles;
    }

    public void setAttachedFiles(List<BatchAttachment> list) {
        this.attachedFiles = list;
    }

    public BatchRequest attachedFiles(List<BatchAttachment> list) {
        this.setAttachedFiles(list);
        return this;
    }

    public void addAttachedFile(BatchAttachment batchAttachment) {
        if (this.attachedFiles == null) {
            this.attachedFiles = new ArrayList<BatchAttachment>();
        }
        this.attachedFiles.add(batchAttachment);
    }

    public BatchRequest attachedFile(BatchAttachment batchAttachment) {
        this.addAttachedFile(batchAttachment);
        return this;
    }

    public JSONObject asJSONObject() {
        if (this.json == null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("method", this.getMethod());
            hashMap.put("relative_url", this.getRelativeUrl());
            hashMap.put("name", this.getName());
            hashMap.put("body", this.getBody());
            hashMap.put("omit_response_on_success", this.isOmitResponseOnSuccess());
            hashMap.put("depends_on", this.getDependsOn());
            hashMap.put("access_token", this.getAccessToken());
            if (this.attachedFiles != null && !this.attachedFiles.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>(this.attachedFiles.size());
                for (BatchAttachment batchAttachment : this.attachedFiles) {
                    arrayList.add(batchAttachment.getName());
                }
                hashMap.put("attached_files", z_F4JInternalStringUtil.join(arrayList.toArray(new String[arrayList.size()]), ","));
            }
            this.json = new JSONObject(hashMap);
        }
        return this.json;
    }

    public String asJSONString() {
        return this.asJSONObject().toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BatchRequest)) {
            return false;
        }
        BatchRequest batchRequest = (BatchRequest)object;
        if (this.accessToken != null ? !this.accessToken.equals(batchRequest.accessToken) : batchRequest.accessToken != null) {
            return false;
        }
        if (this.attachedFiles != null ? !((Object)this.attachedFiles).equals(batchRequest.attachedFiles) : batchRequest.attachedFiles != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(batchRequest.body) : batchRequest.body != null) {
            return false;
        }
        if (this.dependsOn != null ? !this.dependsOn.equals(batchRequest.dependsOn) : batchRequest.dependsOn != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(batchRequest.method) : batchRequest.method != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(batchRequest.name) : batchRequest.name != null) {
            return false;
        }
        if (this.omitResponseOnSuccess != null ? !this.omitResponseOnSuccess.equals(batchRequest.omitResponseOnSuccess) : batchRequest.omitResponseOnSuccess != null) {
            return false;
        }
        return !(this.relativeUrl != null ? !this.relativeUrl.equals(batchRequest.relativeUrl) : batchRequest.relativeUrl != null);
    }

    public int hashCode() {
        int n2 = this.method != null ? this.method.hashCode() : 0;
        n2 = 31 * n2 + (this.relativeUrl != null ? this.relativeUrl.hashCode() : 0);
        n2 = 31 * n2 + (this.name != null ? this.name.hashCode() : 0);
        n2 = 31 * n2 + (this.body != null ? this.body.hashCode() : 0);
        n2 = 31 * n2 + (this.omitResponseOnSuccess != null ? this.omitResponseOnSuccess.hashCode() : 0);
        n2 = 31 * n2 + (this.dependsOn != null ? this.dependsOn.hashCode() : 0);
        n2 = 31 * n2 + (this.accessToken != null ? this.accessToken.hashCode() : 0);
        n2 = 31 * n2 + (this.attachedFiles != null ? ((Object)this.attachedFiles).hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "BatchRequest{method=" + this.method.name() + ", relativeUrl='" + this.relativeUrl + '\'' + ", name='" + this.name + '\'' + ", body=" + this.body + ", omitResponseOnSuccess=" + this.omitResponseOnSuccess + ", dependsOn='" + this.dependsOn + '\'' + ", accessToken='" + this.accessToken + '\'' + ", attachedFiles='" + this.attachedFiles + '\'' + '}';
    }
}

