/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.sql;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.tehkode.permissions.PermissionsGroupData;
import ru.tehkode.permissions.PermissionsUserData;
import ru.tehkode.permissions.backends.sql.SQLBackend;
import ru.tehkode.permissions.backends.sql.SQLConnection;

public class SQLData
implements PermissionsUserData,
PermissionsGroupData {
    private String identifier;
    private final Type type;
    private final SQLBackend backend;
    private final AtomicBoolean virtual = new AtomicBoolean(true);

    public SQLData(String identifier, Type type, SQLBackend backend) {
        this.identifier = identifier;
        this.type = type;
        this.backend = backend;
        this.fetchInfo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateInfo() {
        block16: {
            if (!this.isVirtual()) {
                return;
            }
            try {
                SQLConnection conn;
                block17: {
                    conn = this.backend.getSQL();
                    Throwable throwable = null;
                    try {
                        conn.prepAndBind("entity.update", this.getIdentifier(), this.type.ordinal()).execute();
                        if (conn == null) break block16;
                        if (throwable == null) break block17;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (conn == null) throw throwable4;
                            if (throwable == null) {
                                conn.close();
                                throw throwable4;
                            }
                            try {
                                conn.close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                try {
                                    throwable.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                                catch (NoSuchMethodError noSuchMethodError) {
                                    throw throwable4;
                                }
                            }
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable.addSuppressed(throwable2);
                            break block16;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {}
                    }
                    break block16;
                }
                conn.close();
            }
            catch (IOException | SQLException e) {
                if (!this.virtual.compareAndSet(true, false)) throw new RuntimeException(e);
                this.updateInfo();
                throw new RuntimeException(e);
            }
        }
        this.backend.updateNameCache(this);
        this.virtual.set(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void fetchInfo() {
        try {
            SQLConnection conn;
            block17: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet result = conn.prepAndBind("entity.fetch", this.getIdentifier(), this.type.ordinal()).executeQuery();
                    if (result.next()) {
                        this.identifier = result.getString("name");
                        this.virtual.set(false);
                    } else {
                        this.virtual.set(true);
                    }
                    if (conn == null) return;
                    if (throwable == null) break block17;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return;
                    }
                }
            }
            conn.close();
            return;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setIdentifier(String identifier) {
        try {
            boolean bl;
            Throwable throwable;
            SQLConnection conn;
            block29: {
                block27: {
                    boolean bl2;
                    block28: {
                        block25: {
                            boolean bl3;
                            block26: {
                                conn = this.backend.getSQL();
                                throwable = null;
                                ResultSet set = conn.prepAndBind("entity.exists", identifier, this.type.ordinal()).executeQuery();
                                if (!set.next()) break block25;
                                bl3 = false;
                                if (conn == null) return bl3;
                                if (throwable == null) break block26;
                                try {
                                    conn.close();
                                    return bl3;
                                }
                                catch (Throwable throwable2) {
                                    try {
                                        throwable.addSuppressed(throwable2);
                                        return bl3;
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {
                                        return bl3;
                                    }
                                }
                            }
                            conn.close();
                            return bl3;
                        }
                        if (!this.isVirtual()) break block27;
                        this.identifier = identifier;
                        bl2 = true;
                        if (conn == null) return bl2;
                        if (throwable == null) break block28;
                        try {
                            conn.close();
                            return bl2;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable.addSuppressed(throwable3);
                                return bl2;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                return bl2;
                            }
                        }
                    }
                    conn.close();
                    return bl2;
                }
                conn.prepAndBind("entity.rename.entity", identifier, this.identifier, this.type.ordinal()).execute();
                conn.prepAndBind("entity.rename.permissions", identifier, this.identifier, this.type.ordinal()).execute();
                conn.prepAndBind("entity.rename.inheritance", identifier, this.identifier, this.type.ordinal()).execute();
                this.identifier = identifier;
                this.backend.updateNameCache(this);
                bl = true;
                if (conn == null) return bl;
                if (throwable == null) break block29;
                try {
                    conn.close();
                    return bl;
                }
                catch (Throwable throwable4) {
                    try {
                        throwable.addSuppressed(throwable4);
                        return bl;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return bl;
                    }
                }
            }
            conn.close();
            return bl;
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (conn == null) throw throwable6;
                    if (throwable == null) {
                        conn.close();
                        throw throwable6;
                    }
                    try {
                        conn.close();
                        throw throwable6;
                    }
                    catch (Throwable throwable7) {
                        try {
                            throwable.addSuppressed(throwable7);
                            throw throwable6;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            throw throwable6;
                        }
                    }
                }
            }
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getPermissions(String worldName) {
        try {
            List<String> list;
            SQLConnection conn;
            block16: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    LinkedList<String> permissions = new LinkedList<String>();
                    ResultSet set = conn.prepAndBind("entity.permissions.get_world", this.getIdentifier(), this.type.ordinal(), worldName == null ? "" : worldName).executeQuery();
                    while (set.next()) {
                        permissions.add(set.getString("permission"));
                    }
                    list = Collections.unmodifiableList(permissions);
                    if (conn == null) return list;
                    if (throwable == null) break block16;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return list;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return list;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return list;
                    }
                }
            }
            conn.close();
            return list;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setPermissions(List<String> permissions, String worldName) {
        block18: {
            if (worldName == null) {
                worldName = "";
            }
            try {
                SQLConnection conn;
                block19: {
                    conn = this.backend.getSQL();
                    Throwable throwable = null;
                    try {
                        conn.prepAndBind("entity.permissions.clear", this.getIdentifier(), this.type.ordinal(), worldName).execute();
                        if (permissions.size() > 0) {
                            HashSet<String> includedPerms = new HashSet<String>();
                            PreparedStatement statement = conn.prepAndBind("entity.permissions.add", this.getIdentifier(), "toset", worldName, this.type.ordinal());
                            for (int i = permissions.size() - 1; i >= 0; --i) {
                                if (includedPerms.contains(permissions.get(i))) continue;
                                statement.setString(2, permissions.get(i));
                                statement.addBatch();
                                includedPerms.add(permissions.get(i));
                            }
                            statement.executeBatch();
                        }
                        if (conn == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (conn == null) throw throwable4;
                            if (throwable == null) {
                                conn.close();
                                throw throwable4;
                            }
                            try {
                                conn.close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                try {
                                    throwable.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                                catch (NoSuchMethodError noSuchMethodError) {
                                    throw throwable4;
                                }
                            }
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable.addSuppressed(throwable2);
                            break block18;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {}
                    }
                    break block18;
                }
                conn.close();
            }
            catch (IOException | SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (permissions.size() <= 0) return;
        if (!this.isVirtual()) return;
        this.save();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, List<String>> getPermissionsMap() {
        Object object;
        HashMap<String, LinkedList<String>> allPermissions;
        block19: {
            allPermissions = new HashMap<String, LinkedList<String>>();
            try {
                SQLConnection conn;
                block20: {
                    conn = this.backend.getSQL();
                    object = null;
                    try {
                        ResultSet resultSet = conn.prepAndBind("entity.permissions.get_all", this.getIdentifier(), this.type.ordinal()).executeQuery();
                        while (resultSet.next()) {
                            LinkedList<String> perms;
                            String world = resultSet.getString("world");
                            if (world.isEmpty()) {
                                world = null;
                            }
                            if ((perms = (LinkedList<String>)allPermissions.get(world)) == null) {
                                perms = new LinkedList<String>();
                                allPermissions.put(world, perms);
                            }
                            perms.add(resultSet.getString("permission"));
                        }
                        if (conn == null) break block19;
                        if (object == null) break block20;
                    }
                    catch (Throwable throwable) {
                        try {
                            object = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (conn == null) throw throwable2;
                            if (object == null) {
                                conn.close();
                                throw throwable2;
                            }
                            try {
                                conn.close();
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                try {
                                    ((Throwable)object).addSuppressed(throwable3);
                                    throw throwable2;
                                }
                                catch (NoSuchMethodError noSuchMethodError) {
                                    throw throwable2;
                                }
                            }
                        }
                    }
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        try {
                            ((Throwable)object).addSuppressed(throwable);
                            break block19;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {}
                    }
                    break block19;
                }
                conn.close();
            }
            catch (IOException | SQLException e) {
                throw new RuntimeException(e);
            }
        }
        HashMap ret = new HashMap();
        object = allPermissions.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            ret.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        return Collections.unmodifiableMap(ret);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getWorlds() {
        HashSet<String> worlds = new HashSet<String>();
        try {
            Set<String> set;
            SQLConnection conn;
            block17: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet res = conn.prepAndBind("entity.worlds.permissions", this.getIdentifier(), this.type.ordinal()).executeQuery();
                    while (res.next()) {
                        worlds.add(res.getString("world"));
                    }
                    res = conn.prepAndBind("entity.worlds.inheritance", this.getIdentifier(), this.type.ordinal()).executeQuery();
                    while (res.next()) {
                        worlds.add(res.getString("world"));
                    }
                    worlds.remove("");
                    set = Collections.unmodifiableSet(worlds);
                    if (conn == null) return set;
                    if (throwable == null) break block17;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return set;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return set;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return set;
                    }
                }
            }
            conn.close();
            return set;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getOption(String option, String worldName) {
        try {
            Throwable throwable;
            SQLConnection conn;
            block20: {
                String string;
                block21: {
                    conn = this.backend.getSQL();
                    throwable = null;
                    try {
                        ResultSet res = conn.prepAndBind("entity.options.get", this.getIdentifier(), this.type.ordinal(), option, worldName == null ? "" : worldName).executeQuery();
                        if (!res.next()) break block20;
                        string = res.getString("value");
                        if (conn == null) return string;
                        if (throwable == null) break block21;
                    }
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (conn == null) throw throwable5;
                            if (throwable == null) {
                                conn.close();
                                throw throwable5;
                            }
                            try {
                                conn.close();
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                try {
                                    throwable.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                                catch (NoSuchMethodError noSuchMethodError) {
                                    throw throwable5;
                                }
                            }
                        }
                    }
                    try {
                        conn.close();
                        return string;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable.addSuppressed(throwable2);
                            return string;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            return string;
                        }
                    }
                }
                conn.close();
                return string;
            }
            if (conn == null) return null;
            if (throwable == null) {
                conn.close();
                return null;
            }
            try {
                conn.close();
                return null;
            }
            catch (Throwable throwable3) {
                try {
                    throwable.addSuppressed(throwable3);
                    return null;
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    return null;
                }
            }
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setOption(String option, String value, String worldName) {
        if (option == null) return;
        if (option.isEmpty()) {
            return;
        }
        if (worldName == null) {
            worldName = "";
        }
        try {
            SQLConnection conn;
            block18: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    conn.prepAndBind("entity.options.delete", this.getIdentifier(), option, this.type.ordinal(), worldName).execute();
                    if (value != null && !value.isEmpty()) {
                        conn.prepAndBind("entity.options.add", this.getIdentifier(), this.type.ordinal(), option, worldName, value).execute();
                    }
                    if (conn == null) return;
                    if (throwable == null) break block18;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return;
                    }
                }
            }
            conn.close();
            return;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> getOptions(String worldName) {
        HashMap<String, String> options = new HashMap<String, String>();
        try {
            SQLConnection conn;
            block16: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet set = conn.prepAndBind("entity.options.get_world", this.getIdentifier(), this.type.ordinal(), worldName == null ? "" : worldName).executeQuery();
                    while (set.next()) {
                        options.put(set.getString("permission"), set.getString("value"));
                    }
                    if (conn == null) return Collections.unmodifiableMap(options);
                    if (throwable == null) break block16;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return Collections.unmodifiableMap(options);
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return Collections.unmodifiableMap(options);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return Collections.unmodifiableMap(options);
                    }
                }
            }
            conn.close();
            return Collections.unmodifiableMap(options);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Map<String, String>> getOptionsMap() {
        HashMap<String, HashMap<String, String>> allOptions = new HashMap<String, HashMap<String, String>>();
        try {
            SQLConnection conn;
            block18: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet res = conn.prepAndBind("entity.options.get_all", this.getIdentifier(), this.type.ordinal()).executeQuery();
                    while (res.next()) {
                        HashMap<String, String> worldOpts;
                        String world = res.getString("world");
                        if (world.isEmpty()) {
                            world = null;
                        }
                        if ((worldOpts = (HashMap<String, String>)allOptions.get(world)) == null) {
                            worldOpts = new HashMap<String, String>();
                            allOptions.put(world, worldOpts);
                        }
                        worldOpts.put(res.getString("permission"), res.getString("value"));
                    }
                    if (conn == null) return Collections.unmodifiableMap(allOptions);
                    if (throwable == null) break block18;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return Collections.unmodifiableMap(allOptions);
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return Collections.unmodifiableMap(allOptions);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return Collections.unmodifiableMap(allOptions);
                    }
                }
            }
            conn.close();
            return Collections.unmodifiableMap(allOptions);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isVirtual() {
        return this.virtual.get();
    }

    @Override
    public void save() {
        if (this.isVirtual()) {
            this.updateInfo();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void remove() {
        if (!this.virtual.compareAndSet(false, true)) return;
        try {
            SQLConnection conn;
            block15: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    conn.prepAndBind("entity.delete.inheritance", this.getIdentifier(), this.type.ordinal()).execute();
                    conn.prepAndBind("entity.delete.permissions", this.getIdentifier(), this.type.ordinal()).execute();
                    conn.prepAndBind("entity.delete.entity", this.getIdentifier(), this.type.ordinal()).execute();
                    this.backend.updateNameCache(this);
                    if (conn == null) return;
                    if (throwable == null) break block15;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return;
                    }
                }
            }
            conn.close();
            return;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, List<String>> getParentsMap() {
        HashMap<String, LinkedList<String>> ret = new HashMap<String, LinkedList<String>>();
        try {
            SQLConnection conn;
            block17: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet res = conn.prepAndBind("entity.parents.get_all", this.getIdentifier(), this.type.ordinal()).executeQuery();
                    while (res.next()) {
                        String world = res.getString("world");
                        LinkedList<String> worldParents = (LinkedList<String>)ret.get(world);
                        if (worldParents == null) {
                            worldParents = new LinkedList<String>();
                            ret.put(world, worldParents);
                        }
                        worldParents.add(res.getString("parent"));
                    }
                    if (conn == null) return Collections.unmodifiableMap(ret);
                    if (throwable == null) break block17;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return Collections.unmodifiableMap(ret);
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return Collections.unmodifiableMap(ret);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return Collections.unmodifiableMap(ret);
                    }
                }
            }
            conn.close();
            return Collections.unmodifiableMap(ret);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getParents(String worldName) {
        LinkedList<String> ret = new LinkedList<String>();
        try {
            SQLConnection conn;
            block16: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    ResultSet res = worldName == null ? conn.prepAndBind("SELECT `parent` FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = ? AND `world` IS NULL ORDER BY `id` DESC", this.getIdentifier(), this.type.ordinal()).executeQuery() : conn.prepAndBind("entity.parents.get_world", this.getIdentifier(), this.type.ordinal(), worldName).executeQuery();
                    while (res.next()) {
                        ret.add(res.getString("parent"));
                    }
                    if (conn == null) return Collections.unmodifiableList(ret);
                    if (throwable == null) break block16;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return Collections.unmodifiableList(ret);
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return Collections.unmodifiableList(ret);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return Collections.unmodifiableList(ret);
                    }
                }
            }
            conn.close();
            return Collections.unmodifiableList(ret);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setParents(List<String> parents, String worldName) {
        if (this.isVirtual()) {
            this.save();
        }
        try {
            SQLConnection conn;
            block19: {
                conn = this.backend.getSQL();
                Throwable throwable = null;
                try {
                    if (worldName != null) {
                        conn.prepAndBind("entity.parents.clear", this.getIdentifier(), this.type.ordinal(), worldName).execute();
                    } else {
                        conn.prepAndBind("DELETE FROM `{permissions_inheritance}` WHERE `child` = ? AND `type` = ? AND `world` IS NULL", this.getIdentifier(), this.type.ordinal()).execute();
                    }
                    PreparedStatement statement = conn.prepAndBind("entity.parents.add", this.getIdentifier(), "toset", this.type.ordinal(), worldName);
                    for (int i = parents.size() - 1; i >= 0; --i) {
                        String group = parents.get(i);
                        if (group == null || group.isEmpty()) continue;
                        statement.setString(2, group);
                        statement.addBatch();
                    }
                    statement.executeBatch();
                    if (conn == null) return;
                    if (throwable == null) break block19;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn == null) throw throwable4;
                        if (throwable == null) {
                            conn.close();
                            throw throwable4;
                        }
                        try {
                            conn.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            try {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                throw throwable4;
                            }
                        }
                    }
                }
                try {
                    conn.close();
                    return;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable.addSuppressed(throwable2);
                        return;
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        return;
                    }
                }
            }
            conn.close();
            return;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void load() {
    }

    public Type getType() {
        return this.type;
    }

    public static Set<String> getEntitiesNames(SQLConnection sql, Type type, boolean defaultOnly) throws SQLException {
        HashSet<String> entities = new HashSet<String>();
        ResultSet result = sql.prepAndBind("SELECT `name` FROM `{permissions_entity}` WHERE `type` = ? " + (defaultOnly ? " AND `default` = 1" : ""), type.ordinal()).executeQuery();
        while (result.next()) {
            entities.add(result.getString("name"));
        }
        result.close();
        return Collections.unmodifiableSet(entities);
    }

    public static enum Type {
        GROUP,
        USER,
        WORLD;

    }
}

