/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.placeholderapi;

import be.maximvdw.placeholderapi.PlaceholderReplacer;
import be.maximvdw.placeholderapi.internal.MVdWPlaceholderReplacer;
import be.maximvdw.placeholderapi.internal.PlaceholderAddedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class PlaceholderAPI
extends JavaPlugin {
    private static MVdWPlaceholderReplacer mvdwReplacer = null;
    private static Map<String, PlaceholderReplacer> customPlaceholders = new ConcurrentHashMap<String, PlaceholderReplacer>();
    private static List<PlaceholderAddedEvent> placeholderAddedHandlers = new ArrayList<PlaceholderAddedEvent>();

    public void onEnable() {
        super.onEnable();
        Bukkit.getLogger().info("[MVdWPlaceholderAPI] Initializing ...");
    }

    public void registerMVdWPlaceholderReplacer(Plugin plugin, MVdWPlaceholderReplacer replacer) {
        if (plugin == null) {
            return;
        }
        if (this.getMVdWReplacer() != null) {
            return;
        }
        PluginDescriptionFile desc = plugin.getDescription();
        if (desc.getAuthors().size() > 0) {
            if (((String)desc.getAuthors().get(0)).equals("Maximvdw")) {
                Bukkit.getLogger().info("[MVdWPlaceholderAPI] Using " + desc.getName() + " to get placeholders!");
                PlaceholderAPI.setMVdWReplacer(replacer);
            }
        } else {
            Bukkit.getLogger().warning("[MVdWPlaceholderAPI] Plugin " + plugin.getName() + " tried to register itself as an MVdW Placeholder plugin. Report this to Maximvdw!");
            return;
        }
    }

    public static String replacePlaceholders(OfflinePlayer offlinePlayer, String input) {
        if (mvdwReplacer == null) {
            Bukkit.getLogger().severe("[MVdWPlaceholderAPI] Unable to replace placeholders. No MVdW Placeholder plugin found!");
            return input;
        }
        return mvdwReplacer.replacePlaceholders(offlinePlayer, input);
    }

    public static int getLoadedPlaceholderCount() {
        if (mvdwReplacer == null) {
            Bukkit.getLogger().severe("[MVdWPlaceholderAPI] Unable to get placeholder count. No MVdW Placeholder plugin found!");
            return 0;
        }
        return mvdwReplacer.getLoadedPlaceholderCount();
    }

    public static boolean registerPlaceholder(Plugin plugin, String placeholder, PlaceholderReplacer replacer) {
        if (plugin == null) {
            return false;
        }
        if (placeholder == null) {
            return false;
        }
        if (placeholder.equals("")) {
            return false;
        }
        if (replacer == null) {
            return false;
        }
        if (customPlaceholders.containsKey(placeholder.toLowerCase())) {
            return false;
        }
        customPlaceholders.put(placeholder.toLowerCase(), replacer);
        Bukkit.getLogger().info("[MVdWPlaceholderAPI] " + plugin.getName() + " added custom placeholder {" + placeholder.toLowerCase() + "}");
        for (PlaceholderAddedEvent event : placeholderAddedHandlers) {
            event.onPlaceholderAdded(plugin, placeholder, replacer);
        }
        return true;
    }

    public MVdWPlaceholderReplacer getMVdWReplacer() {
        return mvdwReplacer;
    }

    private static void setMVdWReplacer(MVdWPlaceholderReplacer mvdwReplacer) {
        PlaceholderAPI.mvdwReplacer = mvdwReplacer;
    }

    public static Map<String, PlaceholderReplacer> getCustomPlaceholders() {
        return customPlaceholders;
    }

    public void setCustomPlaceholders(Map<String, PlaceholderReplacer> customPlaceholders) {
        PlaceholderAPI.customPlaceholders = customPlaceholders;
    }

    public void setPlaceholderListener(PlaceholderAddedEvent handler) {
        placeholderAddedHandlers.add(handler);
    }
}

