/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter.auth;

import be.maximvdw.featherboardcore.twitter.HttpResponse;
import java.io.Serializable;
import javax.crypto.spec.SecretKeySpec;

abstract class OAuthToken
implements Serializable {
    private static final long serialVersionUID = -7841506492508140600L;
    private final String token;
    private final String tokenSecret;
    private transient SecretKeySpec secretKeySpec;
    private String[] responseStr = null;

    public OAuthToken(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Token can't be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("TokenSecret can't be null");
        }
        this.token = string;
        this.tokenSecret = string2;
    }

    OAuthToken(HttpResponse httpResponse) {
        this(httpResponse.asString());
    }

    OAuthToken(String string) {
        this.responseStr = string.split("&");
        this.tokenSecret = this.getParameter("oauth_token_secret");
        this.token = this.getParameter("oauth_token");
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    void setSecretKeySpec(SecretKeySpec secretKeySpec) {
        this.secretKeySpec = secretKeySpec;
    }

    SecretKeySpec getSecretKeySpec() {
        return this.secretKeySpec;
    }

    public String getParameter(String string) {
        String string2 = null;
        for (String string3 : this.responseStr) {
            if (!string3.startsWith(string + '=')) continue;
            string2 = string3.split("=")[1].trim();
            break;
        }
        return string2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OAuthToken)) {
            return false;
        }
        OAuthToken oAuthToken = (OAuthToken)object;
        if (!this.token.equals(oAuthToken.token)) {
            return false;
        }
        return this.tokenSecret.equals(oAuthToken.tokenSecret);
    }

    public int hashCode() {
        int n2 = this.token.hashCode();
        n2 = 31 * n2 + this.tokenSecret.hashCode();
        return n2;
    }

    public String toString() {
        return "OAuthToken{token='" + this.token + '\'' + ", tokenSecret='" + this.tokenSecret + '\'' + ", secretKeySpec=" + this.secretKeySpec + '}';
    }
}

