/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter.auth;

import be.maximvdw.featherboardcore.twitter.BASE64Encoder;
import be.maximvdw.featherboardcore.twitter.HttpClient;
import be.maximvdw.featherboardcore.twitter.HttpClientFactory;
import be.maximvdw.featherboardcore.twitter.HttpParameter;
import be.maximvdw.featherboardcore.twitter.HttpRequest;
import be.maximvdw.featherboardcore.twitter.Logger;
import be.maximvdw.featherboardcore.twitter.TwitterException;
import be.maximvdw.featherboardcore.twitter.auth.AccessToken;
import be.maximvdw.featherboardcore.twitter.auth.Authorization;
import be.maximvdw.featherboardcore.twitter.auth.OAuthSupport;
import be.maximvdw.featherboardcore.twitter.auth.OAuthToken;
import be.maximvdw.featherboardcore.twitter.auth.RequestToken;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthAuthorization
implements Authorization,
OAuthSupport,
Serializable {
    private static final long serialVersionUID = -886869424811858868L;
    private final Configuration conf;
    private static transient HttpClient http;
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final HttpParameter OAUTH_SIGNATURE_METHOD;
    private static final Logger logger;
    private String consumerKey = "";
    private String consumerSecret;
    private String realm = null;
    private OAuthToken oauthToken = null;
    private static final Random RAND;

    public OAuthAuthorization(Configuration configuration) {
        this.conf = configuration;
        http = HttpClientFactory.getInstance(configuration.getHttpClientConfiguration());
        this.setOAuthConsumer(configuration.getOAuthConsumerKey(), configuration.getOAuthConsumerSecret());
        if (configuration.getOAuthAccessToken() != null && configuration.getOAuthAccessTokenSecret() != null) {
            this.setOAuthAccessToken(new AccessToken(configuration.getOAuthAccessToken(), configuration.getOAuthAccessTokenSecret()));
        }
    }

    @Override
    public String getAuthorizationHeader(HttpRequest httpRequest) {
        return this.generateAuthorizationHeader(httpRequest.getMethod().name(), httpRequest.getURL(), httpRequest.getParameters(), this.oauthToken);
    }

    private void ensureTokenIsAvailable() {
        if (null == this.oauthToken) {
            throw new IllegalStateException("No Token available.");
        }
    }

    @Override
    public boolean isEnabled() {
        return this.oauthToken != null && this.oauthToken instanceof AccessToken;
    }

    @Override
    public RequestToken getOAuthRequestToken() {
        return this.getOAuthRequestToken(null, null, null);
    }

    @Override
    public RequestToken getOAuthRequestToken(String string) {
        return this.getOAuthRequestToken(string, null, null);
    }

    @Override
    public RequestToken getOAuthRequestToken(String string, String string2) {
        return this.getOAuthRequestToken(string, string2, null);
    }

    @Override
    public RequestToken getOAuthRequestToken(String string, String string2, String string3) {
        if (this.oauthToken instanceof AccessToken) {
            throw new IllegalStateException("Access token already available.");
        }
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>();
        if (string != null) {
            arrayList.add(new HttpParameter("oauth_callback", string));
        }
        if (string2 != null) {
            arrayList.add(new HttpParameter("x_auth_access_type", string2));
        }
        if (string3 != null) {
            arrayList.add(new HttpParameter("x_auth_mode", string3));
        }
        this.oauthToken = new RequestToken(http.post(this.conf.getOAuthRequestTokenURL(), arrayList.toArray(new HttpParameter[arrayList.size()]), this, null), this);
        return (RequestToken)this.oauthToken;
    }

    @Override
    public AccessToken getOAuthAccessToken() {
        this.ensureTokenIsAvailable();
        if (this.oauthToken instanceof AccessToken) {
            return (AccessToken)this.oauthToken;
        }
        this.oauthToken = new AccessToken(http.post(this.conf.getOAuthAccessTokenURL(), null, this, null));
        return (AccessToken)this.oauthToken;
    }

    @Override
    public AccessToken getOAuthAccessToken(String string) {
        this.ensureTokenIsAvailable();
        this.oauthToken = new AccessToken(http.post(this.conf.getOAuthAccessTokenURL(), new HttpParameter[]{new HttpParameter("oauth_verifier", string)}, this, null));
        return (AccessToken)this.oauthToken;
    }

    @Override
    public AccessToken getOAuthAccessToken(RequestToken requestToken) {
        this.oauthToken = requestToken;
        return this.getOAuthAccessToken();
    }

    @Override
    public AccessToken getOAuthAccessToken(RequestToken requestToken, String string) {
        this.oauthToken = requestToken;
        return this.getOAuthAccessToken(string);
    }

    @Override
    public AccessToken getOAuthAccessToken(String string, String string2) {
        try {
            String string3 = this.conf.getOAuthAccessTokenURL();
            if (0 == string3.indexOf("http://")) {
                string3 = "https://" + string3.substring(7);
            }
            this.oauthToken = new AccessToken(http.post(string3, new HttpParameter[]{new HttpParameter("x_auth_username", string), new HttpParameter("x_auth_password", string2), new HttpParameter("x_auth_mode", "client_auth")}, this, null));
            return (AccessToken)this.oauthToken;
        }
        catch (TwitterException twitterException) {
            throw new TwitterException("The screen name / password combination seems to be invalid.", twitterException, twitterException.getStatusCode());
        }
    }

    @Override
    public void setOAuthAccessToken(AccessToken accessToken) {
        this.oauthToken = accessToken;
    }

    public void setOAuthRealm(String string) {
        this.realm = string;
    }

    String generateAuthorizationHeader(String string, String string2, HttpParameter[] httpParameterArray, String string3, String string4, OAuthToken oAuthToken) {
        if (null == httpParameterArray) {
            httpParameterArray = new HttpParameter[]{};
        }
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>(5);
        arrayList.add(new HttpParameter("oauth_consumer_key", this.consumerKey));
        arrayList.add(OAUTH_SIGNATURE_METHOD);
        arrayList.add(new HttpParameter("oauth_timestamp", string4));
        arrayList.add(new HttpParameter("oauth_nonce", string3));
        arrayList.add(new HttpParameter("oauth_version", "1.0"));
        if (oAuthToken != null) {
            arrayList.add(new HttpParameter("oauth_token", oAuthToken.getToken()));
        }
        ArrayList<HttpParameter> arrayList2 = new ArrayList<HttpParameter>(arrayList.size() + httpParameterArray.length);
        arrayList2.addAll(arrayList);
        if (!HttpParameter.containsFile(httpParameterArray)) {
            arrayList2.addAll(OAuthAuthorization.toParamList(httpParameterArray));
        }
        this.parseGetParameters(string2, arrayList2);
        StringBuilder stringBuilder = new StringBuilder(string).append("&").append(HttpParameter.encode(OAuthAuthorization.constructRequestURL(string2))).append("&");
        stringBuilder.append(HttpParameter.encode(OAuthAuthorization.normalizeRequestParameters(arrayList2)));
        String string5 = stringBuilder.toString();
        logger.debug("OAuth base string: ", string5);
        String string6 = this.generateSignature(string5, oAuthToken);
        logger.debug("OAuth signature: ", string6);
        arrayList.add(new HttpParameter("oauth_signature", string6));
        if (this.realm != null) {
            arrayList.add(new HttpParameter("realm", this.realm));
        }
        return "OAuth " + OAuthAuthorization.encodeParameters(arrayList, ",", true);
    }

    private void parseGetParameters(String string, List<HttpParameter> list) {
        int n2 = string.indexOf("?");
        if (-1 != n2) {
            string.split("&");
            String[] stringArray = string.substring(n2 + 1).split("&");
            try {
                for (String string2 : stringArray) {
                    String[] stringArray2 = string2.split("=");
                    if (stringArray2.length == 2) {
                        list.add(new HttpParameter(URLDecoder.decode(stringArray2[0], "UTF-8"), URLDecoder.decode(stringArray2[1], "UTF-8")));
                        continue;
                    }
                    list.add(new HttpParameter(URLDecoder.decode(stringArray2[0], "UTF-8"), ""));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    String generateAuthorizationHeader(String string, String string2, HttpParameter[] httpParameterArray, OAuthToken oAuthToken) {
        long l2 = System.currentTimeMillis() / 1000L;
        long l3 = l2 + (long)RAND.nextInt();
        return this.generateAuthorizationHeader(string, string2, httpParameterArray, String.valueOf(l3), String.valueOf(l2), oAuthToken);
    }

    public List<HttpParameter> generateOAuthSignatureHttpParams(String string, String string2) {
        long l2 = System.currentTimeMillis() / 1000L;
        long l3 = l2 + (long)RAND.nextInt();
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>(5);
        arrayList.add(new HttpParameter("oauth_consumer_key", this.consumerKey));
        arrayList.add(OAUTH_SIGNATURE_METHOD);
        arrayList.add(new HttpParameter("oauth_timestamp", l2));
        arrayList.add(new HttpParameter("oauth_nonce", l3));
        arrayList.add(new HttpParameter("oauth_version", "1.0"));
        if (this.oauthToken != null) {
            arrayList.add(new HttpParameter("oauth_token", this.oauthToken.getToken()));
        }
        ArrayList<HttpParameter> arrayList2 = new ArrayList<HttpParameter>(arrayList.size());
        arrayList2.addAll(arrayList);
        this.parseGetParameters(string2, arrayList2);
        StringBuilder stringBuilder = new StringBuilder(string).append("&").append(HttpParameter.encode(OAuthAuthorization.constructRequestURL(string2))).append("&");
        stringBuilder.append(HttpParameter.encode(OAuthAuthorization.normalizeRequestParameters(arrayList2)));
        String string3 = stringBuilder.toString();
        String string4 = this.generateSignature(string3, this.oauthToken);
        arrayList.add(new HttpParameter("oauth_signature", string4));
        return arrayList;
    }

    String generateSignature(String string, OAuthToken oAuthToken) {
        byte[] byArray = null;
        try {
            SecretKeySpec secretKeySpec;
            Mac mac = Mac.getInstance(HMAC_SHA1);
            if (null == oAuthToken) {
                String string2 = HttpParameter.encode(this.consumerSecret) + "&";
                secretKeySpec = new SecretKeySpec(string2.getBytes(), HMAC_SHA1);
            } else {
                secretKeySpec = oAuthToken.getSecretKeySpec();
                if (null == secretKeySpec) {
                    String string3 = HttpParameter.encode(this.consumerSecret) + "&" + HttpParameter.encode(oAuthToken.getTokenSecret());
                    secretKeySpec = new SecretKeySpec(string3.getBytes(), HMAC_SHA1);
                    oAuthToken.setSecretKeySpec(secretKeySpec);
                }
            }
            mac.init(secretKeySpec);
            byArray = mac.doFinal(string.getBytes());
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.error("Failed initialize \"Message Authentication Code\" (MAC)", invalidKeyException);
            throw new AssertionError((Object)invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.error("Failed to get HmacSHA1 \"Message Authentication Code\" (MAC)", noSuchAlgorithmException);
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
        return BASE64Encoder.encode(byArray);
    }

    String generateSignature(String string) {
        return this.generateSignature(string, null);
    }

    static String normalizeRequestParameters(HttpParameter[] httpParameterArray) {
        return OAuthAuthorization.normalizeRequestParameters(OAuthAuthorization.toParamList(httpParameterArray));
    }

    private static String normalizeRequestParameters(List<HttpParameter> list) {
        Collections.sort(list);
        return OAuthAuthorization.encodeParameters(list);
    }

    private static List<HttpParameter> toParamList(HttpParameter[] httpParameterArray) {
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>(httpParameterArray.length);
        arrayList.addAll(Arrays.asList(httpParameterArray));
        return arrayList;
    }

    public static String encodeParameters(List<HttpParameter> list) {
        return OAuthAuthorization.encodeParameters(list, "&", false);
    }

    public static String encodeParameters(List<HttpParameter> list, String string, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (HttpParameter httpParameter : list) {
            if (httpParameter.isFile()) continue;
            if (stringBuilder.length() != 0) {
                if (bl2) {
                    stringBuilder.append("\"");
                }
                stringBuilder.append(string);
            }
            stringBuilder.append(HttpParameter.encode(httpParameter.getName())).append("=");
            if (bl2) {
                stringBuilder.append("\"");
            }
            stringBuilder.append(HttpParameter.encode(httpParameter.getValue()));
        }
        if (stringBuilder.length() != 0 && bl2) {
            stringBuilder.append("\"");
        }
        return stringBuilder.toString();
    }

    static String constructRequestURL(String string) {
        int n2;
        String string2;
        int n3;
        int n4 = string.indexOf("?");
        if (-1 != n4) {
            string = string.substring(0, n4);
        }
        if (-1 != (n3 = (string2 = string.substring(0, n2 = string.indexOf("/", 8)).toLowerCase()).indexOf(":", 8))) {
            if (string2.startsWith("http://") && string2.endsWith(":80")) {
                string2 = string2.substring(0, n3);
            } else if (string2.startsWith("https://") && string2.endsWith(":443")) {
                string2 = string2.substring(0, n3);
            }
        }
        string = string2 + string.substring(n2);
        return string;
    }

    @Override
    public void setOAuthConsumer(String string, String string2) {
        this.consumerKey = string != null ? string : "";
        this.consumerSecret = string2 != null ? string2 : "";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OAuthSupport)) {
            return false;
        }
        OAuthAuthorization oAuthAuthorization = (OAuthAuthorization)object;
        if (this.consumerKey != null ? !this.consumerKey.equals(oAuthAuthorization.consumerKey) : oAuthAuthorization.consumerKey != null) {
            return false;
        }
        if (this.consumerSecret != null ? !this.consumerSecret.equals(oAuthAuthorization.consumerSecret) : oAuthAuthorization.consumerSecret != null) {
            return false;
        }
        return !(this.oauthToken != null ? !this.oauthToken.equals(oAuthAuthorization.oauthToken) : oAuthAuthorization.oauthToken != null);
    }

    public int hashCode() {
        int n2 = this.consumerKey != null ? this.consumerKey.hashCode() : 0;
        n2 = 31 * n2 + (this.consumerSecret != null ? this.consumerSecret.hashCode() : 0);
        n2 = 31 * n2 + (this.oauthToken != null ? this.oauthToken.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "OAuthAuthorization{consumerKey='" + this.consumerKey + '\'' + ", consumerSecret='******************************************'" + ", oauthToken=" + this.oauthToken + '}';
    }

    static {
        OAUTH_SIGNATURE_METHOD = new HttpParameter("oauth_signature_method", "HMAC-SHA1");
        logger = Logger.getLogger(OAuthAuthorization.class);
        RAND = new Random();
    }
}

