/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter.auth;

import be.maximvdw.featherboardcore.twitter.HttpResponse;
import be.maximvdw.featherboardcore.twitter.auth.OAuthToken;
import java.io.Serializable;

public class AccessToken
extends OAuthToken
implements Serializable {
    private static final long serialVersionUID = 2470022129505774772L;
    private String screenName;
    private long userId = -1L;

    AccessToken(HttpResponse httpResponse) {
        this(httpResponse.asString());
    }

    AccessToken(String string) {
        super(string);
        this.screenName = this.getParameter("screen_name");
        String string2 = this.getParameter("user_id");
        if (string2 != null) {
            this.userId = Long.parseLong(string2);
        }
    }

    public AccessToken(String string, String string2) {
        super(string, string2);
        int n2 = string.indexOf("-");
        if (n2 != -1) {
            String string3 = string.substring(0, n2);
            try {
                this.userId = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public AccessToken(String string, String string2, long l2) {
        super(string, string2);
        this.userId = l2;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public long getUserId() {
        return this.userId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AccessToken accessToken = (AccessToken)object;
        if (this.userId != accessToken.userId) {
            return false;
        }
        return !(this.screenName != null ? !this.screenName.equals(accessToken.screenName) : accessToken.screenName != null);
    }

    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.screenName != null ? this.screenName.hashCode() : 0);
        n2 = 31 * n2 + (int)(this.userId ^ this.userId >>> 32);
        return n2;
    }

    public String toString() {
        return "AccessToken{screenName='" + this.screenName + '\'' + ", userId=" + this.userId + '}';
    }
}

