/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.EntityIndex;
import be.maximvdw.featherboardcore.twitter.JSONArray;
import be.maximvdw.featherboardcore.twitter.JSONException;
import be.maximvdw.featherboardcore.twitter.JSONObject;
import be.maximvdw.featherboardcore.twitter.ParseUtil;
import be.maximvdw.featherboardcore.twitter.TwitterException;
import be.maximvdw.featherboardcore.twitter.UserMentionEntity;

class UserMentionEntityJSONImpl
extends EntityIndex
implements UserMentionEntity {
    private static final long serialVersionUID = 6060510953676673013L;
    private String name;
    private String screenName;
    private long id;

    UserMentionEntityJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    UserMentionEntityJSONImpl(int n2, int n3, String string, String string2, long l2) {
        this.setStart(n2);
        this.setEnd(n3);
        this.name = string;
        this.screenName = string2;
        this.id = l2;
    }

    UserMentionEntityJSONImpl() {
    }

    private void init(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("indices");
            this.setStart(jSONArray.getInt(0));
            this.setEnd(jSONArray.getInt(1));
            if (!jSONObject.isNull("name")) {
                this.name = jSONObject.getString("name");
            }
            if (!jSONObject.isNull("screen_name")) {
                this.screenName = jSONObject.getString("screen_name");
            }
            this.id = ParseUtil.getLong("id", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public String getText() {
        return this.screenName;
    }

    public String getName() {
        return this.name;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public long getId() {
        return this.id;
    }

    public int getStart() {
        return super.getStart();
    }

    public int getEnd() {
        return super.getEnd();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        UserMentionEntityJSONImpl userMentionEntityJSONImpl = (UserMentionEntityJSONImpl)object;
        if (this.id != userMentionEntityJSONImpl.id) {
            return false;
        }
        if (this.name != null ? !this.name.equals(userMentionEntityJSONImpl.name) : userMentionEntityJSONImpl.name != null) {
            return false;
        }
        return !(this.screenName != null ? !this.screenName.equals(userMentionEntityJSONImpl.screenName) : userMentionEntityJSONImpl.screenName != null);
    }

    public int hashCode() {
        int n2 = this.name != null ? this.name.hashCode() : 0;
        n2 = 31 * n2 + (this.screenName != null ? this.screenName.hashCode() : 0);
        n2 = 31 * n2 + (int)(this.id ^ this.id >>> 32);
        return n2;
    }

    public String toString() {
        return "UserMentionEntityJSONImpl{name='" + this.name + '\'' + ", screenName='" + this.screenName + '\'' + ", id=" + this.id + '}';
    }
}

