/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.JSONException;
import be.maximvdw.featherboardcore.twitter.JSONObject;
import be.maximvdw.featherboardcore.twitter.ParseUtil;
import be.maximvdw.featherboardcore.twitter.TwitterException;
import java.io.Serializable;

public final class UploadedMedia
implements Serializable {
    private static final long serialVersionUID = 5393092535610604718L;
    private int imageWidth;
    private int imageHeight;
    private String imageType;
    private long mediaId;
    private long size;

    UploadedMedia(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public String getImageType() {
        return this.imageType;
    }

    public long getMediaId() {
        return this.mediaId;
    }

    public long getSize() {
        return this.size;
    }

    private void init(JSONObject jSONObject) {
        this.mediaId = ParseUtil.getLong("media_id", jSONObject);
        this.size = ParseUtil.getLong("size", jSONObject);
        try {
            if (!jSONObject.isNull("image")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("image");
                this.imageWidth = ParseUtil.getInt("w", jSONObject2);
                this.imageHeight = ParseUtil.getInt("h", jSONObject2);
                this.imageType = ParseUtil.getUnescapedString("image_type", jSONObject2);
            }
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        UploadedMedia uploadedMedia = (UploadedMedia)object;
        if (this.imageWidth != uploadedMedia.imageWidth) {
            return false;
        }
        if (this.imageHeight != uploadedMedia.imageHeight) {
            return false;
        }
        if (this.imageType != uploadedMedia.imageType) {
            return false;
        }
        if (this.mediaId != uploadedMedia.mediaId) {
            return false;
        }
        return this.size == uploadedMedia.size;
    }

    public int hashCode() {
        int n2 = (int)(this.mediaId ^ this.mediaId >>> 32);
        n2 = 31 * n2 + this.imageWidth;
        n2 = 31 * n2 + this.imageHeight;
        n2 = 31 * n2 + (this.imageType != null ? this.imageType.hashCode() : 0);
        n2 = 31 * n2 + (int)(this.size ^ this.size >>> 32);
        return n2;
    }

    public String toString() {
        return "UploadedMedia{mediaId=" + this.mediaId + ", imageWidth=" + this.imageWidth + ", imageHeight=" + this.imageHeight + ", imageType='" + this.imageType + '\'' + ", size=" + this.size + '}';
    }
}

