/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.HttpClient;
import be.maximvdw.featherboardcore.twitter.HttpClientFactory;
import be.maximvdw.featherboardcore.twitter.HttpResponse;
import be.maximvdw.featherboardcore.twitter.HttpResponseEvent;
import be.maximvdw.featherboardcore.twitter.HttpResponseListener;
import be.maximvdw.featherboardcore.twitter.JSONImplFactory;
import be.maximvdw.featherboardcore.twitter.ObjectFactory;
import be.maximvdw.featherboardcore.twitter.RateLimitStatus;
import be.maximvdw.featherboardcore.twitter.RateLimitStatusEvent;
import be.maximvdw.featherboardcore.twitter.RateLimitStatusListener;
import be.maximvdw.featherboardcore.twitter.TwitterBase;
import be.maximvdw.featherboardcore.twitter.TwitterException;
import be.maximvdw.featherboardcore.twitter.User;
import be.maximvdw.featherboardcore.twitter.UserJSONImpl;
import be.maximvdw.featherboardcore.twitter.XAuthAuthorization;
import be.maximvdw.featherboardcore.twitter.auth.AccessToken;
import be.maximvdw.featherboardcore.twitter.auth.Authorization;
import be.maximvdw.featherboardcore.twitter.auth.AuthorizationFactory;
import be.maximvdw.featherboardcore.twitter.auth.BasicAuthorization;
import be.maximvdw.featherboardcore.twitter.auth.NullAuthorization;
import be.maximvdw.featherboardcore.twitter.auth.OAuth2Authorization;
import be.maximvdw.featherboardcore.twitter.auth.OAuth2Support;
import be.maximvdw.featherboardcore.twitter.auth.OAuth2Token;
import be.maximvdw.featherboardcore.twitter.auth.OAuthAuthorization;
import be.maximvdw.featherboardcore.twitter.auth.OAuthSupport;
import be.maximvdw.featherboardcore.twitter.auth.RequestToken;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;
import be.maximvdw.featherboardcore.twitter.util.function.Consumer;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TwitterBaseImpl
implements HttpResponseListener,
TwitterBase,
OAuth2Support,
OAuthSupport,
Serializable {
    private static final String WWW_DETAILS = "See http://twitter4j.org/en/configuration.html for details";
    private static final long serialVersionUID = -7824361938865528554L;
    Configuration conf;
    private transient String screenName = null;
    private transient long id = 0L;
    transient HttpClient http;
    private List<RateLimitStatusListener> rateLimitStatusListeners = new ArrayList<RateLimitStatusListener>(0);
    ObjectFactory factory;
    Authorization auth;

    TwitterBaseImpl(Configuration configuration, Authorization authorization) {
        this.conf = configuration;
        this.auth = authorization;
        this.init();
    }

    private void init() {
        if (null == this.auth) {
            String string = this.conf.getOAuthConsumerKey();
            String string2 = this.conf.getOAuthConsumerSecret();
            if (string != null && string2 != null) {
                if (this.conf.isApplicationOnlyAuthEnabled()) {
                    OAuth2Authorization oAuth2Authorization = new OAuth2Authorization(this.conf);
                    String string3 = this.conf.getOAuth2TokenType();
                    String string4 = this.conf.getOAuth2AccessToken();
                    if (string3 != null && string4 != null) {
                        oAuth2Authorization.setOAuth2Token(new OAuth2Token(string3, string4));
                    }
                    this.auth = oAuth2Authorization;
                } else {
                    OAuthAuthorization oAuthAuthorization = new OAuthAuthorization(this.conf);
                    String string5 = this.conf.getOAuthAccessToken();
                    String string6 = this.conf.getOAuthAccessTokenSecret();
                    if (string5 != null && string6 != null) {
                        oAuthAuthorization.setOAuthAccessToken(new AccessToken(string5, string6));
                    }
                    this.auth = oAuthAuthorization;
                }
            } else {
                this.auth = NullAuthorization.getInstance();
            }
        }
        this.http = HttpClientFactory.getInstance(this.conf.getHttpClientConfiguration());
        this.setFactory();
    }

    void setFactory() {
        this.factory = new JSONImplFactory(this.conf);
    }

    @Override
    public String getScreenName() {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
        }
        if (null == this.screenName) {
            if (this.auth instanceof BasicAuthorization) {
                this.screenName = ((BasicAuthorization)this.auth).getUserId();
                if (this.screenName.contains("@")) {
                    this.screenName = null;
                }
            }
            if (null == this.screenName) {
                this.fillInIDAndScreenName();
            }
        }
        return this.screenName;
    }

    @Override
    public long getId() {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
        }
        if (0L == this.id) {
            this.fillInIDAndScreenName();
        }
        return this.id;
    }

    User fillInIDAndScreenName() {
        this.ensureAuthorizationEnabled();
        UserJSONImpl userJSONImpl = new UserJSONImpl(this.http.get(this.conf.getRestBaseURL() + "account/verify_credentials.json", null, this.auth, this), this.conf);
        this.screenName = userJSONImpl.getScreenName();
        this.id = userJSONImpl.getId();
        return userJSONImpl;
    }

    @Override
    public void addRateLimitStatusListener(RateLimitStatusListener rateLimitStatusListener) {
        this.rateLimitStatusListeners.add(rateLimitStatusListener);
    }

    @Override
    public void onRateLimitStatus(final Consumer<RateLimitStatusEvent> consumer) {
        this.rateLimitStatusListeners.add(new RateLimitStatusListener(){

            public void onRateLimitStatus(RateLimitStatusEvent rateLimitStatusEvent) {
                consumer.accept(rateLimitStatusEvent);
            }

            public void onRateLimitReached(RateLimitStatusEvent rateLimitStatusEvent) {
            }
        });
    }

    @Override
    public void onRateLimitReached(final Consumer<RateLimitStatusEvent> consumer) {
        this.rateLimitStatusListeners.add(new RateLimitStatusListener(){

            public void onRateLimitStatus(RateLimitStatusEvent rateLimitStatusEvent) {
            }

            public void onRateLimitReached(RateLimitStatusEvent rateLimitStatusEvent) {
                consumer.accept(rateLimitStatusEvent);
            }
        });
    }

    @Override
    public void httpResponseReceived(HttpResponseEvent httpResponseEvent) {
        block7: {
            int n2;
            RateLimitStatus rateLimitStatus;
            if (this.rateLimitStatusListeners.size() == 0) break block7;
            HttpResponse httpResponse = httpResponseEvent.getResponse();
            TwitterException twitterException = httpResponseEvent.getTwitterException();
            if (twitterException != null) {
                rateLimitStatus = twitterException.getRateLimitStatus();
                n2 = twitterException.getStatusCode();
            } else {
                rateLimitStatus = JSONImplFactory.createRateLimitStatusFromResponseHeader(httpResponse);
                n2 = httpResponse.getStatusCode();
            }
            if (rateLimitStatus != null) {
                RateLimitStatusEvent rateLimitStatusEvent = new RateLimitStatusEvent(this, rateLimitStatus, httpResponseEvent.isAuthenticated());
                if (n2 == 420 || n2 == 503 || n2 == 429) {
                    for (RateLimitStatusListener rateLimitStatusListener : this.rateLimitStatusListeners) {
                        rateLimitStatusListener.onRateLimitStatus(rateLimitStatusEvent);
                        rateLimitStatusListener.onRateLimitReached(rateLimitStatusEvent);
                    }
                } else {
                    for (RateLimitStatusListener rateLimitStatusListener : this.rateLimitStatusListeners) {
                        rateLimitStatusListener.onRateLimitStatus(rateLimitStatusEvent);
                    }
                }
            }
        }
    }

    @Override
    public final Authorization getAuthorization() {
        return this.auth;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    final void ensureAuthorizationEnabled() {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Authentication credentials are missing. See http://twitter4j.org/en/configuration.html for details");
        }
    }

    final void ensureOAuthEnabled() {
        if (!(this.auth instanceof OAuthAuthorization)) {
            throw new IllegalStateException("OAuth required. Authentication credentials are missing. See http://twitter4j.org/en/configuration.html for details");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.putFields();
        objectOutputStream.writeFields();
        objectOutputStream.writeObject(this.conf);
        objectOutputStream.writeObject(this.auth);
        ArrayList<RateLimitStatusListener> arrayList = new ArrayList<RateLimitStatusListener>(0);
        for (RateLimitStatusListener rateLimitStatusListener : this.rateLimitStatusListeners) {
            if (!(rateLimitStatusListener instanceof Serializable)) continue;
            arrayList.add(rateLimitStatusListener);
        }
        objectOutputStream.writeObject(arrayList);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.readFields();
        this.conf = (Configuration)objectInputStream.readObject();
        this.auth = (Authorization)objectInputStream.readObject();
        this.rateLimitStatusListeners = (List)objectInputStream.readObject();
        this.http = HttpClientFactory.getInstance(this.conf.getHttpClientConfiguration());
        this.setFactory();
    }

    @Override
    public synchronized void setOAuthConsumer(String string, String string2) {
        if (null == string) {
            throw new NullPointerException("consumer key is null");
        }
        if (null == string2) {
            throw new NullPointerException("consumer secret is null");
        }
        if (this.auth instanceof NullAuthorization) {
            if (this.conf.isApplicationOnlyAuthEnabled()) {
                OAuth2Authorization oAuth2Authorization = new OAuth2Authorization(this.conf);
                oAuth2Authorization.setOAuthConsumer(string, string2);
                this.auth = oAuth2Authorization;
            } else {
                OAuthAuthorization oAuthAuthorization = new OAuthAuthorization(this.conf);
                oAuthAuthorization.setOAuthConsumer(string, string2);
                this.auth = oAuthAuthorization;
            }
        } else if (this.auth instanceof BasicAuthorization) {
            XAuthAuthorization xAuthAuthorization = new XAuthAuthorization((BasicAuthorization)this.auth);
            xAuthAuthorization.setOAuthConsumer(string, string2);
            this.auth = xAuthAuthorization;
        } else if (this.auth instanceof OAuthAuthorization || this.auth instanceof OAuth2Authorization) {
            throw new IllegalStateException("consumer key/secret pair already set.");
        }
    }

    @Override
    public RequestToken getOAuthRequestToken() {
        return this.getOAuthRequestToken(null);
    }

    @Override
    public RequestToken getOAuthRequestToken(String string) {
        return this.getOAuth().getOAuthRequestToken(string);
    }

    @Override
    public RequestToken getOAuthRequestToken(String string, String string2) {
        return this.getOAuth().getOAuthRequestToken(string, string2);
    }

    @Override
    public RequestToken getOAuthRequestToken(String string, String string2, String string3) {
        return this.getOAuth().getOAuthRequestToken(string, string2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized AccessToken getOAuthAccessToken() {
        AccessToken accessToken;
        Authorization authorization = this.getAuthorization();
        if (authorization instanceof BasicAuthorization) {
            BasicAuthorization basicAuthorization = (BasicAuthorization)authorization;
            authorization = AuthorizationFactory.getInstance(this.conf);
            if (!(authorization instanceof OAuthAuthorization)) throw new IllegalStateException("consumer key / secret combination not supplied.");
            this.auth = authorization;
            OAuthAuthorization oAuthAuthorization = (OAuthAuthorization)authorization;
            accessToken = oAuthAuthorization.getOAuthAccessToken(basicAuthorization.getUserId(), basicAuthorization.getPassword());
        } else if (authorization instanceof XAuthAuthorization) {
            XAuthAuthorization xAuthAuthorization = (XAuthAuthorization)authorization;
            this.auth = xAuthAuthorization;
            OAuthAuthorization oAuthAuthorization = new OAuthAuthorization(this.conf);
            oAuthAuthorization.setOAuthConsumer(xAuthAuthorization.getConsumerKey(), xAuthAuthorization.getConsumerSecret());
            accessToken = oAuthAuthorization.getOAuthAccessToken(xAuthAuthorization.getUserId(), xAuthAuthorization.getPassword());
        } else {
            accessToken = this.getOAuth().getOAuthAccessToken();
        }
        this.screenName = accessToken.getScreenName();
        this.id = accessToken.getUserId();
        return accessToken;
    }

    @Override
    public synchronized AccessToken getOAuthAccessToken(String string) {
        AccessToken accessToken = this.getOAuth().getOAuthAccessToken(string);
        this.screenName = accessToken.getScreenName();
        return accessToken;
    }

    @Override
    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken) {
        OAuthSupport oAuthSupport = this.getOAuth();
        AccessToken accessToken = oAuthSupport.getOAuthAccessToken(requestToken);
        this.screenName = accessToken.getScreenName();
        return accessToken;
    }

    @Override
    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken, String string) {
        return this.getOAuth().getOAuthAccessToken(requestToken, string);
    }

    @Override
    public synchronized void setOAuthAccessToken(AccessToken accessToken) {
        this.getOAuth().setOAuthAccessToken(accessToken);
    }

    @Override
    public synchronized AccessToken getOAuthAccessToken(String string, String string2) {
        return this.getOAuth().getOAuthAccessToken(string, string2);
    }

    private OAuthSupport getOAuth() {
        if (!(this.auth instanceof OAuthSupport)) {
            throw new IllegalStateException("OAuth consumer key/secret combination not supplied");
        }
        return (OAuthSupport)((Object)this.auth);
    }

    @Override
    public synchronized OAuth2Token getOAuth2Token() {
        return this.getOAuth2().getOAuth2Token();
    }

    @Override
    public void setOAuth2Token(OAuth2Token oAuth2Token) {
        this.getOAuth2().setOAuth2Token(oAuth2Token);
    }

    @Override
    public synchronized void invalidateOAuth2Token() {
        this.getOAuth2().invalidateOAuth2Token();
    }

    private OAuth2Support getOAuth2() {
        if (!(this.auth instanceof OAuth2Support)) {
            throw new IllegalStateException("OAuth consumer key/secret combination not supplied");
        }
        return (OAuth2Support)((Object)this.auth);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TwitterBaseImpl)) {
            return false;
        }
        TwitterBaseImpl twitterBaseImpl = (TwitterBaseImpl)object;
        if (this.auth != null ? !this.auth.equals(twitterBaseImpl.auth) : twitterBaseImpl.auth != null) {
            return false;
        }
        if (!this.conf.equals(twitterBaseImpl.conf)) {
            return false;
        }
        if (this.http != null ? !this.http.equals(twitterBaseImpl.http) : twitterBaseImpl.http != null) {
            return false;
        }
        return this.rateLimitStatusListeners.equals(twitterBaseImpl.rateLimitStatusListeners);
    }

    public int hashCode() {
        int n2 = this.conf.hashCode();
        n2 = 31 * n2 + (this.http != null ? this.http.hashCode() : 0);
        n2 = 31 * n2 + this.rateLimitStatusListeners.hashCode();
        n2 = 31 * n2 + (this.auth != null ? this.auth.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "TwitterBase{conf=" + this.conf + ", http=" + this.http + ", rateLimitStatusListeners=" + this.rateLimitStatusListeners + ", auth=" + this.auth + '}';
    }
}

