/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.ExtendedMediaEntity;
import be.maximvdw.featherboardcore.twitter.ExtendedMediaEntityJSONImpl;
import be.maximvdw.featherboardcore.twitter.GeoLocation;
import be.maximvdw.featherboardcore.twitter.HTMLEntity;
import be.maximvdw.featherboardcore.twitter.HashtagEntity;
import be.maximvdw.featherboardcore.twitter.HashtagEntityJSONImpl;
import be.maximvdw.featherboardcore.twitter.HttpResponse;
import be.maximvdw.featherboardcore.twitter.JSONArray;
import be.maximvdw.featherboardcore.twitter.JSONException;
import be.maximvdw.featherboardcore.twitter.JSONImplFactory;
import be.maximvdw.featherboardcore.twitter.JSONObject;
import be.maximvdw.featherboardcore.twitter.Logger;
import be.maximvdw.featherboardcore.twitter.MediaEntity;
import be.maximvdw.featherboardcore.twitter.MediaEntityJSONImpl;
import be.maximvdw.featherboardcore.twitter.ParseUtil;
import be.maximvdw.featherboardcore.twitter.Place;
import be.maximvdw.featherboardcore.twitter.PlaceJSONImpl;
import be.maximvdw.featherboardcore.twitter.ResponseList;
import be.maximvdw.featherboardcore.twitter.ResponseListImpl;
import be.maximvdw.featherboardcore.twitter.Scopes;
import be.maximvdw.featherboardcore.twitter.ScopesImpl;
import be.maximvdw.featherboardcore.twitter.Status;
import be.maximvdw.featherboardcore.twitter.SymbolEntity;
import be.maximvdw.featherboardcore.twitter.TwitterException;
import be.maximvdw.featherboardcore.twitter.TwitterObjectFactory;
import be.maximvdw.featherboardcore.twitter.TwitterResponseImpl;
import be.maximvdw.featherboardcore.twitter.URLEntity;
import be.maximvdw.featherboardcore.twitter.URLEntityJSONImpl;
import be.maximvdw.featherboardcore.twitter.User;
import be.maximvdw.featherboardcore.twitter.UserJSONImpl;
import be.maximvdw.featherboardcore.twitter.UserMentionEntity;
import be.maximvdw.featherboardcore.twitter.UserMentionEntityJSONImpl;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StatusJSONImpl
extends TwitterResponseImpl
implements Status,
Serializable {
    private static final Logger logger = Logger.getLogger(StatusJSONImpl.class);
    private static final long serialVersionUID = -6461195536943679985L;
    private Date createdAt;
    private long id;
    private String text;
    private String source;
    private boolean isTruncated;
    private long inReplyToStatusId;
    private long inReplyToUserId;
    private boolean isFavorited;
    private boolean isRetweeted;
    private int favoriteCount;
    private String inReplyToScreenName;
    private GeoLocation geoLocation = null;
    private Place place = null;
    private long retweetCount;
    private boolean isPossiblySensitive;
    private String lang;
    private long[] contributorsIDs;
    private Status retweetedStatus;
    private UserMentionEntity[] userMentionEntities;
    private URLEntity[] urlEntities;
    private HashtagEntity[] hashtagEntities;
    private MediaEntity[] mediaEntities;
    private ExtendedMediaEntity[] extendedMediaEntities;
    private SymbolEntity[] symbolEntities;
    private long currentUserRetweetId = -1L;
    private Scopes scopes;
    private User user = null;
    private String[] withheldInCountries = null;
    private Status quotedStatus;
    private long quotedStatusId = -1L;

    StatusJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, jSONObject);
        }
    }

    StatusJSONImpl(JSONObject jSONObject, Configuration configuration) {
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.registerJSONObject(this, jSONObject);
        }
    }

    StatusJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    StatusJSONImpl() {
    }

    private void init(JSONObject jSONObject) {
        this.id = ParseUtil.getLong("id", jSONObject);
        this.source = ParseUtil.getUnescapedString("source", jSONObject);
        this.createdAt = ParseUtil.getDate("created_at", jSONObject);
        this.isTruncated = ParseUtil.getBoolean("truncated", jSONObject);
        this.inReplyToStatusId = ParseUtil.getLong("in_reply_to_status_id", jSONObject);
        this.inReplyToUserId = ParseUtil.getLong("in_reply_to_user_id", jSONObject);
        this.isFavorited = ParseUtil.getBoolean("favorited", jSONObject);
        this.isRetweeted = ParseUtil.getBoolean("retweeted", jSONObject);
        this.inReplyToScreenName = ParseUtil.getUnescapedString("in_reply_to_screen_name", jSONObject);
        this.retweetCount = ParseUtil.getLong("retweet_count", jSONObject);
        this.favoriteCount = ParseUtil.getInt("favorite_count", jSONObject);
        this.isPossiblySensitive = ParseUtil.getBoolean("possibly_sensitive", jSONObject);
        try {
            int n2;
            int n3;
            Object object;
            if (!jSONObject.isNull("user")) {
                this.user = new UserJSONImpl(jSONObject.getJSONObject("user"));
            }
            this.geoLocation = JSONImplFactory.createGeoLocation(jSONObject);
            if (!jSONObject.isNull("place")) {
                this.place = new PlaceJSONImpl(jSONObject.getJSONObject("place"));
            }
            if (!jSONObject.isNull("retweeted_status")) {
                this.retweetedStatus = new StatusJSONImpl(jSONObject.getJSONObject("retweeted_status"));
            }
            if (!jSONObject.isNull("contributors")) {
                object = jSONObject.getJSONArray("contributors");
                this.contributorsIDs = new long[((JSONArray)object).length()];
                for (n3 = 0; n3 < ((JSONArray)object).length(); ++n3) {
                    this.contributorsIDs[n3] = Long.parseLong(((JSONArray)object).getString(n3));
                }
            } else {
                this.contributorsIDs = new long[0];
            }
            if (!jSONObject.isNull("entities")) {
                JSONArray jSONArray;
                object = jSONObject.getJSONObject("entities");
                if (!((JSONObject)object).isNull("user_mentions")) {
                    jSONArray = ((JSONObject)object).getJSONArray("user_mentions");
                    n3 = jSONArray.length();
                    this.userMentionEntities = new UserMentionEntity[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.userMentionEntities[n2] = new UserMentionEntityJSONImpl(jSONArray.getJSONObject(n2));
                    }
                }
                if (!((JSONObject)object).isNull("urls")) {
                    jSONArray = ((JSONObject)object).getJSONArray("urls");
                    n3 = jSONArray.length();
                    this.urlEntities = new URLEntity[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.urlEntities[n2] = new URLEntityJSONImpl(jSONArray.getJSONObject(n2));
                    }
                }
                if (!((JSONObject)object).isNull("hashtags")) {
                    jSONArray = ((JSONObject)object).getJSONArray("hashtags");
                    n3 = jSONArray.length();
                    this.hashtagEntities = new HashtagEntity[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.hashtagEntities[n2] = new HashtagEntityJSONImpl(jSONArray.getJSONObject(n2));
                    }
                }
                if (!((JSONObject)object).isNull("symbols")) {
                    jSONArray = ((JSONObject)object).getJSONArray("symbols");
                    n3 = jSONArray.length();
                    this.symbolEntities = new SymbolEntity[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.symbolEntities[n2] = new HashtagEntityJSONImpl(jSONArray.getJSONObject(n2));
                    }
                }
                if (!((JSONObject)object).isNull("media")) {
                    jSONArray = ((JSONObject)object).getJSONArray("media");
                    n3 = jSONArray.length();
                    this.mediaEntities = new MediaEntity[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.mediaEntities[n2] = new MediaEntityJSONImpl(jSONArray.getJSONObject(n2));
                    }
                }
            }
            if (!jSONObject.isNull("extended_entities") && !((JSONObject)(object = jSONObject.getJSONObject("extended_entities"))).isNull("media")) {
                JSONArray jSONArray = ((JSONObject)object).getJSONArray("media");
                int n4 = jSONArray.length();
                this.extendedMediaEntities = new ExtendedMediaEntity[n4];
                for (n2 = 0; n2 < n4; ++n2) {
                    this.extendedMediaEntities[n2] = new ExtendedMediaEntityJSONImpl(jSONArray.getJSONObject(n2));
                }
            }
            if (!jSONObject.isNull("quoted_status")) {
                this.quotedStatus = new StatusJSONImpl(jSONObject.getJSONObject("quoted_status"));
            }
            if (!jSONObject.isNull("quoted_status_id")) {
                this.quotedStatusId = ParseUtil.getLong("quoted_status_id", jSONObject);
            }
            if (!jSONObject.isNull("quoted_status")) {
                this.quotedStatus = new StatusJSONImpl(jSONObject.getJSONObject("quoted_status"));
            }
            if (!jSONObject.isNull("quoted_status_id")) {
                this.quotedStatusId = ParseUtil.getLong("quoted_status_id", jSONObject);
            }
            this.userMentionEntities = this.userMentionEntities == null ? new UserMentionEntity[]{} : this.userMentionEntities;
            this.urlEntities = this.urlEntities == null ? new URLEntity[]{} : this.urlEntities;
            this.hashtagEntities = this.hashtagEntities == null ? new HashtagEntity[]{} : this.hashtagEntities;
            this.symbolEntities = this.symbolEntities == null ? new SymbolEntity[]{} : this.symbolEntities;
            this.mediaEntities = this.mediaEntities == null ? new MediaEntity[]{} : this.mediaEntities;
            this.extendedMediaEntities = this.extendedMediaEntities == null ? new ExtendedMediaEntity[]{} : this.extendedMediaEntities;
            this.text = HTMLEntity.unescapeAndSlideEntityIncdices(jSONObject.getString("text"), this.userMentionEntities, this.urlEntities, this.hashtagEntities, this.mediaEntities);
            if (!jSONObject.isNull("current_user_retweet")) {
                this.currentUserRetweetId = jSONObject.getJSONObject("current_user_retweet").getLong("id");
            }
            if (!jSONObject.isNull("lang")) {
                this.lang = ParseUtil.getUnescapedString("lang", jSONObject);
            }
            if (!jSONObject.isNull("scopes") && !((JSONObject)(object = jSONObject.getJSONObject("scopes"))).isNull("place_ids")) {
                JSONArray jSONArray = ((JSONObject)object).getJSONArray("place_ids");
                int n5 = jSONArray.length();
                String[] stringArray = new String[n5];
                for (int i2 = 0; i2 < n5; ++i2) {
                    stringArray[i2] = jSONArray.getString(i2);
                }
                this.scopes = new ScopesImpl(stringArray);
            }
            if (!jSONObject.isNull("withheld_in_countries")) {
                object = jSONObject.getJSONArray("withheld_in_countries");
                int n6 = ((JSONArray)object).length();
                this.withheldInCountries = new String[n6];
                for (int i3 = 0; i3 < n6; ++i3) {
                    this.withheldInCountries[i3] = ((JSONArray)object).getString(i3);
                }
            }
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    @Override
    public int compareTo(Status status) {
        long l2 = this.id - status.getId();
        if (l2 < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean isTruncated() {
        return this.isTruncated;
    }

    @Override
    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    @Override
    public long getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    @Override
    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    @Override
    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public long[] getContributors() {
        return this.contributorsIDs;
    }

    @Override
    public boolean isFavorited() {
        return this.isFavorited;
    }

    @Override
    public boolean isRetweeted() {
        return this.isRetweeted;
    }

    @Override
    public int getFavoriteCount() {
        return this.favoriteCount;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public boolean isRetweet() {
        return this.retweetedStatus != null;
    }

    @Override
    public Status getRetweetedStatus() {
        return this.retweetedStatus;
    }

    @Override
    public int getRetweetCount() {
        return (int)this.retweetCount;
    }

    @Override
    public boolean isRetweetedByMe() {
        return this.currentUserRetweetId != -1L;
    }

    @Override
    public long getCurrentUserRetweetId() {
        return this.currentUserRetweetId;
    }

    @Override
    public boolean isPossiblySensitive() {
        return this.isPossiblySensitive;
    }

    @Override
    public UserMentionEntity[] getUserMentionEntities() {
        return this.userMentionEntities;
    }

    @Override
    public URLEntity[] getURLEntities() {
        return this.urlEntities;
    }

    @Override
    public HashtagEntity[] getHashtagEntities() {
        return this.hashtagEntities;
    }

    @Override
    public MediaEntity[] getMediaEntities() {
        return this.mediaEntities;
    }

    @Override
    public ExtendedMediaEntity[] getExtendedMediaEntities() {
        return this.extendedMediaEntities;
    }

    @Override
    public SymbolEntity[] getSymbolEntities() {
        return this.symbolEntities;
    }

    @Override
    public Scopes getScopes() {
        return this.scopes;
    }

    @Override
    public String[] getWithheldInCountries() {
        return this.withheldInCountries;
    }

    @Override
    public long getQuotedStatusId() {
        return this.quotedStatusId;
    }

    @Override
    public Status getQuotedStatus() {
        return this.quotedStatus;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    static ResponseList<Status> createStatusList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.clearThreadLocalMap();
            }
            JSONArray jSONArray = httpResponse.asJSONArray();
            int n2 = jSONArray.length();
            ResponseListImpl<Status> responseListImpl = new ResponseListImpl<Status>(n2, httpResponse);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                StatusJSONImpl statusJSONImpl = new StatusJSONImpl(jSONObject);
                if (configuration.isJSONStoreEnabled()) {
                    TwitterObjectFactory.registerJSONObject(statusJSONImpl, jSONObject);
                }
                responseListImpl.add(statusJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return object instanceof Status && ((Status)object).getId() == this.id;
    }

    public String toString() {
        return "StatusJSONImpl{createdAt=" + this.createdAt + ", id=" + this.id + ", text='" + this.text + '\'' + ", source='" + this.source + '\'' + ", isTruncated=" + this.isTruncated + ", inReplyToStatusId=" + this.inReplyToStatusId + ", inReplyToUserId=" + this.inReplyToUserId + ", isFavorited=" + this.isFavorited + ", isRetweeted=" + this.isRetweeted + ", favoriteCount=" + this.favoriteCount + ", inReplyToScreenName='" + this.inReplyToScreenName + '\'' + ", geoLocation=" + this.geoLocation + ", place=" + this.place + ", retweetCount=" + this.retweetCount + ", isPossiblySensitive=" + this.isPossiblySensitive + ", lang='" + this.lang + '\'' + ", contributorsIDs=" + Arrays.toString(this.contributorsIDs) + ", retweetedStatus=" + this.retweetedStatus + ", userMentionEntities=" + Arrays.toString(this.userMentionEntities) + ", urlEntities=" + Arrays.toString(this.urlEntities) + ", hashtagEntities=" + Arrays.toString(this.hashtagEntities) + ", mediaEntities=" + Arrays.toString(this.mediaEntities) + ", symbolEntities=" + Arrays.toString(this.symbolEntities) + ", currentUserRetweetId=" + this.currentUserRetweetId + ", user=" + this.user + ", withHeldInCountries=" + Arrays.toString(this.withheldInCountries) + ", quotedStatusId=" + this.quotedStatusId + ", quotedStatus=" + this.quotedStatus + '}';
    }
}

