/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.HttpResponse;
import be.maximvdw.featherboardcore.twitter.JSONException;
import be.maximvdw.featherboardcore.twitter.JSONObject;
import be.maximvdw.featherboardcore.twitter.ParseUtil;
import be.maximvdw.featherboardcore.twitter.RateLimitStatus;
import be.maximvdw.featherboardcore.twitter.TwitterException;
import be.maximvdw.featherboardcore.twitter.TwitterObjectFactory;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RateLimitStatusJSONImpl
implements RateLimitStatus,
Serializable {
    private static final long serialVersionUID = 7790337632915862445L;
    private int remaining;
    private int limit;
    private int resetTimeInSeconds;
    private int secondsUntilReset;

    static Map<String, RateLimitStatus> createRateLimitStatuses(HttpResponse httpResponse, Configuration configuration) {
        JSONObject jSONObject = httpResponse.asJSONObject();
        Map<String, RateLimitStatus> map = RateLimitStatusJSONImpl.createRateLimitStatuses(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(map, jSONObject);
        }
        return map;
    }

    static Map<String, RateLimitStatus> createRateLimitStatuses(JSONObject jSONObject) {
        HashMap<String, RateLimitStatusJSONImpl> hashMap = new HashMap<String, RateLimitStatusJSONImpl>();
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject("resources");
            Iterator iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                JSONObject jSONObject3 = jSONObject2.getJSONObject((String)iterator.next());
                Iterator iterator2 = jSONObject3.keys();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    JSONObject jSONObject4 = jSONObject3.getJSONObject(string);
                    RateLimitStatusJSONImpl rateLimitStatusJSONImpl = new RateLimitStatusJSONImpl(jSONObject4);
                    hashMap.put(string, rateLimitStatusJSONImpl);
                }
            }
            return Collections.unmodifiableMap(hashMap);
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    private RateLimitStatusJSONImpl(int n2, int n3, int n4) {
        this.limit = n2;
        this.remaining = n3;
        this.resetTimeInSeconds = n4;
        this.secondsUntilReset = (int)(((long)n4 * 1000L - System.currentTimeMillis()) / 1000L);
    }

    RateLimitStatusJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    void init(JSONObject jSONObject) {
        this.limit = ParseUtil.getInt("limit", jSONObject);
        this.remaining = ParseUtil.getInt("remaining", jSONObject);
        this.resetTimeInSeconds = ParseUtil.getInt("reset", jSONObject);
        this.secondsUntilReset = (int)(((long)this.resetTimeInSeconds * 1000L - System.currentTimeMillis()) / 1000L);
    }

    static RateLimitStatus createFromResponseHeader(HttpResponse httpResponse) {
        if (null == httpResponse) {
            return null;
        }
        String string = httpResponse.getResponseHeader("X-Rate-Limit-Limit");
        if (string == null) {
            return null;
        }
        int n2 = Integer.parseInt(string);
        String string2 = httpResponse.getResponseHeader("X-Rate-Limit-Remaining");
        if (string2 == null) {
            return null;
        }
        int n3 = Integer.parseInt(string2);
        String string3 = httpResponse.getResponseHeader("X-Rate-Limit-Reset");
        if (string3 == null) {
            return null;
        }
        long l2 = Long.parseLong(string3);
        int n4 = (int)l2;
        return new RateLimitStatusJSONImpl(n2, n3, n4);
    }

    @Override
    public int getRemaining() {
        return this.remaining;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getResetTimeInSeconds() {
        return this.resetTimeInSeconds;
    }

    @Override
    public int getSecondsUntilReset() {
        return this.secondsUntilReset;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RateLimitStatusJSONImpl rateLimitStatusJSONImpl = (RateLimitStatusJSONImpl)object;
        if (this.limit != rateLimitStatusJSONImpl.limit) {
            return false;
        }
        if (this.remaining != rateLimitStatusJSONImpl.remaining) {
            return false;
        }
        if (this.resetTimeInSeconds != rateLimitStatusJSONImpl.resetTimeInSeconds) {
            return false;
        }
        return this.secondsUntilReset == rateLimitStatusJSONImpl.secondsUntilReset;
    }

    public int hashCode() {
        int n2 = this.remaining;
        n2 = 31 * n2 + this.limit;
        n2 = 31 * n2 + this.resetTimeInSeconds;
        n2 = 31 * n2 + this.secondsUntilReset;
        return n2;
    }

    public String toString() {
        return "RateLimitStatusJSONImpl{remaining=" + this.remaining + ", limit=" + this.limit + ", resetTimeInSeconds=" + this.resetTimeInSeconds + ", secondsUntilReset=" + this.secondsUntilReset + '}';
    }
}

