/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.LoggerFactory;
import be.maximvdw.featherboardcore.twitter.StdOutLoggerFactory;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;
import be.maximvdw.featherboardcore.twitter.conf.ConfigurationContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Logger {
    private static final LoggerFactory LOGGER_FACTORY;
    private static final String LOGGER_FACTORY_IMPLEMENTATION = "be.maximvdw.featherboardcore.twitter.loggerFactory";

    private static LoggerFactory getLoggerFactoryIfAvailable(String string, String string2) {
        try {
            Class.forName(string);
            return (LoggerFactory)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        return null;
    }

    public static Logger getLogger(Class<?> clazz) {
        return LOGGER_FACTORY.getLogger(clazz);
    }

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract void debug(String var1);

    public abstract void debug(String var1, String var2);

    public abstract void info(String var1);

    public abstract void info(String var1, String var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, String var2);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    static {
        Configuration configuration;
        LoggerFactory loggerFactory = null;
        String string = System.getProperty(LOGGER_FACTORY_IMPLEMENTATION);
        if (string != null) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable(string, string);
        }
        if ((string = (configuration = ConfigurationContext.getInstance()).getLoggerFactory()) != null) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable(string, string);
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable("org.slf4j.impl.StaticLoggerBinder", "be.maximvdw.featherboardcore.twitter.SLF4JLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable("org.apache.commons.logging.Log", "be.maximvdw.featherboardcore.twitter.CommonsLoggingLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable("org.apache.log4j.Logger", "be.maximvdw.featherboardcore.twitter.Log4JLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable("com.google.appengine.api.urlfetch.URLFetchService", "be.maximvdw.featherboardcore.twitter.JULLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = new StdOutLoggerFactory();
        }
        LOGGER_FACTORY = loggerFactory;
        try {
            Method method = configuration.getClass().getMethod("dumpConfiguration", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)configuration, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

