/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.AccountSettings;
import be.maximvdw.featherboardcore.twitter.AccountSettingsJSONImpl;
import be.maximvdw.featherboardcore.twitter.AccountTotals;
import be.maximvdw.featherboardcore.twitter.AccountTotalsJSONImpl;
import be.maximvdw.featherboardcore.twitter.Category;
import be.maximvdw.featherboardcore.twitter.CategoryJSONImpl;
import be.maximvdw.featherboardcore.twitter.DirectMessage;
import be.maximvdw.featherboardcore.twitter.DirectMessageJSONImpl;
import be.maximvdw.featherboardcore.twitter.Friendship;
import be.maximvdw.featherboardcore.twitter.FriendshipJSONImpl;
import be.maximvdw.featherboardcore.twitter.GeoLocation;
import be.maximvdw.featherboardcore.twitter.HashtagEntity;
import be.maximvdw.featherboardcore.twitter.HashtagEntityJSONImpl;
import be.maximvdw.featherboardcore.twitter.HttpResponse;
import be.maximvdw.featherboardcore.twitter.IDs;
import be.maximvdw.featherboardcore.twitter.IDsJSONImpl;
import be.maximvdw.featherboardcore.twitter.JSONArray;
import be.maximvdw.featherboardcore.twitter.JSONException;
import be.maximvdw.featherboardcore.twitter.JSONObject;
import be.maximvdw.featherboardcore.twitter.LanguageJSONImpl;
import be.maximvdw.featherboardcore.twitter.Location;
import be.maximvdw.featherboardcore.twitter.LocationJSONImpl;
import be.maximvdw.featherboardcore.twitter.OEmbed;
import be.maximvdw.featherboardcore.twitter.OEmbedJSONImpl;
import be.maximvdw.featherboardcore.twitter.ObjectFactory;
import be.maximvdw.featherboardcore.twitter.PagableResponseList;
import be.maximvdw.featherboardcore.twitter.Place;
import be.maximvdw.featherboardcore.twitter.PlaceJSONImpl;
import be.maximvdw.featherboardcore.twitter.Query;
import be.maximvdw.featherboardcore.twitter.QueryResult;
import be.maximvdw.featherboardcore.twitter.QueryResultJSONImpl;
import be.maximvdw.featherboardcore.twitter.RateLimitStatus;
import be.maximvdw.featherboardcore.twitter.RateLimitStatusJSONImpl;
import be.maximvdw.featherboardcore.twitter.Relationship;
import be.maximvdw.featherboardcore.twitter.RelationshipJSONImpl;
import be.maximvdw.featherboardcore.twitter.ResponseList;
import be.maximvdw.featherboardcore.twitter.ResponseListImpl;
import be.maximvdw.featherboardcore.twitter.SavedSearch;
import be.maximvdw.featherboardcore.twitter.SavedSearchJSONImpl;
import be.maximvdw.featherboardcore.twitter.Status;
import be.maximvdw.featherboardcore.twitter.StatusJSONImpl;
import be.maximvdw.featherboardcore.twitter.Trends;
import be.maximvdw.featherboardcore.twitter.TrendsJSONImpl;
import be.maximvdw.featherboardcore.twitter.TwitterAPIConfiguration;
import be.maximvdw.featherboardcore.twitter.TwitterAPIConfigurationJSONImpl;
import be.maximvdw.featherboardcore.twitter.TwitterException;
import be.maximvdw.featherboardcore.twitter.URLEntity;
import be.maximvdw.featherboardcore.twitter.URLEntityJSONImpl;
import be.maximvdw.featherboardcore.twitter.User;
import be.maximvdw.featherboardcore.twitter.UserJSONImpl;
import be.maximvdw.featherboardcore.twitter.UserList;
import be.maximvdw.featherboardcore.twitter.UserListJSONImpl;
import be.maximvdw.featherboardcore.twitter.UserMentionEntity;
import be.maximvdw.featherboardcore.twitter.UserMentionEntityJSONImpl;
import be.maximvdw.featherboardcore.twitter.api.HelpResources;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSONImplFactory
implements ObjectFactory {
    private static final long serialVersionUID = -1853541456182663343L;
    private final Configuration conf;

    public JSONImplFactory(Configuration configuration) {
        this.conf = configuration;
    }

    @Override
    public Status createStatus(JSONObject jSONObject) {
        return new StatusJSONImpl(jSONObject);
    }

    @Override
    public User createUser(JSONObject jSONObject) {
        return new UserJSONImpl(jSONObject);
    }

    @Override
    public UserList createAUserList(JSONObject jSONObject) {
        return new UserListJSONImpl(jSONObject);
    }

    @Override
    public Map<String, RateLimitStatus> createRateLimitStatuses(HttpResponse httpResponse) {
        return RateLimitStatusJSONImpl.createRateLimitStatuses(httpResponse, this.conf);
    }

    @Override
    public Status createStatus(HttpResponse httpResponse) {
        return new StatusJSONImpl(httpResponse, this.conf);
    }

    @Override
    public ResponseList<Status> createStatusList(HttpResponse httpResponse) {
        return StatusJSONImpl.createStatusList(httpResponse, this.conf);
    }

    static GeoLocation createGeoLocation(JSONObject jSONObject) {
        try {
            if (!jSONObject.isNull("coordinates")) {
                String string = jSONObject.getJSONObject("coordinates").getString("coordinates");
                string = string.substring(1, string.length() - 1);
                String[] stringArray = string.split(",");
                return new GeoLocation(Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[0]));
            }
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
        return null;
    }

    static GeoLocation[][] coordinatesAsGeoLocationArray(JSONArray jSONArray) {
        try {
            GeoLocation[][] geoLocationArray = new GeoLocation[jSONArray.length()][];
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONArray jSONArray2 = jSONArray.getJSONArray(i2);
                geoLocationArray[i2] = new GeoLocation[jSONArray2.length()];
                for (int i3 = 0; i3 < jSONArray2.length(); ++i3) {
                    JSONArray jSONArray3 = jSONArray2.getJSONArray(i3);
                    geoLocationArray[i2][i3] = new GeoLocation(jSONArray3.getDouble(1), jSONArray3.getDouble(0));
                }
            }
            return geoLocationArray;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static RateLimitStatus createRateLimitStatusFromResponseHeader(HttpResponse httpResponse) {
        return RateLimitStatusJSONImpl.createFromResponseHeader(httpResponse);
    }

    @Override
    public Trends createTrends(HttpResponse httpResponse) {
        return new TrendsJSONImpl(httpResponse, this.conf);
    }

    @Override
    public User createUser(HttpResponse httpResponse) {
        return new UserJSONImpl(httpResponse, this.conf);
    }

    @Override
    public ResponseList<User> createUserList(HttpResponse httpResponse) {
        return UserJSONImpl.createUserList(httpResponse, this.conf);
    }

    @Override
    public ResponseList<User> createUserListFromJSONArray(HttpResponse httpResponse) {
        return UserJSONImpl.createUserList(httpResponse.asJSONArray(), httpResponse, this.conf);
    }

    @Override
    public ResponseList<User> createUserListFromJSONArray_Users(HttpResponse httpResponse) {
        try {
            return UserJSONImpl.createUserList(httpResponse.asJSONObject().getJSONArray("users"), httpResponse, this.conf);
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    @Override
    public QueryResult createQueryResult(HttpResponse httpResponse, Query query) {
        try {
            return new QueryResultJSONImpl(httpResponse, this.conf);
        }
        catch (TwitterException twitterException) {
            if (404 == twitterException.getStatusCode()) {
                return new QueryResultJSONImpl(query);
            }
            throw twitterException;
        }
    }

    @Override
    public IDs createIDs(HttpResponse httpResponse) {
        return new IDsJSONImpl(httpResponse, this.conf);
    }

    @Override
    public PagableResponseList<User> createPagableUserList(HttpResponse httpResponse) {
        return UserJSONImpl.createPagableUserList(httpResponse, this.conf);
    }

    @Override
    public UserList createAUserList(HttpResponse httpResponse) {
        return new UserListJSONImpl(httpResponse, this.conf);
    }

    @Override
    public PagableResponseList<UserList> createPagableUserListList(HttpResponse httpResponse) {
        return UserListJSONImpl.createPagableUserListList(httpResponse, this.conf);
    }

    @Override
    public ResponseList<UserList> createUserListList(HttpResponse httpResponse) {
        return UserListJSONImpl.createUserListList(httpResponse, this.conf);
    }

    @Override
    public ResponseList<Category> createCategoryList(HttpResponse httpResponse) {
        return CategoryJSONImpl.createCategoriesList(httpResponse, this.conf);
    }

    @Override
    public DirectMessage createDirectMessage(HttpResponse httpResponse) {
        return new DirectMessageJSONImpl(httpResponse, this.conf);
    }

    @Override
    public ResponseList<DirectMessage> createDirectMessageList(HttpResponse httpResponse) {
        return DirectMessageJSONImpl.createDirectMessageList(httpResponse, this.conf);
    }

    @Override
    public Relationship createRelationship(HttpResponse httpResponse) {
        return new RelationshipJSONImpl(httpResponse, this.conf);
    }

    @Override
    public ResponseList<Friendship> createFriendshipList(HttpResponse httpResponse) {
        return FriendshipJSONImpl.createFriendshipList(httpResponse, this.conf);
    }

    @Override
    public AccountTotals createAccountTotals(HttpResponse httpResponse) {
        return new AccountTotalsJSONImpl(httpResponse, this.conf);
    }

    @Override
    public AccountSettings createAccountSettings(HttpResponse httpResponse) {
        return new AccountSettingsJSONImpl(httpResponse, this.conf);
    }

    @Override
    public SavedSearch createSavedSearch(HttpResponse httpResponse) {
        return new SavedSearchJSONImpl(httpResponse, this.conf);
    }

    @Override
    public ResponseList<SavedSearch> createSavedSearchList(HttpResponse httpResponse) {
        return SavedSearchJSONImpl.createSavedSearchList(httpResponse, this.conf);
    }

    @Override
    public ResponseList<Location> createLocationList(HttpResponse httpResponse) {
        return LocationJSONImpl.createLocationList(httpResponse, this.conf);
    }

    @Override
    public Place createPlace(HttpResponse httpResponse) {
        return new PlaceJSONImpl(httpResponse, this.conf);
    }

    @Override
    public ResponseList<Place> createPlaceList(HttpResponse httpResponse) {
        try {
            return PlaceJSONImpl.createPlaceList(httpResponse, this.conf);
        }
        catch (TwitterException twitterException) {
            if (twitterException.getStatusCode() == 404) {
                return new ResponseListImpl<Place>(0, null);
            }
            throw twitterException;
        }
    }

    @Override
    public TwitterAPIConfiguration createTwitterAPIConfiguration(HttpResponse httpResponse) {
        return new TwitterAPIConfigurationJSONImpl(httpResponse, this.conf);
    }

    @Override
    public ResponseList<HelpResources.Language> createLanguageList(HttpResponse httpResponse) {
        return LanguageJSONImpl.createLanguageList(httpResponse, this.conf);
    }

    @Override
    public <T> ResponseList<T> createEmptyResponseList() {
        return new ResponseListImpl(0, null);
    }

    @Override
    public OEmbed createOEmbed(HttpResponse httpResponse) {
        return new OEmbedJSONImpl(httpResponse, this.conf);
    }

    public static HashtagEntity createHashtagEntity(int n2, int n3, String string) {
        return new HashtagEntityJSONImpl(n2, n3, string);
    }

    public static UserMentionEntity createUserMentionEntity(int n2, int n3, String string, String string2, long l2) {
        return new UserMentionEntityJSONImpl(n2, n3, string, string2, l2);
    }

    public static URLEntity createUrlEntity(int n2, int n3, String string, String string2, String string3) {
        return new URLEntityJSONImpl(n2, n3, string, string2, string3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JSONImplFactory)) {
            return false;
        }
        JSONImplFactory jSONImplFactory = (JSONImplFactory)object;
        return !(this.conf != null ? !this.conf.equals(jSONImplFactory.conf) : jSONImplFactory.conf != null);
    }

    public int hashCode() {
        return this.conf != null ? this.conf.hashCode() : 0;
    }

    public String toString() {
        return "JSONImplFactory{conf=" + this.conf + '}';
    }
}

