/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.placeholders;

import be.maximvdw.featherboardcore.hooks.c;
import be.maximvdw.featherboardcore.n.c;
import be.maximvdw.featherboardcore.o.f;
import be.maximvdw.featherboardcore.p.a.h;
import be.maximvdw.featherboardcore.p.g;
import be.maximvdw.featherboardcore.placeholders.OnlinePlaceholderReplacer;
import be.maximvdw.featherboardcore.placeholders.PlaceholderReplacer;
import java.io.File;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class Placeholder {
    private static List<Placeholder> placeholderGroups = new ArrayList<Placeholder>();
    private static List<b> refreshHandles = new ArrayList<b>();
    private Map<String, PlaceholderReplacer<?>> placeholders = new ConcurrentHashMap();
    protected Plugin plugin = null;
    private be.maximvdw.featherboardcore.n.f storage = null;
    private be.maximvdw.featherboardcore.n.c configBuilder = null;
    private static String startCharacter = "{";
    private static String endCharacter = "}";
    private String name = "";
    private TreeMap<a, String> placeholderConditions = new TreeMap();
    private boolean enabled = true;
    private boolean actionPlaceholder = false;
    private boolean containsWildcards = false;
    private String description = "";
    private String pluginURL = "";
    private int version = 1;
    private static boolean ignoreProblems = false;

    public Placeholder(Plugin plugin, String string) {
        this.plugin = plugin;
        this.setName(string);
    }

    public Placeholder(Plugin plugin, String string, int n2) {
        this.plugin = plugin;
        this.setName(string);
        this.setVersion(n2);
    }

    public Placeholder(String string) {
        this.setName(string);
    }

    public static void clear() {
        placeholderGroups.clear();
    }

    public static void clearUnused() {
        ArrayList<Placeholder> arrayList = new ArrayList<Placeholder>(placeholderGroups);
        for (Placeholder placeholder : arrayList) {
            if (placeholder.isEnabled()) continue;
            placeholderGroups.remove(placeholder);
        }
    }

    public static List<Placeholder> getPlaceholders() {
        return placeholderGroups;
    }

    public YamlConfiguration getConfig() {
        if (this.storage == null) {
            return null;
        }
        return this.storage.a();
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void update() {
        ArrayList<Placeholder> arrayList = new ArrayList<Placeholder>(placeholderGroups);
        for (Placeholder placeholder : arrayList) {
            if (!placeholder.getName().equalsIgnoreCase(this.getName())) continue;
            placeholderGroups.remove(placeholder);
            placeholderGroups.add(this);
        }
    }

    public static boolean containsPlaceholders(String string) {
        Pattern pattern = Pattern.compile(new String(Placeholder.getStartCharacterEscaped() + "(.([^" + Placeholder.getStartCharacterEscaped() + Placeholder.getEndCharacterEscaped() + "]+|[^" + Placeholder.getStartCharacterEscaped() + Placeholder.getEndCharacterEscaped() + "])?)" + Placeholder.getEndCharacterEscaped()), 34);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public static TreeMap<String, String> getPlaceholders(TreeMap<String, String> treeMap, String string, Player player) {
        return Placeholder.getPlaceholders(treeMap, string, (OfflinePlayer)player);
    }

    public static String getPlaceholderResult(String string, OfflinePlayer offlinePlayer) {
        String string2 = string;
        TreeMap<String, String> treeMap = Placeholder.getPlaceholders(new TreeMap<String, String>(), string2, offlinePlayer);
        for (String string3 : treeMap.keySet()) {
            string2 = string2.replaceAll(string3, treeMap.get(string3));
        }
        return string2;
    }

    public static List<Placeholder> getPlaceholderReplacers(String string) {
        ArrayList<Placeholder> arrayList = new ArrayList<Placeholder>();
        List<Placeholder> list = Placeholder.getEnabledPlaceholderGroups();
        Pattern pattern = Pattern.compile(new String(Placeholder.getStartCharacterEscaped() + "(.([^" + Placeholder.getStartCharacterEscaped() + Placeholder.getEndCharacterEscaped() + "]+|[^" + Placeholder.getStartCharacterEscaped() + Placeholder.getEndCharacterEscaped() + "])?)" + Placeholder.getEndCharacterEscaped()), 34);
        Matcher matcher = pattern.matcher(string);
        block0: while (matcher.find()) {
            String string2 = matcher.group(0).toLowerCase();
            boolean bl2 = false;
            for (Placeholder placeholder : list) {
                boolean bl3 = placeholder.getPlaceholder().contains(string2);
                if (placeholder.containsWildcards && !bl3) {
                    for (String string3 : placeholder.getPlaceholder()) {
                        String string4 = string3;
                        if (string4.contains("*")) {
                            string4 = string4.substring(0, string4.indexOf(42));
                        }
                        if (!string2.startsWith(string4.toLowerCase())) continue;
                        arrayList.add(placeholder);
                        bl2 = true;
                        break;
                    }
                } else if (bl3 && !string2.contains("*")) {
                    arrayList.add(placeholder);
                    bl2 = true;
                    continue block0;
                }
                if (!bl2) continue;
                continue block0;
            }
        }
        return arrayList;
    }

    public static TreeMap<String, String> getPlaceholders(List<Placeholder> list, String string, OfflinePlayer offlinePlayer) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Pattern pattern = Pattern.compile(new String(Placeholder.getStartCharacterEscaped() + "(.([^" + Placeholder.getStartCharacterEscaped() + Placeholder.getEndCharacterEscaped() + "]+|[^" + Placeholder.getStartCharacterEscaped() + Placeholder.getEndCharacterEscaped() + "])?)" + Placeholder.getEndCharacterEscaped()), 34);
        Matcher matcher = pattern.matcher(string);
        block4: while (matcher.find()) {
            String string2 = matcher.group(0).toLowerCase();
            boolean bl2 = false;
            for (Placeholder placeholder : list) {
                Object object;
                boolean bl3 = placeholder.getPlaceholder().contains(string2);
                if (placeholder.containsWildcards && !bl3) {
                    for (String string3 : placeholder.getPlaceholder()) {
                        String string4;
                        String string5;
                        block25: {
                            object = string3;
                            if (((String)object).contains("*")) {
                                object = ((String)object).substring(0, ((String)object).indexOf(42));
                            }
                            if (!string2.startsWith(((String)object).toLowerCase())) continue;
                            string5 = "";
                            string4 = matcher.group(1);
                            try {
                                PlaceholderReplacer<?> placeholderReplacer = placeholder.getPlaceholderReplacer(string3);
                                if (placeholderReplacer != null && !string2.contains("*")) {
                                    if (offlinePlayer == null) {
                                        if (placeholderReplacer.isOnline()) {
                                            string5 = "";
                                        } else if (!placeholderReplacer.isRequiresPlayer()) {
                                            string5 = String.valueOf(placeholderReplacer.getResult(string4, offlinePlayer));
                                        }
                                    } else {
                                        string5 = offlinePlayer.isOnline() ? String.valueOf(placeholderReplacer.getResult(string4, offlinePlayer.getPlayer())) : String.valueOf(placeholderReplacer.getResult(string4, offlinePlayer));
                                    }
                                }
                            }
                            catch (Exception exception) {
                                if (Placeholder.isIgnoreProblems()) break block25;
                                f.e("Error in placeholder: " + string2);
                                f.b(exception);
                                placeholder.removePlaceholder(string3);
                            }
                        }
                        if (string5 == null) {
                            string5 = "";
                        }
                        treeMap.put("(?i)" + (Placeholder.getStartCharacter() + string4 + Placeholder.getEndCharacter()).replace("{", "\\{").replace("}", "\\}"), string5);
                        bl2 = true;
                        break;
                    }
                } else if (bl3 && !string2.contains("*")) {
                    String string3;
                    Object object2 = "";
                    string3 = matcher.group(1);
                    try {
                        object = placeholder.getPlaceholderReplacer(string2);
                        if (object != null) {
                            if (offlinePlayer == null) {
                                if (((PlaceholderReplacer)object).isOnline()) {
                                    object2 = "";
                                } else if (!((PlaceholderReplacer)object).isRequiresPlayer()) {
                                    object2 = String.valueOf(((PlaceholderReplacer)object).getResult(string3, offlinePlayer));
                                }
                            } else {
                                object2 = offlinePlayer.isOnline() ? String.valueOf(((PlaceholderReplacer)object).getResult(string3, offlinePlayer.getPlayer())) : String.valueOf(((PlaceholderReplacer)object).getResult(string3, offlinePlayer));
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        f.e("Error in placeholder: " + string2);
                        f.a(throwable);
                        placeholder.removePlaceholder(string2);
                    }
                    if (object2 == null) {
                        object2 = "";
                    }
                    treeMap.put("(?i)" + (Placeholder.getStartCharacter() + string3 + Placeholder.getEndCharacter()).replace("{", "\\{").replace("}", "\\}"), (String)object2);
                    bl2 = true;
                    continue block4;
                }
                if (!bl2) continue;
                continue block4;
            }
        }
        return treeMap;
    }

    public static TreeMap<String, String> getPlaceholders(TreeMap<String, String> treeMap, String string, OfflinePlayer offlinePlayer) {
        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
        treeMap2.putAll(treeMap);
        List<Placeholder> list = Placeholder.getEnabledPlaceholderGroups();
        Pattern pattern = Pattern.compile(new String(Placeholder.getStartCharacterEscaped() + "(.([^" + Placeholder.getStartCharacterEscaped() + Placeholder.getEndCharacterEscaped() + "]+|[^" + Placeholder.getStartCharacterEscaped() + Placeholder.getEndCharacterEscaped() + "])?)" + Placeholder.getEndCharacterEscaped()), 34);
        Matcher matcher = pattern.matcher(string);
        block4: while (matcher.find()) {
            String string2 = matcher.group(0).toLowerCase();
            boolean bl2 = false;
            for (Placeholder placeholder : list) {
                Object object;
                boolean bl3 = placeholder.getPlaceholder().contains(string2);
                if (placeholder.containsWildcards && !bl3) {
                    for (String string3 : placeholder.getPlaceholder()) {
                        if (treeMap.containsKey(string3)) continue;
                        object = string3;
                        if (((String)object).contains("*")) {
                            object = ((String)object).substring(0, ((String)object).indexOf(42));
                        }
                        if (!string2.startsWith(((String)object).toLowerCase())) continue;
                        String string4 = "";
                        String string5 = matcher.group(1);
                        try {
                            PlaceholderReplacer<?> placeholderReplacer = placeholder.getPlaceholderReplacer(string3);
                            if (placeholderReplacer != null && !string2.contains("*")) {
                                if (offlinePlayer == null) {
                                    if (placeholderReplacer.isOnline()) {
                                        string4 = "";
                                    } else if (!placeholderReplacer.isRequiresPlayer()) {
                                        string4 = String.valueOf(placeholderReplacer.getResult(string5, offlinePlayer));
                                    }
                                } else {
                                    string4 = offlinePlayer.isOnline() ? String.valueOf(placeholderReplacer.getResult(string5, offlinePlayer.getPlayer())) : String.valueOf(placeholderReplacer.getResult(string5, offlinePlayer));
                                }
                            }
                        }
                        catch (Exception exception) {
                            f.e("Error in placeholder: " + string2);
                            f.b(exception);
                            placeholder.removePlaceholder(string3);
                        }
                        if (string4 == null) {
                            string4 = "";
                        }
                        treeMap2.put("(?i)" + (Placeholder.getStartCharacter() + string5 + Placeholder.getEndCharacter()).replace("{", "\\{").replace("}", "\\}"), string4);
                        bl2 = true;
                        break;
                    }
                } else if (bl3 && !string2.contains("*")) {
                    String string3;
                    Object object2 = "";
                    string3 = matcher.group(1);
                    try {
                        object = placeholder.getPlaceholderReplacer(string2);
                        if (object != null) {
                            if (offlinePlayer == null) {
                                if (((PlaceholderReplacer)object).isOnline()) {
                                    object2 = "";
                                } else if (!((PlaceholderReplacer)object).isRequiresPlayer()) {
                                    object2 = String.valueOf(((PlaceholderReplacer)object).getResult(string3, offlinePlayer));
                                }
                            } else {
                                object2 = offlinePlayer.isOnline() ? String.valueOf(((PlaceholderReplacer)object).getResult(string3, offlinePlayer.getPlayer())) : String.valueOf(((PlaceholderReplacer)object).getResult(string3, offlinePlayer));
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        f.e("Error in placeholder: " + string2);
                        f.b(throwable);
                        placeholder.removePlaceholder(string2);
                    }
                    if (object2 == null) {
                        object2 = "";
                    }
                    treeMap2.put("(?i)" + (Placeholder.getStartCharacter() + string3 + Placeholder.getEndCharacter()).replace("{", "\\{").replace("}", "\\}"), (String)object2);
                    bl2 = true;
                    continue block4;
                }
                if (!bl2) continue;
                continue block4;
            }
        }
        return treeMap2;
    }

    public PlaceholderReplacer<?> getPlaceholderReplacer(String string) {
        if (this.placeholders.containsKey(string.toLowerCase())) {
            return this.placeholders.get(string.toLowerCase());
        }
        return null;
    }

    public Set<String> getOfflinePlaceholder() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.getPlaceholder()) {
            if (!this.placeholders.containsKey(string.toLowerCase()) || this.placeholders.get(string.toLowerCase()).isOnline()) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public Set<String> getOnlinePlaceholder() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.getPlaceholder()) {
            if (!this.placeholders.containsKey(string.toLowerCase()) || !this.placeholders.get(string.toLowerCase()).isOnline()) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public Set<String> getPlaceholder() {
        return this.placeholders.keySet();
    }

    public Map<String, String> getPlaceholderDescriptions() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : this.placeholders.keySet()) {
            String string2 = this.placeholders.get(string).getDescription();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public Placeholder addCondition(a a2, String string) {
        this.placeholderConditions.put(a2, string);
        return this;
    }

    private void convertOnlineCalendarPlaceholders(String string, String string2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addPlaceholder(string.toLowerCase() + "_week", string2 + " week in year", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.getWeekYear();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_timeinmillis", string2 + " time in millis", new OnlinePlaceholderReplacer<Long>(Long.class){

            public Long a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0L;
                }
                return calendar.getTimeInMillis();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_firstdayofweek", string2 + " first day of the week", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.getFirstDayOfWeek();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_dayofmonth", string2 + " day of month", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(5);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_dayofweek", string2 + " day of week", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(7);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_dayofweekinmonth", string2 + " day of week in month", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(8);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_dayofyear", string2 + " day of year", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(6);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_hour", string2 + " hour (am/pm)", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(10);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_dayofmonth", string2 + " hour (24h)", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(11);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_era", string2 + " era", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(0);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_millisecond", string2 + " millisecond", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(14);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_minute", string2 + " minute", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(12);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_month", string2 + " month", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(2);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_second", string2 + " second", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(13);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_weekofmonth", string2 + " week of month", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(4);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_weekofyear", string2 + " week of year", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(3);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_year", string2 + " year", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(1);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_dstoffset", string2 + " DST Offset", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(16);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_zoneoffset", string2 + " zone offset", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, player);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(15);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
    }

    private void convertOfflineCalendarPlaceholders(String string, String string2, boolean bl2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addOfflinePlaceholder(string.toLowerCase() + "_week", string2 + " week in year", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.getWeekYear();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_timeinmillis", string2 + " time in millis", bl2, new PlaceholderReplacer<Long>(Long.class){

            public Long a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0L;
                }
                return calendar.getTimeInMillis();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_firstdayofweek", string2 + " first day of the week", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.getFirstDayOfWeek();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_dayofmonth", string2 + " day of month", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(5);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_dayofweek", string2 + " day of week", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(7);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_dayofweekinmonth", string2 + " day of week in month", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(8);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_dayofyear", string2 + " day of year", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(6);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_hour", string2 + " hour (am/pm)", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(10);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_dayofmonth", string2 + " hour (24h)", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(11);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_era", string2 + " era", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(0);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_millisecond", string2 + " millisecond", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(14);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_minute", string2 + " minute", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(12);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_month", string2 + " month", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(2);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_second", string2 + " second", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(13);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_weekofmonth", string2 + " week of month", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(4);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_weekofyear", string2 + " week of year", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(3);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_year", string2 + " year", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(1);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_dstoffset", string2 + " DST Offset", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(16);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_zoneoffset", string2 + " zone offset", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Calendar calendar = (Calendar)placeholderReplacer.getResult(string, offlinePlayer);
                if (calendar == null) {
                    return 0;
                }
                return calendar.get(15);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
    }

    private void convertOnlineLocationPlaceholders(String string, String string2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addPlaceholder(string.toLowerCase() + "_x", string2 + " X", new OnlinePlaceholderReplacer<Double>(Double.class){

            public Double a(String string, Player player) {
                Location location = (Location)placeholderReplacer.getResult(string, player);
                if (location == null) {
                    return 0.0;
                }
                return location.getX();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_y", string2 + " X", new OnlinePlaceholderReplacer<Double>(Double.class){

            public Double a(String string, Player player) {
                Location location = (Location)placeholderReplacer.getResult(string, player);
                if (location == null) {
                    return 0.0;
                }
                return location.getY();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_z", string2 + " X", new OnlinePlaceholderReplacer<Double>(Double.class){

            public Double a(String string, Player player) {
                Location location = (Location)placeholderReplacer.getResult(string, player);
                if (location == null) {
                    return 0.0;
                }
                return location.getZ();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_blockx", string2 + " X rounded", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Location location = (Location)placeholderReplacer.getResult(string, player);
                if (location == null) {
                    return 0;
                }
                return location.getBlockX();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_blocky", string2 + " Y rounded", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Location location = (Location)placeholderReplacer.getResult(string, player);
                if (location == null) {
                    return 0;
                }
                return location.getBlockY();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_blockz", string2 + " Z rounded", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Location location = (Location)placeholderReplacer.getResult(string, player);
                if (location == null) {
                    return 0;
                }
                return location.getBlockZ();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_world", string2, new OnlinePlaceholderReplacer<World>(World.class){

            public World a(String string, Player player) {
                Location location = (Location)placeholderReplacer.getResult(string, player);
                if (location == null) {
                    return null;
                }
                return location.getWorld();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_yaw", string2 + " yaw", new OnlinePlaceholderReplacer<Float>(Float.class){

            public Float a(String string, Player player) {
                Location location = (Location)placeholderReplacer.getResult(string, player);
                if (location == null) {
                    return Float.valueOf(0.0f);
                }
                return Float.valueOf(location.getYaw());
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_pitch", string2 + " pitch", new OnlinePlaceholderReplacer<Float>(Float.class){

            public Float a(String string, Player player) {
                Location location = (Location)placeholderReplacer.getResult(string, player);
                if (location == null) {
                    return Float.valueOf(0.0f);
                }
                return Float.valueOf(location.getPitch());
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_chunk_x", string2 + " chunk X", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Location location = (Location)placeholderReplacer.getResult(string, player);
                if (location == null) {
                    return 0;
                }
                return location.getChunk().getX();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_chunk_z", string2 + " chunk Z", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Location location = (Location)placeholderReplacer.getResult(string, player);
                if (location == null) {
                    return 0;
                }
                return location.getChunk().getZ();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_chunk_entities", string2 + " chunk amount of entities", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Location location = (Location)placeholderReplacer.getResult(string, player);
                if (location == null) {
                    return 0;
                }
                return location.getChunk().getEntities().length;
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_chunk_tileentities", string2 + " chunk amount of tile entities", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                Location location = (Location)placeholderReplacer.getResult(string, player);
                if (location == null) {
                    return 0;
                }
                return location.getChunk().getTileEntities().length;
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_chunk_isloaded", string2 + " chunk is loaded", new OnlinePlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, Player player) {
                Location location = (Location)placeholderReplacer.getResult(string, player);
                if (location == null) {
                    return false;
                }
                return location.getChunk().isLoaded();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
    }

    private void convertOnlineStringListPlaceholders(String string, String string2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addPlaceholder(string.toLowerCase() + "#*", string2 + " (example: {" + string.toLowerCase() + "#1} )", new OnlinePlaceholderReplacer<String>(String.class, new Object[]{string}){

            public String a(String string, Player player) {
                int n2 = Integer.parseInt(string.replace(this.getArguments()[0].toString() + "#", ""));
                String[] stringArray = (String[])placeholderReplacer.getResult(string, player);
                if (stringArray == null) {
                    return "";
                }
                if (stringArray.length < n2) {
                    return "";
                }
                return stringArray[n2 - 1];
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
    }

    private void convertOfflineStringListPlaceholders(String string, String string2, boolean bl2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addOfflinePlaceholder(string.toLowerCase() + "#*", string2 + " (example: {" + string.toLowerCase() + "#1} )", bl2, new PlaceholderReplacer<String>(String.class, new Object[]{string}){

            public String a(String string, OfflinePlayer offlinePlayer) {
                int n2 = Integer.parseInt(string.replace(this.getArguments()[0].toString() + "#", ""));
                String[] stringArray = (String[])placeholderReplacer.getResult(string, offlinePlayer);
                if (stringArray == null) {
                    return "";
                }
                if (stringArray.length < n2) {
                    return "";
                }
                return stringArray[n2 - 1];
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
    }

    private void convertOnlineIntegerListPlaceholders(String string, String string2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addPlaceholder(string.toLowerCase() + "#*", string2 + " (example: {" + string.toLowerCase() + "#1} )", new OnlinePlaceholderReplacer<Integer>(Integer.class, new Object[]{string}){

            public Integer a(String string, Player player) {
                int n2 = Integer.parseInt(string.replace(this.getArguments()[0].toString() + "#", ""));
                Integer[] integerArray = (Integer[])placeholderReplacer.getResult(string, player);
                if (integerArray == null) {
                    return 0;
                }
                if (integerArray.length < n2) {
                    return 0;
                }
                return integerArray[n2 - 1];
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
    }

    private void convertOfflineIntegerListPlaceholders(String string, String string2, boolean bl2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addOfflinePlaceholder(string.toLowerCase() + "#*", string2 + " (example: {" + string.toLowerCase() + "#1} )", bl2, new PlaceholderReplacer<Integer>(Integer.class, new Object[]{string}){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                int n2 = Integer.parseInt(string.replace(this.getArguments()[0].toString() + "#", ""));
                Integer[] integerArray = (Integer[])placeholderReplacer.getResult(string, offlinePlayer);
                if (integerArray == null) {
                    return 0;
                }
                if (integerArray.length < n2) {
                    return 0;
                }
                return integerArray[n2 - 1];
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
    }

    private void convertOnlineBooleanListPlaceholders(String string, String string2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addPlaceholder(string.toLowerCase() + "#*", string2 + " (example: {" + string.toLowerCase() + "#1} )", new OnlinePlaceholderReplacer<Boolean>(Boolean.class, new Object[]{string}){

            public Boolean a(String string, Player player) {
                int n2 = Integer.parseInt(string.replace(this.getArguments()[0].toString() + "#", ""));
                Boolean[] booleanArray = (Boolean[])placeholderReplacer.getResult(string, player);
                if (booleanArray == null) {
                    return false;
                }
                if (booleanArray.length < n2) {
                    return false;
                }
                return booleanArray[n2 - 1];
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        }.setDefaultFalseOutput(placeholderReplacer.getDefaultFalseOutput()).setDefaultTrueOutput(placeholderReplacer.getDefaultTrueOutput()));
    }

    private void convertOfflineBooleanListPlaceholders(String string, String string2, boolean bl2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addOfflinePlaceholder(string.toLowerCase() + "#*", string2 + " (example: {" + string.toLowerCase() + "#1} )", bl2, new PlaceholderReplacer<Boolean>(Boolean.class, new Object[]{string}){

            public Boolean a(String string, OfflinePlayer offlinePlayer) {
                int n2 = Integer.parseInt(string.replace(this.getArguments()[0].toString() + "#", ""));
                Boolean[] booleanArray = (Boolean[])placeholderReplacer.getResult(string, offlinePlayer);
                if (booleanArray == null) {
                    return false;
                }
                if (booleanArray.length < n2) {
                    return false;
                }
                return booleanArray[n2 - 1];
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        }.setDefaultFalseOutput(placeholderReplacer.getDefaultFalseOutput()).setDefaultTrueOutput(placeholderReplacer.getDefaultTrueOutput()));
    }

    private void convertOfflineItemPlaceholders(String string, String string2, boolean bl2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addOfflinePlaceholder(string.toLowerCase() + ":amount", string2 + " amount", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return 0;
                }
                return itemStack.getAmount();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":type", string2 + " type name", bl2, new PlaceholderReplacer<String>(String.class){

            public String a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return "";
                }
                return itemStack.getType().name();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":typeid", string2 + " type id", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return 0;
                }
                return itemStack.getTypeId();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":maxsize", string2 + " max size", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return 0;
                }
                return itemStack.getMaxStackSize();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":durability", string2 + " durability", bl2, new PlaceholderReplacer<Short>(Short.class){

            public Short a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return (short)0;
                }
                return itemStack.getDurability();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":maxdurability", string2 + " max durability", bl2, new PlaceholderReplacer<Short>(Short.class){

            public Short a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return (short)0;
                }
                return itemStack.getType().getMaxDurability();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "remainingdurability", string2 + " remainingdurability", bl2, new PlaceholderReplacer<Short>(Short.class){

            public Short a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return (short)0;
                }
                return (short)(itemStack.getType().getMaxDurability() - itemStack.getDurability());
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":maxstacksize", string2 + " max stack size", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return 0;
                }
                return itemStack.getType().getMaxStackSize();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":material", string2 + " material", bl2, new PlaceholderReplacer<String>(String.class){

            public String a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return "";
                }
                return itemStack.getType().name();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":isblock", string2 + " is block", bl2, new PlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isBlock();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":hasgravity", string2 + " has gravity", bl2, new PlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().hasGravity();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":isburnable", string2 + " is burnable", bl2, new PlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isBurnable();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":isedible", string2 + " is edible", bl2, new PlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isEdible();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":isflammable", string2 + " is flammable", bl2, new PlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isFlammable();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":isoccluding", string2 + " is occluding", bl2, new PlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isOccluding();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":isrecord", string2 + " is record", bl2, new PlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isRecord();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":issolid", string2 + " is solid", bl2, new PlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isSolid();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":istransparent", string2 + " is transparent", bl2, new PlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isTransparent();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":displayname", string2 + " display name", bl2, new PlaceholderReplacer<String>(String.class){

            public String a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return "";
                }
                if (itemStack.getItemMeta() == null) {
                    return "";
                }
                return itemStack.getItemMeta().getDisplayName();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + ":lore", string2 + " lore", bl2, new PlaceholderReplacer<String[]>(String[].class){

            public String[] a(String string, OfflinePlayer offlinePlayer) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, offlinePlayer);
                if (itemStack == null) {
                    return new String[0];
                }
                if (itemStack.getItemMeta() == null) {
                    return new String[0];
                }
                return g.a(itemStack.getItemMeta().getLore());
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
    }

    private void convertOfflineWorldPlaceholder(String string, String string2, boolean bl2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addOfflinePlaceholder(string, string2 + " world name", bl2, new PlaceholderReplacer<String>(String.class){

            public String a(String string, OfflinePlayer offlinePlayer) {
                World world = (World)placeholderReplacer.getResult(string, offlinePlayer);
                if (world == null) {
                    return "";
                }
                return world.getName();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string + "_name", string2 + " world name", bl2, new PlaceholderReplacer<String>(String.class){

            public String a(String string, OfflinePlayer offlinePlayer) {
                World world = (World)placeholderReplacer.getResult(string, offlinePlayer);
                if (world == null) {
                    return "";
                }
                return world.getName();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string + "_UID", string2 + " world unique ID", bl2, new PlaceholderReplacer<String>(String.class){

            public String a(String string, OfflinePlayer offlinePlayer) {
                World world = (World)placeholderReplacer.getResult(string, offlinePlayer);
                if (world == null) {
                    return "";
                }
                return world.getUID().toString();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string + "_players", string2 + " players in world", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                World world = (World)placeholderReplacer.getResult(string, offlinePlayer);
                if (world == null) {
                    return 0;
                }
                return world.getPlayers().size();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
    }

    private void convertOnlineWorldPlaceholder(String string, String string2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addPlaceholder(string, string2 + " world name", new OnlinePlaceholderReplacer<String>(String.class){

            public String a(String string, Player player) {
                World world = (World)placeholderReplacer.getResult(string, player);
                if (world == null) {
                    return "";
                }
                return world.getName();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string + "_name", string2 + " world name", new OnlinePlaceholderReplacer<String>(String.class){

            public String a(String string, Player player) {
                World world = (World)placeholderReplacer.getResult(string, player);
                if (world == null) {
                    return "";
                }
                return world.getName();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string + "_UID", string2 + " world unique ID", new OnlinePlaceholderReplacer<String>(String.class){

            public String a(String string, Player player) {
                World world = (World)placeholderReplacer.getResult(string, player);
                if (world == null) {
                    return "";
                }
                return world.getUID().toString();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string + "_players", string2 + " players in world", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                World world = (World)placeholderReplacer.getResult(string, player);
                if (world == null) {
                    return 0;
                }
                return world.getPlayers().size();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
    }

    private void convertOnlineItemPlaceholders(String string, String string2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addPlaceholder(string.toLowerCase() + ":amount", string2 + " amount", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return 0;
                }
                return itemStack.getAmount();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":type", string2 + " type name", new OnlinePlaceholderReplacer<String>(String.class){

            public String a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return "";
                }
                return itemStack.getType().name();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":typeid", string2 + " type id", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return 0;
                }
                return itemStack.getTypeId();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":maxsize", string2 + " max size", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return 0;
                }
                return itemStack.getMaxStackSize();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":durability", string2 + " durability", new OnlinePlaceholderReplacer<Short>(Short.class){

            public Short a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return (short)0;
                }
                return itemStack.getDurability();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":maxdurability", string2 + " max durability", new OnlinePlaceholderReplacer<Short>(Short.class){

            public Short a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return (short)0;
                }
                return itemStack.getType().getMaxDurability();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "remainingdurability", string2 + " remainingdurability", new OnlinePlaceholderReplacer<Short>(Short.class){

            public Short a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return (short)0;
                }
                return (short)(itemStack.getType().getMaxDurability() - itemStack.getDurability());
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":maxstacksize", string2 + " max stack size", new OnlinePlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return 0;
                }
                return itemStack.getType().getMaxStackSize();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":material", string2 + " material", new OnlinePlaceholderReplacer<String>(String.class){

            public String a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return "";
                }
                return itemStack.getType().name();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":isblock", string2 + " is block", new OnlinePlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isBlock();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":hasgravity", string2 + " has gravity", new OnlinePlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().hasGravity();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":isburnable", string2 + " is burnable", new OnlinePlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isBurnable();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":isedible", string2 + " is edible", new OnlinePlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isEdible();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":isflammable", string2 + " is flammable", new OnlinePlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isFlammable();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":isoccluding", string2 + " is occluding", new OnlinePlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isOccluding();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":isrecord", string2 + " is record", new OnlinePlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isRecord();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":issolid", string2 + " is solid", new OnlinePlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isSolid();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":istransparent", string2 + " is transparent", new OnlinePlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return false;
                }
                return itemStack.getType().isTransparent();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":displayname", string2 + " display name", new OnlinePlaceholderReplacer<String>(String.class){

            public String a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return "";
                }
                if (itemStack.getItemMeta() == null) {
                    return "";
                }
                return itemStack.getItemMeta().getDisplayName();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + ":lore", string2 + " lore", new OnlinePlaceholderReplacer<String[]>(String[].class){

            public String[] a(String string, Player player) {
                ItemStack itemStack = (ItemStack)placeholderReplacer.getResult(string, player);
                if (itemStack == null) {
                    return new String[0];
                }
                if (itemStack.getItemMeta() == null) {
                    return new String[0];
                }
                return g.a(itemStack.getItemMeta().getLore());
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
    }

    private void convertOfflineBooleanPlaceholders(final String string, String string2, boolean bl2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addOfflinePlaceholder(string.toLowerCase(), string2, bl2, new PlaceholderReplacer<String>(String.class){

            public String a(String string3, OfflinePlayer offlinePlayer) {
                Boolean bl2 = (Boolean)placeholderReplacer.getResult(string3, offlinePlayer);
                String string2 = bl2 != false ? Placeholder.this.getConfig().getString(string.replace("*", "").replace("@", "").replace("#", "") + ".true") : Placeholder.this.getConfig().getString(string.replace("*", "").replace("@", "").replace("#", "") + ".false");
                return string2;
            }

            @Override
            public /* synthetic */ Object getResult(String string2, OfflinePlayer offlinePlayer) {
                return this.a(string2, offlinePlayer);
            }
        }.setDefaultTrueOutput(placeholderReplacer.getDefaultTrueOutput()).setDefaultFalseOutput(placeholderReplacer.getDefaultFalseOutput()));
        this.addOfflinePlaceholder(string.toLowerCase() + "_raw", string2 + " [Raw frue/false]", bl2, new PlaceholderReplacer<String>(String.class){

            public String a(String string, OfflinePlayer offlinePlayer) {
                Boolean bl2 = (Boolean)placeholderReplacer.getResult(string, offlinePlayer);
                return String.valueOf(bl2);
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        }.setDefaultTrueOutput("true").setDefaultFalseOutput("false"));
    }

    private void convertOnlineBooleanPlaceholders(final String string, String string2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addPlaceholder(string.toLowerCase(), string2, new OnlinePlaceholderReplacer<String>(String.class){

            public String a(String string3, Player player) {
                Boolean bl2 = (Boolean)placeholderReplacer.getResult(string3, player);
                String string2 = bl2 != false ? Placeholder.this.getConfig().getString(string.replace("*", "").replace("@", "").replace("#", "") + ".true") : Placeholder.this.getConfig().getString(string.replace("*", "").replace("@", "").replace("#", "") + ".false");
                return string2;
            }

            @Override
            public /* synthetic */ Object getResult(String string2, Player player) {
                return this.a(string2, player);
            }
        }.setDefaultTrueOutput(placeholderReplacer.getDefaultTrueOutput()).setDefaultFalseOutput(placeholderReplacer.getDefaultFalseOutput()));
        this.addPlaceholder(string.toLowerCase(), string2 + " [Raw frue/false]", new OnlinePlaceholderReplacer<String>(String.class){

            public String a(String string, Player player) {
                Boolean bl2 = (Boolean)placeholderReplacer.getResult(string, player);
                return String.valueOf(bl2);
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        }.setDefaultTrueOutput("true").setDefaultFalseOutput("false"));
    }

    private void convertOnlineOfflinePlayerPlaceholders(String string, String string2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addPlaceholder(string.toLowerCase(), string2, new OnlinePlaceholderReplacer<String>(String.class){

            public String a(String string, Player player) {
                OfflinePlayer offlinePlayer = (OfflinePlayer)placeholderReplacer.getResult(string, player);
                if (offlinePlayer == null) {
                    return "";
                }
                return offlinePlayer.getName();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_name", " player name", new OnlinePlaceholderReplacer<String>(String.class){

            public String a(String string, Player player) {
                OfflinePlayer offlinePlayer = (OfflinePlayer)placeholderReplacer.getResult(string, player);
                if (offlinePlayer == null) {
                    return "";
                }
                return offlinePlayer.getName();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_uuid", " player UUID", new OnlinePlaceholderReplacer<String>(String.class){

            public String a(String string, Player player) {
                OfflinePlayer offlinePlayer = (OfflinePlayer)placeholderReplacer.getResult(string, player);
                if (offlinePlayer == null) {
                    return "";
                }
                return offlinePlayer.getUniqueId().toString();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
        this.addPlaceholder(string.toLowerCase() + "_isonline", " player is online", new OnlinePlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, Player player) {
                OfflinePlayer offlinePlayer = (OfflinePlayer)placeholderReplacer.getResult(string, player);
                if (offlinePlayer == null) {
                    return false;
                }
                return offlinePlayer.isOnline();
            }

            @Override
            public /* synthetic */ Object getResult(String string, Player player) {
                return this.a(string, player);
            }
        });
    }

    private void convertOfflineOfflinePlayerPlaceholders(String string, String string2, boolean bl2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addOfflinePlaceholder(string.toLowerCase(), string2, bl2, new PlaceholderReplacer<String>(String.class){

            public String a(String string, OfflinePlayer offlinePlayer) {
                OfflinePlayer offlinePlayer2 = (OfflinePlayer)placeholderReplacer.getResult(string, offlinePlayer);
                if (offlinePlayer2 == null) {
                    return "";
                }
                return offlinePlayer2.getName();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_name", " player name", bl2, new PlaceholderReplacer<String>(String.class){

            public String a(String string, OfflinePlayer offlinePlayer) {
                OfflinePlayer offlinePlayer2 = (OfflinePlayer)placeholderReplacer.getResult(string, offlinePlayer);
                if (offlinePlayer2 == null) {
                    return "";
                }
                return offlinePlayer2.getName();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_uuid", " player UUID", bl2, new PlaceholderReplacer<String>(String.class){

            public String a(String string, OfflinePlayer offlinePlayer) {
                OfflinePlayer offlinePlayer2 = (OfflinePlayer)placeholderReplacer.getResult(string, offlinePlayer);
                if (offlinePlayer2 == null) {
                    return "";
                }
                return offlinePlayer2.getUniqueId().toString();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_isonline", " player is online", bl2, new PlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, OfflinePlayer offlinePlayer) {
                OfflinePlayer offlinePlayer2 = (OfflinePlayer)placeholderReplacer.getResult(string, offlinePlayer);
                if (offlinePlayer2 == null) {
                    return false;
                }
                return offlinePlayer2.isOnline();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
    }

    private void convertOfflineLocationPlaceholders(String string, String string2, boolean bl2, final PlaceholderReplacer<?> placeholderReplacer) {
        this.addOfflinePlaceholder(string.toLowerCase() + "_x", string2 + " X", bl2, new PlaceholderReplacer<Double>(Double.class){

            public Double a(String string, OfflinePlayer offlinePlayer) {
                Location location = (Location)placeholderReplacer.getResult(string, offlinePlayer);
                if (location == null) {
                    return 0.0;
                }
                return location.getX();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_y", string2 + " X", bl2, new PlaceholderReplacer<Double>(Double.class){

            public Double a(String string, OfflinePlayer offlinePlayer) {
                Location location = (Location)placeholderReplacer.getResult(string, offlinePlayer);
                if (location == null) {
                    return 0.0;
                }
                return location.getY();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_z", string2 + " X", bl2, new PlaceholderReplacer<Double>(Double.class){

            public Double a(String string, OfflinePlayer offlinePlayer) {
                Location location = (Location)placeholderReplacer.getResult(string, offlinePlayer);
                if (location == null) {
                    return 0.0;
                }
                return location.getZ();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_blockx", string2 + " X rounded", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Location location = (Location)placeholderReplacer.getResult(string, offlinePlayer);
                if (location == null) {
                    return 0;
                }
                return location.getBlockX();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_blocky", string2 + " Y rounded", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Location location = (Location)placeholderReplacer.getResult(string, offlinePlayer);
                if (location == null) {
                    return 0;
                }
                return location.getBlockY();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_blockz", string2 + " Z rounded", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Location location = (Location)placeholderReplacer.getResult(string, offlinePlayer);
                if (location == null) {
                    return 0;
                }
                return location.getBlockZ();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_world", string2, bl2, new PlaceholderReplacer<World>(World.class){

            public World a(String string, OfflinePlayer offlinePlayer) {
                Location location = (Location)placeholderReplacer.getResult(string, offlinePlayer);
                if (location == null) {
                    return null;
                }
                return location.getWorld();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_yaw", string2 + " yaw", bl2, new PlaceholderReplacer<Float>(Float.class){

            public Float a(String string, OfflinePlayer offlinePlayer) {
                Location location = (Location)placeholderReplacer.getResult(string, offlinePlayer);
                if (location == null) {
                    return Float.valueOf(0.0f);
                }
                return Float.valueOf(location.getYaw());
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_pitch", string2 + " pitch", bl2, new PlaceholderReplacer<Float>(Float.class){

            public Float a(String string, OfflinePlayer offlinePlayer) {
                Location location = (Location)placeholderReplacer.getResult(string, offlinePlayer);
                if (location == null) {
                    return Float.valueOf(0.0f);
                }
                return Float.valueOf(location.getPitch());
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_chunk_x", string2 + " chunk X", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Location location = (Location)placeholderReplacer.getResult(string, offlinePlayer);
                if (location == null) {
                    return 0;
                }
                return location.getChunk().getX();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_chunk_z", string2 + " chunk Z", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Location location = (Location)placeholderReplacer.getResult(string, offlinePlayer);
                if (location == null) {
                    return 0;
                }
                return location.getChunk().getZ();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_chunk_entities", string2 + " chunk amount of entities", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Location location = (Location)placeholderReplacer.getResult(string, offlinePlayer);
                if (location == null) {
                    return 0;
                }
                return location.getChunk().getEntities().length;
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_chunk_tileentities", string2 + " chunk amount of tile entities", bl2, new PlaceholderReplacer<Integer>(Integer.class){

            public Integer a(String string, OfflinePlayer offlinePlayer) {
                Location location = (Location)placeholderReplacer.getResult(string, offlinePlayer);
                if (location == null) {
                    return 0;
                }
                return location.getChunk().getTileEntities().length;
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
        this.addOfflinePlaceholder(string.toLowerCase() + "_chunk_isloaded", string2 + " chunk is loaded", bl2, new PlaceholderReplacer<Boolean>(Boolean.class){

            public Boolean a(String string, OfflinePlayer offlinePlayer) {
                Location location = (Location)placeholderReplacer.getResult(string, offlinePlayer);
                if (location == null) {
                    return false;
                }
                return location.getChunk().isLoaded();
            }

            @Override
            public /* synthetic */ Object getResult(String string, OfflinePlayer offlinePlayer) {
                return this.a(string, offlinePlayer);
            }
        });
    }

    public Placeholder addPlaceholder(String string, String string2, OnlinePlaceholderReplacer<?> onlinePlaceholderReplacer) {
        return this.addPlaceholder(string, string2, (PlaceholderReplacer<?>)onlinePlaceholderReplacer);
    }

    public Placeholder addPlaceholder(String string, String string2, PlaceholderReplacer<?> placeholderReplacer) {
        placeholderReplacer.setDescription(string2);
        placeholderReplacer.setOnline(true);
        placeholderReplacer.setRequiresPlayer(true);
        if (placeholderReplacer.getReturnType().equals(Location.class)) {
            this.convertOnlineLocationPlaceholders(string, string2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(OfflinePlayer.class)) {
            this.convertOnlineOfflinePlayerPlaceholders(string, string2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(ItemStack.class)) {
            this.convertOnlineItemPlaceholders(string, string2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(String[].class)) {
            this.convertOnlineStringListPlaceholders(string, string2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(Integer[].class)) {
            this.convertOnlineIntegerListPlaceholders(string, string2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(Boolean[].class)) {
            this.convertOnlineBooleanListPlaceholders(string, string2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(World.class)) {
            this.convertOnlineWorldPlaceholder(string, string2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(Calendar.class)) {
            this.convertOnlineCalendarPlaceholders(string, string2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(Boolean.class)) {
            this.convertOnlineBooleanPlaceholders(string, string2, placeholderReplacer);
            return this;
        }
        if (!string.startsWith(Placeholder.getStartCharacter())) {
            string = Placeholder.getStartCharacter() + string;
        }
        if (!string.endsWith(Placeholder.getEndCharacter())) {
            string = string + Placeholder.getEndCharacter();
        }
        this.placeholders.put(string.toLowerCase(), placeholderReplacer);
        if (string.contains("*")) {
            this.setContainsWildcards(true);
        }
        return this;
    }

    public Placeholder addOfflinePlaceholder(String string, String string2, boolean bl2, PlaceholderReplacer<?> placeholderReplacer) {
        placeholderReplacer.setDescription(string2);
        placeholderReplacer.setOnline(false);
        placeholderReplacer.setRequiresPlayer(bl2);
        if (placeholderReplacer.getReturnType().equals(Location.class)) {
            this.convertOfflineLocationPlaceholders(string, string2, bl2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(OfflinePlayer.class)) {
            this.convertOfflineOfflinePlayerPlaceholders(string, string2, bl2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(ItemStack.class)) {
            this.convertOfflineItemPlaceholders(string, string2, bl2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(String[].class)) {
            this.convertOfflineStringListPlaceholders(string, string2, bl2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(Integer[].class)) {
            this.convertOfflineIntegerListPlaceholders(string, string2, bl2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(Boolean[].class)) {
            this.convertOfflineBooleanListPlaceholders(string, string2, bl2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(World.class)) {
            this.convertOfflineWorldPlaceholder(string, string2, bl2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(Calendar.class)) {
            this.convertOfflineCalendarPlaceholders(string, string2, bl2, placeholderReplacer);
            return this;
        }
        if (placeholderReplacer.getReturnType().equals(Boolean.class)) {
            this.convertOfflineBooleanPlaceholders(string, string2, bl2, placeholderReplacer);
            return this;
        }
        if (!string.startsWith(Placeholder.getStartCharacter())) {
            string = Placeholder.getStartCharacter() + string;
        }
        if (!string.endsWith(Placeholder.getEndCharacter())) {
            string = string + Placeholder.getEndCharacter();
        }
        this.placeholders.put(string.toLowerCase(), placeholderReplacer);
        if (string.contains("*")) {
            this.setContainsWildcards(true);
        }
        return this;
    }

    public static void filterUsedPlaceholder(List<Placeholder> list) {
        ArrayList<Placeholder> arrayList = new ArrayList<Placeholder>();
        for (Placeholder placeholder : Placeholder.getEnabledPlaceholderGroups()) {
            if (list.contains(placeholder)) continue;
            arrayList.add(placeholder);
        }
        for (Placeholder placeholder : arrayList) {
            placeholderGroups.remove(placeholder);
        }
    }

    public static void registerPlaceHolder(Placeholder placeholder) {
        if (placeholder == null) {
            return;
        }
        try {
            Plugin plugin = null;
            f.a("Checking conditions for placeholder: " + placeholder.getName());
            for (a a2 : placeholder.getPlaceholderConditions().keySet()) {
                boolean bl2 = false;
                switch (39.a[a2.ordinal()]) {
                    case 1: {
                        if (c.a(placeholder.getPlaceholderConditions().get((Object)a2))) {
                            plugin = c.b(placeholder.getPlaceholderConditions().get((Object)a2));
                            placeholder.setEnabled(true);
                            bl2 = true;
                            f.a("\tCondition met: [PLUGIN - " + placeholder.getName() + "] " + placeholder.getPlaceholderConditions().get((Object)a2));
                            break;
                        }
                        if (plugin != null) break;
                        f.a("\tCondition not met: [PLUGIN - " + placeholder.getName() + "] " + placeholder.getPlaceholderConditions().get((Object)a2));
                        placeholder.setEnabled(false);
                        break;
                    }
                    case 2: {
                        if (plugin == null) {
                            placeholder.setEnabled(false);
                            break;
                        }
                        if (plugin.getDescription().getMain().contains(placeholder.getPlaceholderConditions().get((Object)a2))) {
                            placeholder.setEnabled(true);
                            bl2 = true;
                            f.a("\tCondition met: [MAIN - " + placeholder.getName() + "] " + placeholder.getPlaceholderConditions().get((Object)a2));
                            break;
                        }
                        placeholder.setEnabled(false);
                        f.a("\tCondition not met: [MAIN - " + placeholder.getName() + "] " + placeholder.getPlaceholderConditions().get((Object)a2));
                        break;
                    }
                    case 3: {
                        if (plugin == null) {
                            placeholder.setEnabled(false);
                            break;
                        }
                        if (plugin.getDescription().getVersion().startsWith(placeholder.getPlaceholderConditions().get((Object)a2))) {
                            placeholder.setEnabled(true);
                            bl2 = true;
                            f.a("\tCondition met: [VERSION - " + placeholder.getName() + "] " + placeholder.getPlaceholderConditions().get((Object)a2));
                            break;
                        }
                        placeholder.setEnabled(false);
                        f.a("\tCondition not met: [VERSION - " + placeholder.getName() + "] " + placeholder.getPlaceholderConditions().get((Object)a2));
                        break;
                    }
                    case 4: {
                        if (plugin == null) {
                            placeholder.setEnabled(false);
                            break;
                        }
                        if (new h(placeholder.getPlaceholderConditions().get((Object)a2)).a(new h(plugin.getDescription().getVersion())) >= 0) {
                            placeholder.setEnabled(true);
                            bl2 = true;
                            f.a("\tCondition met: [VERSION HIGHER - " + placeholder.getName() + "] " + placeholder.getPlaceholderConditions().get((Object)a2));
                            break;
                        }
                        placeholder.setEnabled(false);
                        f.a("\tCondition not met: [VERSION HIGHER - " + placeholder.getName() + "] " + placeholder.getPlaceholderConditions().get((Object)a2));
                        break;
                    }
                    case 5: {
                        if (plugin == null) {
                            placeholder.setEnabled(false);
                            break;
                        }
                        if (new h(placeholder.getPlaceholderConditions().get((Object)a2)).a(new h(plugin.getDescription().getVersion())) == -1) {
                            placeholder.setEnabled(true);
                            bl2 = true;
                            f.a("\tCondition met: [VERSION LOWER - " + placeholder.getName() + "] " + placeholder.getPlaceholderConditions().get((Object)a2));
                            break;
                        }
                        placeholder.setEnabled(false);
                        f.a("\tCondition not met: [VERSION LOWER - " + placeholder.getName() + "] " + placeholder.getPlaceholderConditions().get((Object)a2));
                        break;
                    }
                }
                if (bl2) continue;
                break;
            }
        }
        catch (Exception exception) {
            f.b(exception);
        }
        if (placeholder.isEnabled()) {
            placeholder.generateConfig();
            if (placeholder.getPlugin() != null) {
                placeholder.storage = placeholder.getPlugin().getClass().getResourceAsStream("/placeholder_" + placeholder.getName() + ".yml") == null ? new be.maximvdw.featherboardcore.n.f(placeholder.plugin, "placeholders", "placeholder_" + placeholder.getName(), placeholder.getVersion(), placeholder.getConfigBuilder()) : new be.maximvdw.featherboardcore.n.f(placeholder.plugin, "placeholders", "placeholder_" + placeholder.getName(), true, placeholder.getVersion());
                placeholder.storage.c();
                if (!placeholder.storage.a().getBoolean("enabled")) {
                    f.a("Forcefully disabled the placeholder group: " + placeholder.getName());
                    placeholder.setEnabled(false);
                } else {
                    f.a("Enabled and valid placeholder group: " + placeholder.getName());
                }
            }
            try {
                if (placeholder.isEnabled()) {
                    placeholder.initialize();
                }
            }
            catch (Exception exception) {
                f.c("An error occured while initializing placeholders code=" + placeholder.getName());
                f.c("The placeholders have been disabled for use.");
                exception.printStackTrace();
                placeholder.setEnabled(false);
            }
        }
        placeholderGroups.add(placeholder);
    }

    public void generateConfig() {
        if (this.getConfigBuilder() != null) {
            return;
        }
        this.configBuilder = new be.maximvdw.featherboardcore.n.c();
        this.getConfigBuilder().b("# --------------------------------------- ##");
        this.getConfigBuilder().b("# " + this.getDescription() + " Placeholders");
        if (!this.getPluginURL().equals("")) {
            this.getConfigBuilder().b("# " + this.getPluginURL());
        }
        this.getConfigBuilder().b("# About: This configuration allows you to");
        this.getConfigBuilder().b("#        configure what certain placeholders return.");
        this.getConfigBuilder().b("# --------------------------------------- ##");
        this.getConfigBuilder().b();
        this.getConfigBuilder().b(" DO NOT EDIT THE CONFIG VERSION");
        this.getConfigBuilder().a("config", this.getVersion());
        this.getConfigBuilder().b();
        this.getConfigBuilder().b(" Enable/Disable the placeholder group");
        this.getConfigBuilder().b(" Placeholder groups will not be loaded into the memory");
        this.getConfigBuilder().b(" when not used.");
        this.getConfigBuilder().a("enabled", true);
        this.getConfigBuilder().b();
        for (Map.Entry<String, PlaceholderReplacer<?>> entry : this.placeholders.entrySet()) {
            c.d d2;
            String string = entry.getKey().replace(Placeholder.getStartCharacter(), "").replace(Placeholder.getEndCharacter(), "").replace("*", "").replace("@", "").replace("#", "");
            PlaceholderReplacer<?> placeholderReplacer = entry.getValue();
            if (placeholderReplacer.getDefaultTrueOutput() != null) {
                this.getConfigBuilder().b(" Define what the boolean placeholder {" + string + "} returns");
                d2 = new c.d(string);
                if (placeholderReplacer.getDefaultOutput() != null) {
                    d2.b(" Default return value");
                    d2.a("default", placeholderReplacer.getDefaultOutput());
                }
                d2.b(" This will be shown when the placeholder is 'True'");
                d2.a("true", placeholderReplacer.getDefaultTrueOutput() == null ? "True" : placeholderReplacer.getDefaultTrueOutput());
                d2.b(" This will be shown when the placeholder is 'False'");
                d2.a("false", placeholderReplacer.getDefaultFalseOutput() == null ? "False" : placeholderReplacer.getDefaultFalseOutput());
                this.getConfigBuilder().b(d2);
                this.getConfigBuilder().b();
                continue;
            }
            if (placeholderReplacer.getDefaultOutput() == null) continue;
            this.getConfigBuilder().b(" Placeholder settings {" + string + "} returns");
            d2 = new c.d(string);
            d2.b(" Default return value");
            d2.a("default", placeholderReplacer.getDefaultOutput());
            this.getConfigBuilder().b(d2);
            this.getConfigBuilder().b();
        }
    }

    public abstract void initialize();

    public static int getPlaceHolderCount() {
        int n2 = 0;
        for (Placeholder placeholder : placeholderGroups) {
            n2 += placeholder.getPlaceholder().size();
        }
        return n2;
    }

    public boolean isOffline(String string) {
        return !this.getPlaceholderReplacer(string).isOnline();
    }

    public static int getPlaceHolderEnabledCount() {
        int n2 = 0;
        for (Placeholder placeholder : placeholderGroups) {
            if (!placeholder.isEnabled()) continue;
            n2 += placeholder.getPlaceholder().size();
        }
        return n2;
    }

    public static String getStartCharacter() {
        return startCharacter;
    }

    public static String getStartCharacterEscaped() {
        return startCharacter.replace("{", "\\{");
    }

    public static String getEndCharacterEscaped() {
        return endCharacter.replace("}", "\\}");
    }

    public static void setStartCharacter(String string) {
        startCharacter = string;
    }

    public static String getEndCharacter() {
        return endCharacter;
    }

    public static void setEndCharacter(String string) {
        endCharacter = string;
    }

    public String getName() {
        return this.name;
    }

    public static List<Placeholder> getEnabledPlaceholderGroups() {
        ArrayList<Placeholder> arrayList = new ArrayList<Placeholder>();
        for (Placeholder placeholder : placeholderGroups) {
            if (!placeholder.isEnabled()) continue;
            arrayList.add(placeholder);
        }
        return arrayList;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void removePlaceholder(String string) {
        this.placeholders.remove(string);
    }

    public Map<a, String> getPlaceholderConditions() {
        return this.placeholderConditions;
    }

    public void setPlaceholderConditions(TreeMap<a, String> treeMap) {
        this.placeholderConditions = treeMap;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl2) {
        this.enabled = bl2;
    }

    public static void generateBBCodeFile() {
        try {
            FileWriter fileWriter = new FileWriter(new File("placeholders.txt"), false);
            fileWriter.write("==========================================================\n");
            fileWriter.write("Placeholders list generated on " + new Date().toString() + "\n");
            fileWriter.write("Amount of placeholders: " + Placeholder.getPlaceHolderCount() + "\n");
            fileWriter.write("==========================================================\n");
            fileWriter.write("\n");
            fileWriter.write("\n");
            fileWriter.write("\n");
            for (Placeholder placeholder : placeholderGroups) {
                fileWriter.write("[h2]" + placeholder.getDescription() + "[/h2]\n");
                if (!placeholder.getPluginURL().equals("")) {
                    fileWriter.write(placeholder.getPluginURL());
                    fileWriter.write("\n");
                }
                fileWriter.write("\n");
                fileWriter.write("[B][U][SIZE=5]Placeholders[/SIZE][/U][/B]\n");
                for (String string : placeholder.getPlaceholder()) {
                    PlaceholderReplacer<?> placeholderReplacer = placeholder.getPlaceholderReplacer(string);
                    fileWriter.write("[B]" + string + "[/B]\n");
                    fileWriter.write("[I]" + placeholderReplacer.getDescription() + "[/I]\n");
                    String string2 = "";
                    string2 = placeholderReplacer.getReturnType().equals(String.class) ? "Text" : (placeholderReplacer.getReturnType().equals(Boolean.class) ? "True/False" : (placeholderReplacer.getReturnType().equals(Integer.class) || placeholderReplacer.getReturnType().equals(Short.class) || placeholderReplacer.getReturnType().equals(Double.class) || placeholderReplacer.getReturnType().equals(Float.class) || placeholderReplacer.getReturnType().equals(Long.class) || placeholderReplacer.getReturnType().equals(BigDecimal.class) ? "Number" : "Unknown"));
                    fileWriter.write("Returns: " + string2);
                    fileWriter.write("\n");
                    fileWriter.write("\n");
                }
                fileWriter.write("\n");
                fileWriter.write("\n");
                fileWriter.write("\n");
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isActionPlaceholder() {
        return this.actionPlaceholder;
    }

    public void setActionPlaceholder(boolean bl2) {
        this.actionPlaceholder = bl2;
    }

    public boolean hasWildcards() {
        return this.containsWildcards;
    }

    public void setContainsWildcards(boolean bl2) {
        this.containsWildcards = bl2;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public static List<b> getRefreshHandles() {
        return refreshHandles;
    }

    public static void setRefreshHandles(List<b> list) {
        refreshHandles = list;
    }

    public static void registerPlaceholderRefreshHandler(b b2) {
        refreshHandles.add(b2);
    }

    public String getPluginURL() {
        return this.pluginURL;
    }

    public void setPluginURL(String string) {
        this.pluginURL = string;
    }

    public be.maximvdw.featherboardcore.n.c getConfigBuilder() {
        return this.configBuilder;
    }

    public void setConfigBuilder(be.maximvdw.featherboardcore.n.c c2) {
        this.configBuilder = c2;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n2) {
        this.version = n2;
    }

    public static boolean isIgnoreProblems() {
        return ignoreProblems;
    }

    public static void setIgnoreProblems(boolean bl2) {
        ignoreProblems = bl2;
    }

    static class 39 {
        static final /* synthetic */ int[] a;

        static {
            a = new int[be.maximvdw.featherboardcore.placeholders.Placeholder$a.a().length];
            try {
                39.a[be.maximvdw.featherboardcore.placeholders.Placeholder$a.a.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                39.a[be.maximvdw.featherboardcore.placeholders.Placeholder$a.f.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                39.a[be.maximvdw.featherboardcore.placeholders.Placeholder$a.b.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                39.a[be.maximvdw.featherboardcore.placeholders.Placeholder$a.h.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                39.a[be.maximvdw.featherboardcore.placeholders.Placeholder$a.g.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static interface b {
        public void refreshPlaceholders();
    }

    static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        public static final /* enum */ a d = new a();
        public static final /* enum */ a e = new a();
        public static final /* enum */ a f = new a();
        public static final /* enum */ a g = new a();
        public static final /* enum */ a h = new a();
        private static final /* synthetic */ a[] i;

        public static a[] a() {
            return (a[])i.clone();
        }

        static {
            i = new a[]{a, b, c, d, e, f, g, h};
        }
    }
}

