/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.logging;

import be.maximvdw.featherboardcore.facebook.internal.logging.LoggerFactory;
import be.maximvdw.featherboardcore.facebook.internal.logging.StdOutLoggerFactory;

public abstract class Logger {
    private static final LoggerFactory LOGGER_FACTORY;
    private static final String LOGGER_FACTORY_IMPLEMENTATION = "be.maximvdw.featherboardcore.facebook.loggerFactory";

    private static LoggerFactory getLoggerFactoryIfAvailable(String string, String string2) {
        try {
            Class.forName(string);
            return (LoggerFactory)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        return null;
    }

    public static Logger getLogger(Class clazz) {
        return LOGGER_FACTORY.getLogger(clazz);
    }

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract void debug(String var1);

    public abstract void debug(String var1, String var2);

    public abstract void info(String var1);

    public abstract void info(String var1, String var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, String var2);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    static {
        LoggerFactory loggerFactory = null;
        String string = System.getProperty(LOGGER_FACTORY_IMPLEMENTATION);
        if (string != null) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable(string, string);
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable("org.slf4j.impl.StaticLoggerBinder", "be.maximvdw.featherboardcore.facebook.internal.logging.SLF4JLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable("org.apache.commons.logging.Log", "be.maximvdw.featherboardcore.facebook.internal.logging.CommonsLoggingLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable("org.apache.log4j.Logger", "be.maximvdw.featherboardcore.facebook.internal.logging.Log4JLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactoryIfAvailable("com.google.appengine.api.urlfetch.URLFetchService", "be.maximvdw.featherboardcore.facebook.internal.logging.JULLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = new StdOutLoggerFactory();
        }
        LOGGER_FACTORY = loggerFactory;
    }
}

