/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.Cover;
import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.IdNameEntity;
import be.maximvdw.featherboardcore.facebook.Picture;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.User;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.CoverJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.IdNameEntityJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.PictureJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UserJSONImpl
extends FacebookResponseImpl
implements User,
Serializable,
Comparable<User> {
    private static final long serialVersionUID = 4973575756610859126L;
    private String id;
    private String name;
    private String firstName;
    private String middleName;
    private String lastName;
    private String gender;
    private Locale locale;
    private List<IdNameEntity> languages;
    private URL link;
    private String username;
    private String thirdPartyId;
    private Boolean installed;
    private Double timezone;
    private Date updatedTime;
    private Boolean verified;
    private String bio;
    private String birthday;
    private Cover cover;
    private List<User.Education> education;
    private String email;
    private IdNameEntity hometown;
    private List<String> interestedIn;
    private IdNameEntity location;
    private String political;
    private List<IdNameEntity> favoriteAthletes;
    private List<IdNameEntity> favoriteTeams;
    private Picture picture;
    private String quotes;
    private String relationshipStatus;
    private String religion;
    private IdNameEntity significantOther;
    private User.VideoUploadLimits videoUploadLimits;
    private URL website;
    private List<User.Work> work;
    private User.AgeRange ageRange;

    UserJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
        }
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    UserJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            int n2;
            int n3;
            Object object;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
            this.firstName = z_F4JInternalParseUtil.getRawString("first_name", jSONObject);
            this.middleName = z_F4JInternalParseUtil.getRawString("middle_name", jSONObject);
            this.lastName = z_F4JInternalParseUtil.getRawString("last_name", jSONObject);
            this.gender = z_F4JInternalParseUtil.getRawString("gender", jSONObject);
            if (!jSONObject.isNull("locale")) {
                object = z_F4JInternalParseUtil.getRawString("locale", jSONObject).split("_");
                String string = object[0];
                Object object2 = object[1];
                this.locale = new Locale(string, (String)object2);
            }
            if (!jSONObject.isNull("languages")) {
                object = jSONObject.getJSONArray("languages");
                int n4 = ((JSONArray)object).length();
                this.languages = new ArrayList<IdNameEntity>(n4);
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.languages.add(new IdNameEntityJSONImpl(((JSONArray)object).getJSONObject(i2)));
                }
            } else {
                this.languages = Collections.emptyList();
            }
            this.link = z_F4JInternalParseUtil.getURL("link", jSONObject);
            this.username = z_F4JInternalParseUtil.getRawString("username", jSONObject);
            this.thirdPartyId = z_F4JInternalParseUtil.getRawString("third_party_id", jSONObject);
            this.installed = z_F4JInternalParseUtil.getBoolean("installed", jSONObject);
            long l2 = System.currentTimeMillis();
            this.timezone = z_F4JInternalParseUtil.getTimeZoneOffset("timezone", jSONObject, l2);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", jSONObject);
            this.verified = z_F4JInternalParseUtil.getBoolean("verified", jSONObject);
            this.bio = z_F4JInternalParseUtil.getRawString("bio", jSONObject);
            this.birthday = z_F4JInternalParseUtil.getRawString("birthday", jSONObject);
            if (!jSONObject.isNull("cover")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("cover");
                this.cover = new CoverJSONImpl(jSONObject2);
            }
            if (!jSONObject.isNull("education")) {
                JSONArray jSONArray = jSONObject.getJSONArray("education");
                n3 = jSONArray.length();
                this.education = new ArrayList<User.Education>(n3);
                for (n2 = 0; n2 < n3; ++n2) {
                    this.education.add(new EducationJSONImpl(jSONArray.getJSONObject(n2)));
                }
            } else {
                this.education = Collections.emptyList();
            }
            this.email = z_F4JInternalParseUtil.getRawString("email", jSONObject);
            if (!jSONObject.isNull("hometown")) {
                String string = z_F4JInternalParseUtil.getRawString("hometown", jSONObject);
                if (string.startsWith("{")) {
                    JSONObject jSONObject3 = jSONObject.getJSONObject("hometown");
                    this.hometown = new IdNameEntityJSONImpl(jSONObject3);
                } else {
                    this.hometown = new IdNameEntityJSONImpl(string);
                }
            }
            if (!jSONObject.isNull("interestedIn")) {
                JSONArray jSONArray = jSONObject.getJSONArray("interested_in");
                n3 = jSONArray.length();
                this.interestedIn = new ArrayList<String>(n3);
                for (n2 = 0; n2 < n3; ++n2) {
                    this.interestedIn.add(jSONArray.getString(n2));
                }
            } else {
                this.interestedIn = Collections.emptyList();
            }
            if (!jSONObject.isNull("location")) {
                JSONObject jSONObject4 = jSONObject.getJSONObject("location");
                this.location = new IdNameEntityJSONImpl(jSONObject4);
            }
            this.political = z_F4JInternalParseUtil.getRawString("political", jSONObject);
            if (!jSONObject.isNull("favorite_athletes")) {
                JSONArray jSONArray = jSONObject.getJSONArray("favorite_athletes");
                n3 = jSONArray.length();
                this.favoriteAthletes = new ArrayList<IdNameEntity>(n3);
                for (n2 = 0; n2 < jSONArray.length(); ++n2) {
                    this.favoriteAthletes.add(new IdNameEntityJSONImpl(jSONArray.getJSONObject(n2)));
                }
            } else {
                this.favoriteAthletes = Collections.emptyList();
            }
            if (!jSONObject.isNull("favorite_teams")) {
                JSONArray jSONArray = jSONObject.getJSONArray("favorite_teams");
                n3 = jSONArray.length();
                this.favoriteTeams = new ArrayList<IdNameEntity>(n3);
                for (n2 = 0; n2 < n3; ++n2) {
                    this.favoriteTeams.add(new IdNameEntityJSONImpl(jSONArray.getJSONObject(n2)));
                }
            } else {
                this.favoriteTeams = Collections.emptyList();
            }
            if (!jSONObject.isNull("picture")) {
                String string = z_F4JInternalParseUtil.getRawString("picture", jSONObject);
                if (string.startsWith("{")) {
                    JSONObject jSONObject5 = jSONObject.getJSONObject("picture");
                    this.picture = new PictureJSONImpl(jSONObject5);
                } else {
                    this.picture = new PictureJSONImpl(z_F4JInternalParseUtil.getURL("picture", jSONObject));
                }
            }
            this.quotes = z_F4JInternalParseUtil.getRawString("quotes", jSONObject);
            this.relationshipStatus = z_F4JInternalParseUtil.getRawString("relationship_status", jSONObject);
            this.religion = z_F4JInternalParseUtil.getRawString("religion", jSONObject);
            if (!jSONObject.isNull("significant_other")) {
                JSONObject jSONObject6 = jSONObject.getJSONObject("significant_other");
                this.significantOther = new IdNameEntityJSONImpl(jSONObject6);
            }
            if (!jSONObject.isNull("video_upload_limits")) {
                JSONObject jSONObject7 = jSONObject.getJSONObject("video_upload_limits");
                this.videoUploadLimits = new VideoUploadLimitsJSONImpl(jSONObject7);
            }
            this.website = z_F4JInternalParseUtil.getURL("website", jSONObject);
            if (!jSONObject.isNull("work")) {
                JSONArray jSONArray = jSONObject.getJSONArray("work");
                int n5 = jSONArray.length();
                this.work = new ArrayList<User.Work>(n5);
                for (n2 = 0; n2 < n5; ++n2) {
                    this.work.add(new WorkJSONImpl(jSONArray.getJSONObject(n2)));
                }
            } else {
                this.work = Collections.emptyList();
            }
            if (!jSONObject.isNull("age_range")) {
                JSONObject jSONObject8 = jSONObject.getJSONObject("age_range");
                this.ageRange = new AgeRangeJSONImpl(jSONObject8);
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getMiddleName() {
        return this.middleName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public List<IdNameEntity> getLanguages() {
        return this.languages;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getThirdPartyId() {
        return this.thirdPartyId;
    }

    @Override
    public Boolean isInstalled() {
        return this.installed;
    }

    @Override
    public Double getTimezone() {
        return this.timezone;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public Boolean isVerified() {
        return this.verified;
    }

    @Override
    public String getBio() {
        return this.bio;
    }

    @Override
    public String getBirthday() {
        return this.birthday;
    }

    @Override
    public Cover getCover() {
        return this.cover;
    }

    @Override
    public List<User.Education> getEducation() {
        return this.education;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public IdNameEntity getHometown() {
        return this.hometown;
    }

    @Override
    public List<String> getInterestedIn() {
        return this.interestedIn;
    }

    @Override
    public IdNameEntity getLocation() {
        return this.location;
    }

    @Override
    public String getPolitical() {
        return this.political;
    }

    @Override
    public List<IdNameEntity> getFavoriteAthletes() {
        return this.favoriteAthletes;
    }

    @Override
    public List<IdNameEntity> getFavoriteTeams() {
        return this.favoriteTeams;
    }

    @Override
    public Picture getPicture() {
        return this.picture;
    }

    @Override
    public String getQuotes() {
        return this.quotes;
    }

    @Override
    public String getRelationshipStatus() {
        return this.relationshipStatus;
    }

    @Override
    public String getReligion() {
        return this.religion;
    }

    @Override
    public IdNameEntity getSignificantOther() {
        return this.significantOther;
    }

    @Override
    public User.VideoUploadLimits getVideoUploadLimits() {
        return this.videoUploadLimits;
    }

    @Override
    public URL getWebsite() {
        return this.website;
    }

    @Override
    public List<User.Work> getWork() {
        return this.work;
    }

    @Override
    public User.AgeRange getAgeRange() {
        return this.ageRange;
    }

    static ResponseList<User> createUserList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<User> responseListImpl = new ResponseListImpl<User>(n2, jSONObject, new User[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                UserJSONImpl userJSONImpl = new UserJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(userJSONImpl, jSONObject2);
                }
                responseListImpl.add(userJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    static List<User> createUserArray(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            ArrayList<User> arrayList = new ArrayList<User>();
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                UserJSONImpl userJSONImpl = new UserJSONImpl((JSONObject)jSONObject.get(string));
                arrayList.add(userJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(arrayList, jSONObject);
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    @Override
    public int compareTo(User user) {
        return this.id.compareTo(user.getId());
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return object instanceof User && ((User)object).getId().equals(this.id);
    }

    public String toString() {
        return "UserJSONImpl [id=" + this.id + ", name=" + this.name + ", firstName=" + this.firstName + ", middleName=" + this.middleName + ", lastName=" + this.lastName + ", gender=" + this.gender + ", locale=" + this.locale + ", languages=" + this.languages + ", link=" + this.link + ", username=" + this.username + ", thirdPartyId=" + this.thirdPartyId + ", timezone=" + this.timezone + ", updatedTime=" + this.updatedTime + ", verified=" + this.verified + ", bio=" + this.bio + ", birthday=" + this.birthday + ", cover=" + this.cover + ", education=" + this.education + ", email=" + this.email + ", hometown=" + this.hometown + ", interestedIn=" + this.interestedIn + ", location=" + this.location + ", political=" + this.political + ", favoriteAthletes=" + this.favoriteAthletes + ", favoriteTeams=" + this.favoriteTeams + ", picture=" + this.picture + ", quotes=" + this.quotes + ", relationshipStatus=" + this.relationshipStatus + ", religion=" + this.religion + ", significantOther=" + this.significantOther + ", videoUploadLimits=" + this.videoUploadLimits + ", website=" + this.website + ", work=" + this.work + ", ageRange=" + this.ageRange + "]";
    }

    private final class AgeRangeJSONImpl
    implements User.AgeRange,
    Serializable {
        private static final long serialVersionUID = -4890967721976343047L;
        private final Integer min;
        private final Integer max;

        AgeRangeJSONImpl(JSONObject jSONObject) {
            this.min = z_F4JInternalParseUtil.getInt("min", jSONObject);
            this.max = z_F4JInternalParseUtil.getInt("max", jSONObject);
        }

        public Integer getMin() {
            return this.min;
        }

        public Integer getMax() {
            return this.max;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AgeRangeJSONImpl)) {
                return false;
            }
            AgeRangeJSONImpl ageRangeJSONImpl = (AgeRangeJSONImpl)object;
            if (this.max != null ? !this.max.equals(ageRangeJSONImpl.max) : ageRangeJSONImpl.max != null) {
                return false;
            }
            return !(this.min != null ? !this.min.equals(ageRangeJSONImpl.min) : ageRangeJSONImpl.min != null);
        }

        public int hashCode() {
            int n2 = this.min != null ? this.min.hashCode() : 0;
            n2 = 31 * n2 + (this.max != null ? this.max.hashCode() : 0);
            return n2;
        }

        public String toString() {
            return "AgeRangeJSONImpl{min=" + this.min + ", max=" + this.max + '}';
        }
    }

    private class WorkJSONImpl
    implements User.Work,
    Serializable {
        private static final long serialVersionUID = 6240342669173650031L;
        private IdNameEntity employer;
        private IdNameEntity location;
        private IdNameEntity position;
        private String startDate;
        private String endDate;

        WorkJSONImpl(JSONObject jSONObject) {
            try {
                JSONObject jSONObject2;
                if (!jSONObject.isNull("employer")) {
                    jSONObject2 = jSONObject.getJSONObject("employer");
                    this.employer = new IdNameEntityJSONImpl(jSONObject2);
                }
                if (!jSONObject.isNull("location")) {
                    jSONObject2 = jSONObject.getJSONObject("location");
                    this.location = new IdNameEntityJSONImpl(jSONObject2);
                }
                if (!jSONObject.isNull("position")) {
                    jSONObject2 = jSONObject.getJSONObject("position");
                    this.position = new IdNameEntityJSONImpl(jSONObject2);
                }
                this.startDate = z_F4JInternalParseUtil.getRawString("start_date", jSONObject);
                this.endDate = z_F4JInternalParseUtil.getRawString("end_date", jSONObject);
            }
            catch (JSONException jSONException) {
                throw new FacebookException(jSONException);
            }
        }

        public IdNameEntity getEmployer() {
            return this.employer;
        }

        public IdNameEntity getLocation() {
            return this.location;
        }

        public IdNameEntity getPosition() {
            return this.position;
        }

        public String getStartDate() {
            return this.startDate;
        }

        public String getEndDate() {
            return this.endDate;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.employer == null ? 0 : this.employer.hashCode());
            n3 = 31 * n3 + (this.endDate == null ? 0 : this.endDate.hashCode());
            n3 = 31 * n3 + (this.location == null ? 0 : this.location.hashCode());
            n3 = 31 * n3 + (this.position == null ? 0 : this.position.hashCode());
            n3 = 31 * n3 + (this.startDate == null ? 0 : this.startDate.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WorkJSONImpl workJSONImpl = (WorkJSONImpl)object;
            if (this.employer == null ? workJSONImpl.employer != null : !this.employer.equals(workJSONImpl.employer)) {
                return false;
            }
            if (this.endDate == null ? workJSONImpl.endDate != null : !this.endDate.equals(workJSONImpl.endDate)) {
                return false;
            }
            if (this.location == null ? workJSONImpl.location != null : !this.location.equals(workJSONImpl.location)) {
                return false;
            }
            if (this.position == null ? workJSONImpl.position != null : !this.position.equals(workJSONImpl.position)) {
                return false;
            }
            return !(this.startDate == null ? workJSONImpl.startDate != null : !this.startDate.equals(workJSONImpl.startDate));
        }

        public String toString() {
            return "WorkJSONImpl [employer=" + this.employer + ", location=" + this.location + ", position=" + this.position + ", startDate=" + this.startDate + ", endDate=" + this.endDate + "]";
        }
    }

    private final class VideoUploadLimitsJSONImpl
    implements User.VideoUploadLimits,
    Serializable {
        private static final long serialVersionUID = -4890967721976343047L;
        private final long length;
        private final long size;

        VideoUploadLimitsJSONImpl(JSONObject jSONObject) {
            this.length = z_F4JInternalParseUtil.getLong("length", jSONObject);
            this.size = z_F4JInternalParseUtil.getLong("size", jSONObject);
        }

        public long getLength() {
            return this.length;
        }

        public long getSize() {
            return this.size;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (int)(this.length ^ this.length >>> 32);
            n3 = 31 * n3 + (int)(this.size ^ this.size >>> 32);
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            VideoUploadLimitsJSONImpl videoUploadLimitsJSONImpl = (VideoUploadLimitsJSONImpl)object;
            if (this.length != videoUploadLimitsJSONImpl.length) {
                return false;
            }
            return this.size == videoUploadLimitsJSONImpl.size;
        }

        public String toString() {
            return "VideoUploadLimitsJSONImpl [length=" + this.length + ", size=" + this.size + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EducationClassJSONImpl
    implements User.EducationClass,
    Serializable {
        private static final long serialVersionUID = -3203070872491695934L;
        private List<IdNameEntity> with;
        private String description;

        EducationClassJSONImpl(JSONObject jSONObject) {
            try {
                if (!jSONObject.isNull("with")) {
                    JSONArray jSONArray = jSONObject.getJSONArray("with");
                    this.with = new ArrayList<IdNameEntity>();
                    for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                        this.with.add(new IdNameEntityJSONImpl(jSONArray.getJSONObject(i2)));
                    }
                } else {
                    this.with = Collections.emptyList();
                }
                this.description = z_F4JInternalParseUtil.getRawString("description", jSONObject);
            }
            catch (JSONException jSONException) {
                throw new FacebookException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
            }
        }

        @Override
        public List<IdNameEntity> getWith() {
            return this.with;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + this.getOuterType().hashCode();
            n3 = 31 * n3 + (this.description == null ? 0 : this.description.hashCode());
            n3 = 31 * n3 + (this.with == null ? 0 : ((Object)this.with).hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            EducationClassJSONImpl educationClassJSONImpl = (EducationClassJSONImpl)object;
            if (!this.getOuterType().equals(educationClassJSONImpl.getOuterType())) {
                return false;
            }
            if (this.description == null ? educationClassJSONImpl.description != null : !this.description.equals(educationClassJSONImpl.description)) {
                return false;
            }
            return !(this.with == null ? educationClassJSONImpl.with != null : !((Object)this.with).equals(educationClassJSONImpl.with));
        }

        public String toString() {
            return "EducationClassJSONImpl [with=" + this.with + ", description=" + this.description + "]";
        }

        private UserJSONImpl getOuterType() {
            return UserJSONImpl.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EducationJSONImpl
    implements User.Education,
    Serializable {
        private static final long serialVersionUID = -9136754110094129780L;
        private IdNameEntity year;
        private String type;
        private IdNameEntity school;
        private IdNameEntity degree;
        private List<IdNameEntity> concentration;
        private List<User.EducationClass> classes;
        private List<IdNameEntity> with;

        EducationJSONImpl(JSONObject jSONObject) {
            try {
                int n2;
                Object object;
                if (!jSONObject.isNull("year")) {
                    object = jSONObject.getJSONObject("year");
                    this.year = new IdNameEntityJSONImpl((JSONObject)object);
                }
                this.type = z_F4JInternalParseUtil.getRawString("type", jSONObject);
                if (!jSONObject.isNull("school")) {
                    object = jSONObject.getJSONObject("school");
                    this.school = new IdNameEntityJSONImpl((JSONObject)object);
                }
                if (!jSONObject.isNull("degree")) {
                    object = jSONObject.getJSONObject("degree");
                    this.degree = new IdNameEntityJSONImpl((JSONObject)object);
                }
                if (!jSONObject.isNull("concentration")) {
                    object = jSONObject.getJSONArray("concentration");
                    this.concentration = new ArrayList<IdNameEntity>();
                    for (n2 = 0; n2 < ((JSONArray)object).length(); ++n2) {
                        this.concentration.add(new IdNameEntityJSONImpl(((JSONArray)object).getJSONObject(n2)));
                    }
                } else {
                    this.concentration = Collections.emptyList();
                }
                if (!jSONObject.isNull("classes")) {
                    object = jSONObject.getJSONArray("classes");
                    this.classes = new ArrayList<User.EducationClass>();
                    for (n2 = 0; n2 < ((JSONArray)object).length(); ++n2) {
                        this.classes.add(new EducationClassJSONImpl(((JSONArray)object).getJSONObject(n2)));
                    }
                } else {
                    this.classes = Collections.emptyList();
                }
                if (!jSONObject.isNull("with")) {
                    object = jSONObject.getJSONArray("with");
                    this.with = new ArrayList<IdNameEntity>();
                    for (n2 = 0; n2 < ((JSONArray)object).length(); ++n2) {
                        this.with.add(new IdNameEntityJSONImpl(((JSONArray)object).getJSONObject(n2)));
                    }
                } else {
                    this.with = Collections.emptyList();
                }
            }
            catch (JSONException jSONException) {
                throw new FacebookException(jSONException);
            }
        }

        @Override
        public IdNameEntity getYear() {
            return this.year;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public IdNameEntity getSchool() {
            return this.school;
        }

        @Override
        public IdNameEntity getDegree() {
            return this.degree;
        }

        @Override
        public List<IdNameEntity> getConcentration() {
            return this.concentration;
        }

        @Override
        public List<User.EducationClass> getClasses() {
            return this.classes;
        }

        @Override
        public List<IdNameEntity> getWith() {
            return this.with;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.classes == null ? 0 : ((Object)this.classes).hashCode());
            n3 = 31 * n3 + (this.concentration == null ? 0 : ((Object)this.concentration).hashCode());
            n3 = 31 * n3 + (this.degree == null ? 0 : this.degree.hashCode());
            n3 = 31 * n3 + (this.school == null ? 0 : this.school.hashCode());
            n3 = 31 * n3 + (this.type == null ? 0 : this.type.hashCode());
            n3 = 31 * n3 + (this.with == null ? 0 : ((Object)this.with).hashCode());
            n3 = 31 * n3 + (this.year == null ? 0 : this.year.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            EducationJSONImpl educationJSONImpl = (EducationJSONImpl)object;
            if (this.classes == null ? educationJSONImpl.classes != null : !((Object)this.classes).equals(educationJSONImpl.classes)) {
                return false;
            }
            if (this.concentration == null ? educationJSONImpl.concentration != null : !((Object)this.concentration).equals(educationJSONImpl.concentration)) {
                return false;
            }
            if (this.degree == null ? educationJSONImpl.degree != null : !this.degree.equals(educationJSONImpl.degree)) {
                return false;
            }
            if (this.school == null ? educationJSONImpl.school != null : !this.school.equals(educationJSONImpl.school)) {
                return false;
            }
            if (this.type == null ? educationJSONImpl.type != null : !this.type.equals(educationJSONImpl.type)) {
                return false;
            }
            if (this.with == null ? educationJSONImpl.with != null : !((Object)this.with).equals(educationJSONImpl.with)) {
                return false;
            }
            return !(this.year == null ? educationJSONImpl.year != null : !this.year.equals(educationJSONImpl.year));
        }

        public String toString() {
            return "EducationJSONImpl [year=" + this.year + ", type=" + this.type + ", school=" + this.school + ", degree=" + this.degree + ", concentration=" + this.concentration + ", classes=" + this.classes + ", with=" + this.with + "]";
        }
    }
}

