/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.Tag;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TagJSONImpl
extends FacebookResponseImpl
implements Tag,
Serializable {
    private static final long serialVersionUID = -947248601368391860L;
    private String id;
    private String name;
    private Integer offset;
    private Integer length;
    private String type;
    private Double x;
    private Double y;
    private Date createdTime;

    TagJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    TagJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
        this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
        this.offset = !jSONObject.isNull("offset") ? Integer.valueOf(z_F4JInternalParseUtil.getPrimitiveInt("offset", jSONObject)) : null;
        this.length = !jSONObject.isNull("length") ? Integer.valueOf(z_F4JInternalParseUtil.getPrimitiveInt("length", jSONObject)) : null;
        this.type = z_F4JInternalParseUtil.getRawString("type", jSONObject);
        this.x = !jSONObject.isNull("x") ? z_F4JInternalParseUtil.getDouble("x", jSONObject) : null;
        this.y = !jSONObject.isNull("y") ? z_F4JInternalParseUtil.getDouble("y", jSONObject) : null;
        this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getOffset() {
        return this.offset;
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Double getX() {
        return this.x;
    }

    @Override
    public Double getY() {
        return this.y;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    static ResponseList<Tag> createTagList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Tag> responseListImpl = new ResponseListImpl<Tag>(n2, jSONObject, new Tag[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                TagJSONImpl tagJSONImpl = new TagJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(tagJSONImpl, jSONObject2);
                }
                responseListImpl.add(tagJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TagJSONImpl tagJSONImpl = (TagJSONImpl)object;
        return !(this.id == null ? tagJSONImpl.id != null : !this.id.equals(tagJSONImpl.id));
    }

    public String toString() {
        return "TagJSONImpl [id=" + this.id + ", name=" + this.name + ", offset=" + this.offset + ", length=" + this.length + ", type=" + this.type + "]";
    }
}

