/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.Application;
import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.IdNameEntity;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.Score;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.ApplicationJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.IdNameEntityJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ScoreJSONImpl
extends FacebookResponseImpl
implements Score,
Serializable {
    private static final long serialVersionUID = 4667076189606464769L;
    private IdNameEntity user;
    private Integer score;
    private Application application;
    private String type;

    ScoreJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    ScoreJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            this.user = new IdNameEntityJSONImpl(jSONObject.getJSONObject("user"));
            this.score = z_F4JInternalParseUtil.getPrimitiveInt("score", jSONObject);
            this.application = new ApplicationJSONImpl(jSONObject.getJSONObject("application"));
            this.type = z_F4JInternalParseUtil.getRawString("type", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public IdNameEntity getUser() {
        return this.user;
    }

    @Override
    public Integer getScore() {
        return this.score;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public String getType() {
        return this.type;
    }

    static ResponseList<Score> createScoreList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Score> responseListImpl = new ResponseListImpl<Score>(n2, jSONObject, new Score[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                ScoreJSONImpl scoreJSONImpl = new ScoreJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(scoreJSONImpl, jSONObject2);
                }
                responseListImpl.add(scoreJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.application == null ? 0 : this.application.hashCode());
        n3 = 31 * n3 + (this.score == null ? 0 : this.score.hashCode());
        n3 = 31 * n3 + (this.type == null ? 0 : this.type.hashCode());
        n3 = 31 * n3 + (this.user == null ? 0 : this.user.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ScoreJSONImpl scoreJSONImpl = (ScoreJSONImpl)object;
        if (this.application == null ? scoreJSONImpl.application != null : !this.application.equals(scoreJSONImpl.application)) {
            return false;
        }
        if (this.score == null ? scoreJSONImpl.score != null : !this.score.equals(scoreJSONImpl.score)) {
            return false;
        }
        if (this.type == null ? scoreJSONImpl.type != null : !this.type.equals(scoreJSONImpl.type)) {
            return false;
        }
        return !(this.user == null ? scoreJSONImpl.user != null : !this.user.equals(scoreJSONImpl.user));
    }

    public String toString() {
        return "ScoreJSONImpl [user=" + this.user + ", score=" + this.score + ", application=" + this.application + ", type=" + this.type + "]";
    }
}

