/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.PagableListImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResponseListImpl<T>
extends PagableListImpl<T>
implements ResponseList<T> {
    ResponseListImpl(JSONObject jSONObject, T ... TArray) {
        super(jSONObject, TArray);
        this.init(jSONObject);
    }

    ResponseListImpl(int n2, JSONObject jSONObject, T ... TArray) {
        super(n2, jSONObject, TArray);
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
    }

    static ResponseList<JSONObject> createJSONObjectList(HttpResponse httpResponse, Configuration configuration) {
        return ResponseListImpl.createJSONObjectList(httpResponse.asJSONObject(), configuration);
    }

    static ResponseList<JSONObject> createJSONObjectList(JSONObject jSONObject) {
        return ResponseListImpl.createJSONObjectList(jSONObject, null);
    }

    private static ResponseList<JSONObject> createJSONObjectList(JSONObject jSONObject, Configuration configuration) {
        try {
            if (null != configuration && configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<JSONObject> responseListImpl = new ResponseListImpl<JSONObject>(n2, jSONObject, new JSONObject[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                if (null != configuration && configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(jSONObject2, jSONObject2);
                }
                responseListImpl.add(jSONObject2);
            }
            if (null != configuration && configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }
}

