/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.Permission;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PermissionJSONImpl
implements Permission,
Serializable {
    private static final long serialVersionUID = -3507159691486381813L;
    private String name;
    private boolean isGranted;

    private PermissionJSONImpl(String string, boolean bl2) {
        this.name = string;
        this.isGranted = bl2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isGranted() {
        return this.isGranted;
    }

    static List<Permission> createPermissionArray(HttpResponse httpResponse, Configuration configuration) {
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
        }
        ArrayList<Permission> arrayList = new ArrayList<Permission>();
        JSONObject jSONObject = httpResponse.asJSONObject();
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                String string = jSONObject2.getString("permission");
                boolean bl2 = "granted".equalsIgnoreCase(jSONObject2.getString("status"));
                arrayList.add(new PermissionJSONImpl(string, bl2));
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(arrayList, jSONArray);
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.isGranted ? 1231 : 1237);
        n3 = 31 * n3 + (this.name == null ? 0 : this.name.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PermissionJSONImpl permissionJSONImpl = (PermissionJSONImpl)object;
        if (this.isGranted != permissionJSONImpl.isGranted) {
            return false;
        }
        return !(this.name == null ? permissionJSONImpl.name != null : !this.name.equals(permissionJSONImpl.name));
    }

    public String toString() {
        return "PermissionJSONImpl [name=" + this.name + ", isGranted=" + this.isGranted + "]";
    }
}

