/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.Paging;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PagingJSONImpl<T>
implements Paging<T>,
Serializable {
    private static final long serialVersionUID = 4741821984775700187L;
    private final Class<?> jsonObjectType;
    private final Paging.Cursors cursors;
    private final URL previous;
    private final URL next;

    PagingJSONImpl(JSONObject jSONObject, Class<?> clazz) {
        this.jsonObjectType = clazz;
        try {
            this.cursors = !jSONObject.isNull("cursors") ? new CursorsJSONImpl(jSONObject.getJSONObject("cursors")) : null;
            this.previous = z_F4JInternalParseUtil.getURL("previous", jSONObject);
            this.next = z_F4JInternalParseUtil.getURL("next", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    @Override
    public Class<?> getJSONObjectType() {
        return this.jsonObjectType;
    }

    @Override
    public URL getPrevious() {
        return this.previous;
    }

    @Override
    public URL getNext() {
        return this.next;
    }

    @Override
    public Paging.Cursors getCursors() {
        return this.cursors;
    }

    public String toString() {
        return "PagingJSONImpl [previous=" + this.previous + ", next=" + this.next + ", jsonObjectType=" + this.jsonObjectType + "]";
    }

    private final class CursorsJSONImpl
    implements Paging.Cursors,
    Serializable {
        private static final long serialVersionUID = -4827220838408801570L;
        private final String after;
        private final String before;

        CursorsJSONImpl(JSONObject jSONObject) {
            this.after = z_F4JInternalParseUtil.getRawString("after", jSONObject);
            this.before = z_F4JInternalParseUtil.getRawString("before", jSONObject);
        }

        public String getAfter() {
            return this.after;
        }

        public String getBefore() {
            return this.before;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CursorsJSONImpl)) {
                return false;
            }
            CursorsJSONImpl cursorsJSONImpl = (CursorsJSONImpl)object;
            if (this.after != null ? !this.after.equals(cursorsJSONImpl.after) : cursorsJSONImpl.after != null) {
                return false;
            }
            return !(this.before != null ? !this.before.equals(cursorsJSONImpl.before) : cursorsJSONImpl.before != null);
        }

        public int hashCode() {
            int n2 = this.after != null ? this.after.hashCode() : 0;
            n2 = 31 * n2 + (this.before != null ? this.before.hashCode() : 0);
            return n2;
        }

        public String toString() {
            return "CursorsJSONImpl{after='" + this.after + '\'' + ", before='" + this.before + '\'' + '}';
        }
    }
}

