/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.PageSetting;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageSettingJSONImpl
extends FacebookResponseImpl
implements PageSetting,
Serializable {
    private static final long serialVersionUID = -6960164932151941721L;
    private String setting;
    private Boolean value;

    PageSettingJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    PageSettingJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        this.setting = z_F4JInternalParseUtil.getRawString("setting", jSONObject);
        this.value = z_F4JInternalParseUtil.getBoolean("value", jSONObject);
    }

    @Override
    public String getSetting() {
        return this.setting;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    static ResponseList<PageSetting> createLikeList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<PageSetting> responseListImpl = new ResponseListImpl<PageSetting>(n2, jSONObject, new PageSetting[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                PageSettingJSONImpl pageSettingJSONImpl = new PageSettingJSONImpl(jSONArray.getJSONObject(i2));
                responseListImpl.add(pageSettingJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONObject);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PageSettingJSONImpl)) {
            return false;
        }
        PageSettingJSONImpl pageSettingJSONImpl = (PageSettingJSONImpl)object;
        if (this.setting != null ? !this.setting.equals(pageSettingJSONImpl.setting) : pageSettingJSONImpl.setting != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(pageSettingJSONImpl.value) : pageSettingJSONImpl.value != null);
    }

    public int hashCode() {
        int n2 = this.setting != null ? this.setting.hashCode() : 0;
        n2 = 31 * n2 + (this.value != null ? this.value.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "PageSettingJSONImpl{setting='" + this.setting + '\'' + ", value=" + this.value + '}';
    }
}

