/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.Comment;
import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.IdNameEntity;
import be.maximvdw.featherboardcore.facebook.InboxResponseList;
import be.maximvdw.featherboardcore.facebook.Message;
import be.maximvdw.featherboardcore.facebook.PagableList;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.CommentJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.IdNameEntityJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.InboxResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.PagableListImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MessageJSONImpl
extends FacebookResponseImpl
implements Message,
Serializable {
    private static final long serialVersionUID = -2666008917993827020L;
    private String id;
    private IdNameEntity from;
    private List<IdNameEntity> to;
    private String message;
    private Date createdTime;
    private Date updatedTime;
    private PagableList<Comment> comments;
    private Integer unread;
    private Integer unseen;

    MessageJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    MessageJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            int n2;
            JSONArray jSONArray;
            JSONObject jSONObject2;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("from")) {
                jSONObject2 = jSONObject.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(jSONObject2);
            }
            if (!jSONObject.isNull("to")) {
                jSONObject2 = jSONObject.getJSONObject("to");
                jSONArray = jSONObject2.getJSONArray("data");
                this.to = new ArrayList<IdNameEntity>();
                for (n2 = 0; n2 < jSONArray.length(); ++n2) {
                    this.to.add(new IdNameEntityJSONImpl(jSONArray.getJSONObject(n2)));
                }
            } else {
                this.to = Collections.emptyList();
            }
            this.message = z_F4JInternalParseUtil.getRawString("message", jSONObject);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", jSONObject);
            if (!jSONObject.isNull("comments")) {
                jSONObject2 = jSONObject.getJSONObject("comments");
                if (!jSONObject2.isNull("data")) {
                    jSONArray = jSONObject2.getJSONArray("data");
                    n2 = jSONArray.length();
                    this.comments = new PagableListImpl<Comment>(n2, jSONObject2, new Comment[0]);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        CommentJSONImpl commentJSONImpl = new CommentJSONImpl(jSONArray.getJSONObject(i2));
                        this.comments.add(commentJSONImpl);
                    }
                } else {
                    this.comments = new PagableListImpl<Comment>(1, jSONObject2, new Comment[0]);
                }
            } else {
                this.comments = new PagableListImpl<Comment>(0);
            }
            if (!jSONObject.isNull("unread")) {
                this.unread = z_F4JInternalParseUtil.getPrimitiveInt("unread", jSONObject);
            }
            if (!jSONObject.isNull("unseen")) {
                this.unseen = z_F4JInternalParseUtil.getPrimitiveInt("unseen", jSONObject);
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public List<IdNameEntity> getTo() {
        return this.to;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public Integer getUnread() {
        return this.unread;
    }

    @Override
    public Integer getUnseen() {
        return this.unseen;
    }

    static ResponseList<Message> createMessageList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Message> responseListImpl = new ResponseListImpl<Message>(n2, jSONObject, new Message[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                MessageJSONImpl messageJSONImpl = new MessageJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(messageJSONImpl, jSONObject2);
                }
                responseListImpl.add(messageJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    static InboxResponseList<Message> createInboxMessageList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            InboxResponseListImpl<Message> inboxResponseListImpl = new InboxResponseListImpl<Message>(n2, jSONObject, new Message[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                MessageJSONImpl messageJSONImpl = new MessageJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(messageJSONImpl, jSONObject2);
                }
                inboxResponseListImpl.add(messageJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(inboxResponseListImpl, jSONArray);
            }
            return inboxResponseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MessageJSONImpl messageJSONImpl = (MessageJSONImpl)object;
        return !(this.id == null ? messageJSONImpl.id != null : !this.id.equals(messageJSONImpl.id));
    }

    public String toString() {
        return "MessageJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", to=" + this.to + ", message='" + this.message + '\'' + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", comments=" + this.comments + ", unread=" + this.unread + ", unseen=" + this.unseen + '}';
    }
}

