/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.GroupMember;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.UserJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GroupMemberJSONImpl
extends UserJSONImpl
implements GroupMember,
Serializable {
    private static final long serialVersionUID = 8912198140971501463L;
    private Boolean isAdministrator;

    GroupMemberJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse, configuration);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    GroupMemberJSONImpl(JSONObject jSONObject) {
        super(jSONObject);
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        this.isAdministrator = z_F4JInternalParseUtil.getBoolean("administrator", jSONObject);
    }

    @Override
    public Boolean isAdministrator() {
        return this.isAdministrator;
    }

    static ResponseList<GroupMember> createGroupMemberList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<GroupMember> responseListImpl = new ResponseListImpl<GroupMember>(n2, jSONObject, new GroupMember[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                GroupMemberJSONImpl groupMemberJSONImpl = new GroupMemberJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(groupMemberJSONImpl, jSONObject2);
                }
                responseListImpl.add(groupMemberJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    @Override
    public String toString() {
        return "GroupMemberJSONImpl{isAdministrator=" + this.isAdministrator + '}' + " extends " + super.toString();
    }
}

