/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.Category;
import be.maximvdw.featherboardcore.facebook.Comment;
import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.Image;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.Tag;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.CategoryJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ImageJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.TagJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CommentJSONImpl
extends FacebookResponseImpl
implements Comment,
Serializable {
    private static final long serialVersionUID = -4004859844463425632L;
    private String id;
    private Category from;
    private String message;
    private List<Tag> messageTags;
    private Boolean canComment;
    private Boolean canRemove;
    private Boolean canHide;
    private Boolean canLike;
    private Date createdTime;
    private Integer likeCount;
    private Integer commentCount;
    private Boolean isUserLikes;
    private Comment.Attachment attachment;
    private Comment parent;

    CommentJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    CommentJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            Object object;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("from")) {
                object = jSONObject.getJSONObject("from");
                this.from = new CategoryJSONImpl((JSONObject)object);
            } else {
                this.from = null;
            }
            this.message = z_F4JInternalParseUtil.getRawString("message", jSONObject);
            if (!jSONObject.isNull("message_tags")) {
                object = jSONObject.getJSONArray("message_tags");
                int n2 = ((JSONArray)object).length();
                this.messageTags = new ArrayList<Tag>(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.messageTags.add(new TagJSONImpl(((JSONArray)object).getJSONObject(i2)));
                }
            } else {
                this.messageTags = Collections.emptyList();
            }
            this.canComment = z_F4JInternalParseUtil.getBoolean("can_comment", jSONObject);
            this.canRemove = z_F4JInternalParseUtil.getBoolean("can_remove", jSONObject);
            this.canHide = z_F4JInternalParseUtil.getBoolean("can_hide", jSONObject);
            this.canLike = z_F4JInternalParseUtil.getBoolean("can_like", jSONObject);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
            this.likeCount = z_F4JInternalParseUtil.getInt("like_count", jSONObject);
            this.commentCount = z_F4JInternalParseUtil.getInt("comment_count", jSONObject);
            this.isUserLikes = z_F4JInternalParseUtil.getBoolean("user_likes", jSONObject);
            if (!jSONObject.isNull("attachment")) {
                this.attachment = new AttachmentJSONImpl(jSONObject.getJSONObject("attachment"));
            }
            if (!jSONObject.isNull("parent")) {
                this.parent = new CommentJSONImpl(jSONObject.getJSONObject("parent"));
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getFrom() {
        return this.from;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<Tag> getMessageTags() {
        return this.messageTags;
    }

    @Override
    public Boolean canComment() {
        return this.canComment;
    }

    @Override
    public Boolean canRemove() {
        return this.canRemove;
    }

    @Override
    public Boolean canHide() {
        return this.canHide;
    }

    @Override
    public Boolean canLike() {
        return this.canLike;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Integer getLikeCount() {
        return this.likeCount;
    }

    @Override
    public Integer getCommentCount() {
        return this.commentCount;
    }

    @Override
    public Boolean isUserLikes() {
        return this.isUserLikes;
    }

    @Override
    public Comment.Attachment getAttachment() {
        return this.attachment;
    }

    @Override
    public Comment getParent() {
        return this.parent;
    }

    static ResponseList<Comment> createCommentList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Comment> responseListImpl = new ResponseListImpl<Comment>(n2, jSONObject, new Comment[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                CommentJSONImpl commentJSONImpl = new CommentJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(commentJSONImpl, jSONObject2);
                }
                responseListImpl.add(commentJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CommentJSONImpl commentJSONImpl = (CommentJSONImpl)object;
        return !(this.id == null ? commentJSONImpl.id != null : !this.id.equals(commentJSONImpl.id));
    }

    public String toString() {
        return "CommentJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", message='" + this.message + '\'' + ", messageTags=" + this.messageTags + ", canComment=" + this.canComment + ", canRemove=" + this.canRemove + ", canHide=" + this.canHide + ", canLike=" + this.canLike + ", createdTime=" + this.createdTime + ", likeCount=" + this.likeCount + ", commentCount=" + this.commentCount + ", isUserLikes=" + this.isUserLikes + ", attachment=" + this.attachment + ", parent=" + this.parent + '}';
    }

    private final class AttachmentJSONImpl
    implements Comment.Attachment,
    Serializable {
        private static final long serialVersionUID = 5515482060929228129L;
        private String description;
        private Comment.Attachment.AttachmentMedia media;
        private Comment.Attachment.AttachmentTarget target;
        private String title;
        private String type;
        private String url;

        AttachmentJSONImpl(JSONObject jSONObject) {
            try {
                this.description = z_F4JInternalParseUtil.getRawString("description", jSONObject);
                if (!jSONObject.isNull("media")) {
                    this.media = new AttachmentMediaJSONImpl(jSONObject.getJSONObject("media"));
                }
                if (!jSONObject.isNull("target")) {
                    this.target = new AttachmentTargetJSONImpl(jSONObject.getJSONObject("target"));
                }
                this.title = z_F4JInternalParseUtil.getRawString("title", jSONObject);
                this.type = z_F4JInternalParseUtil.getRawString("type", jSONObject);
                this.url = z_F4JInternalParseUtil.getRawString("url", jSONObject);
            }
            catch (JSONException jSONException) {
                throw new FacebookException(jSONException.getMessage(), jSONException);
            }
        }

        public String getDescription() {
            return this.description;
        }

        public Comment.Attachment.AttachmentMedia getMedia() {
            return this.media;
        }

        public Comment.Attachment.AttachmentTarget getTarget() {
            return this.target;
        }

        public String getTitle() {
            return this.title;
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AttachmentJSONImpl)) {
                return false;
            }
            AttachmentJSONImpl attachmentJSONImpl = (AttachmentJSONImpl)object;
            if (this.description != null ? !this.description.equals(attachmentJSONImpl.description) : attachmentJSONImpl.description != null) {
                return false;
            }
            if (this.media != null ? !this.media.equals(attachmentJSONImpl.media) : attachmentJSONImpl.media != null) {
                return false;
            }
            if (this.target != null ? !this.target.equals(attachmentJSONImpl.target) : attachmentJSONImpl.target != null) {
                return false;
            }
            if (this.title != null ? !this.title.equals(attachmentJSONImpl.title) : attachmentJSONImpl.title != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals(attachmentJSONImpl.type) : attachmentJSONImpl.type != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(attachmentJSONImpl.url) : attachmentJSONImpl.url != null);
        }

        public int hashCode() {
            int n2 = this.description != null ? this.description.hashCode() : 0;
            n2 = 31 * n2 + (this.media != null ? this.media.hashCode() : 0);
            n2 = 31 * n2 + (this.target != null ? this.target.hashCode() : 0);
            n2 = 31 * n2 + (this.title != null ? this.title.hashCode() : 0);
            n2 = 31 * n2 + (this.type != null ? this.type.hashCode() : 0);
            n2 = 31 * n2 + (this.url != null ? this.url.hashCode() : 0);
            return n2;
        }

        public String toString() {
            return "AttachmentJSONImpl{description='" + this.description + '\'' + ", media=" + this.media + ", target=" + this.target + ", title='" + this.title + '\'' + ", type='" + this.type + '\'' + ", url='" + this.url + '\'' + '}';
        }

        private final class AttachmentTargetJSONImpl
        implements Comment.Attachment.AttachmentTarget,
        Serializable {
            private String id;
            private String url;

            AttachmentTargetJSONImpl(JSONObject jSONObject) {
                this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
                this.url = z_F4JInternalParseUtil.getRawString("url", jSONObject);
            }

            public String getId() {
                return this.id;
            }

            public String getUrl() {
                return this.url;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof AttachmentTargetJSONImpl)) {
                    return false;
                }
                AttachmentTargetJSONImpl attachmentTargetJSONImpl = (AttachmentTargetJSONImpl)object;
                if (this.id != null ? !this.id.equals(attachmentTargetJSONImpl.id) : attachmentTargetJSONImpl.id != null) {
                    return false;
                }
                return !(this.url != null ? !this.url.equals(attachmentTargetJSONImpl.url) : attachmentTargetJSONImpl.url != null);
            }

            public int hashCode() {
                int n2 = this.id != null ? this.id.hashCode() : 0;
                n2 = 31 * n2 + (this.url != null ? this.url.hashCode() : 0);
                return n2;
            }

            public String toString() {
                return "AttachmentTargetJSONImpl{id='" + this.id + '\'' + ", url='" + this.url + '\'' + '}';
            }
        }

        private final class AttachmentMediaJSONImpl
        implements Comment.Attachment.AttachmentMedia,
        Serializable {
            private static final long serialVersionUID = -4030126370782822645L;
            private final Image image;

            AttachmentMediaJSONImpl(JSONObject jSONObject) {
                try {
                    this.image = new ImageJSONImpl(jSONObject.getJSONObject("image"));
                }
                catch (JSONException jSONException) {
                    throw new FacebookException(jSONException.getMessage(), jSONException);
                }
            }

            public Image getImage() {
                return this.image;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof AttachmentMediaJSONImpl)) {
                    return false;
                }
                AttachmentMediaJSONImpl attachmentMediaJSONImpl = (AttachmentMediaJSONImpl)object;
                return this.image.equals(attachmentMediaJSONImpl.image);
            }

            public int hashCode() {
                return this.image.hashCode();
            }

            public String toString() {
                return "AttachmentMediaJSONImpl{image=" + this.image + '}';
            }
        }
    }
}

