/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.Book;
import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.CategoryJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BookJSONImpl
extends CategoryJSONImpl
implements Book,
Serializable {
    private static final long serialVersionUID = 7801812616028452278L;

    BookJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse, configuration);
    }

    BookJSONImpl(JSONObject jSONObject) {
        super(jSONObject);
    }

    static ResponseList<Book> createBookList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Book> responseListImpl = new ResponseListImpl<Book>(n2, jSONObject, new Book[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                BookJSONImpl bookJSONImpl = new BookJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(bookJSONImpl, jSONObject2);
                }
                responseListImpl.add(bookJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    @Override
    public String toString() {
        return "BookJSONImpl [id=" + this.id + ", name=" + this.name + ", category=" + this.category + ", createdTime=" + this.createdTime + "]";
    }
}

