/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.conf;

import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.conf.ConfigurationBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

public final class PropertyConfiguration
extends ConfigurationBase
implements Serializable {
    private static final long serialVersionUID = -6424033561218975631L;
    public static final String DEBUG = "debug";
    public static final String HTTP_USER_AGENT = "http.userAgent";
    public static final String HTTP_USE_SSL = "http.useSSL";
    public static final String HTTP_PRETTY_DEBUG = "http.prettyDebug";
    public static final String HTTP_GZIP = "http.gzip";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_HOST_FALLBACK = "http.proxyHost";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_PORT_FALLBACK = "http.proxyPort";
    public static final String HTTP_CONNECTION_TIMEOUT = "http.connectionTimeout";
    public static final String HTTP_READ_TIMEOUT = "http.readTimeout";
    public static final String HTTP_RETRY_COUNT = "http.retryCount";
    public static final String HTTP_RETRY_INTERVAL_SECS = "http.retryIntervalSecs";
    public static final String HTTP_MAX_TOTAL_CONNECTIONS = "http.maxTotalConnections";
    public static final String HTTP_DEFAULT_MAX_PER_ROUTE = "http.defaultMaxPerRoute";
    public static final String OAUTH_APP_ID = "oauth.appId";
    public static final String OAUTH_APP_SECRET = "oauth.appSecret";
    public static final String OAUTH_ACCESS_TOKEN = "oauth.accessToken";
    public static final String OAUTH_PERMISSIONS = "oauth.permissions";
    public static final String OAUTH_CALLBACK_URL = "oauth.callbackURL";
    public static final String SECURITY_APP_SECRET_PROOF_ENABLED = "security.appSecretProofEnabled";
    public static final String SECURITY_APP_SECRET_PROOF_CACHE_SIZE = "security.appSecretProofCacheSize";
    public static final String OAUTH_AUTHORIZATION_URL = "oauth.authorizationURL";
    public static final String OAUTH_ACCESS_TOKEN_URL = "oauth.accessTokenURL";
    public static final String OAUTH_ACCESS_TOKEN_INFO_URL = "oauth.accessTokenInfoURL";
    public static final String OAUTH_DEVICE_TOKEN_URL = "oauth.deviceTokenURL";
    public static final String REST_BASE_URL = "restBaseURL";
    public static final String VIDEO_BASE_URL = "videoBaseURL";
    public static final String JSON_STORE_ENABLED = "jsonStoreEnabled";
    public static final String MBEAN_ENABLED = "mbeanEnabled";
    public static final String CLIENT_VERSION = "clientVersion";
    public static final String CLIENT_URL = "clientURL";

    public PropertyConfiguration(InputStream inputStream) {
        Properties properties = new Properties();
        this.loadProperties(properties, inputStream);
        this.setFieldsWithTreePath(properties, "/");
    }

    public PropertyConfiguration(Properties properties) {
        this(properties, "/");
    }

    public PropertyConfiguration(Properties properties, String string) {
        this.setFieldsWithTreePath(properties, string);
    }

    PropertyConfiguration(String string) {
        Object object;
        Properties properties;
        try {
            properties = (Properties)System.getProperties().clone();
            try {
                object = System.getenv();
                for (String string2 : object.keySet()) {
                    properties.setProperty(string2, (String)object.get(string2));
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.normalize(properties);
        }
        catch (SecurityException securityException) {
            properties = new Properties();
        }
        object = "be.maximvdw.featherboardcore.facebook.properties";
        this.loadProperties(properties, "." + File.separatorChar + "be.maximvdw.featherboardcore.facebook.properties");
        this.loadProperties(properties, Configuration.class.getResourceAsStream("/be/maximvdw/featherboardcore/facebook.properties"));
        this.loadProperties(properties, Configuration.class.getResourceAsStream("/WEB-INF/facebook4j.properties"));
        try {
            this.loadProperties(properties, new FileInputStream("WEB-INF/facebook4j.properties"));
        }
        catch (SecurityException securityException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.setFieldsWithTreePath(properties, string);
    }

    PropertyConfiguration() {
        this("/");
    }

    private boolean notNull(Properties properties, String string, String string2) {
        return properties.getProperty(string + string2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadProperties(Properties properties, String string) {
        FileInputStream fileInputStream = null;
        try {
            File file = new File(string);
            if (file.exists() && file.isFile()) {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                this.normalize(properties);
                boolean bl2 = true;
                return bl2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private boolean loadProperties(Properties properties, InputStream inputStream) {
        try {
            properties.load(inputStream);
            this.normalize(properties);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void normalize(Properties properties) {
        String string;
        Set<Object> set = properties.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        for (Object object : set) {
            string = (String)object;
            if (-1 == string.indexOf("be.maximvdw.featherboardcore.facebook.")) continue;
            arrayList.add(string);
        }
        for (String string2 : arrayList) {
            string = properties.getProperty(string2);
            int n2 = string2.indexOf("be.maximvdw.featherboardcore.facebook.");
            String string3 = string2.substring(0, n2) + string2.substring(n2 + 11);
            properties.setProperty(string3, string);
        }
    }

    private void setFieldsWithTreePath(Properties properties, String string) {
        this.setFieldsWithPrefix(properties, "");
        String[] stringArray = string.split("/");
        String string2 = null;
        for (String string3 : stringArray) {
            if ("".equals(string3)) continue;
            string2 = null == string2 ? string3 + "." : string2 + string3 + ".";
            this.setFieldsWithPrefix(properties, string2);
        }
    }

    private void setFieldsWithPrefix(Properties properties, String string) {
        if (this.notNull(properties, string, DEBUG)) {
            this.setDebug(this.getBoolean(properties, string, DEBUG));
        }
        if (this.notNull(properties, string, HTTP_USE_SSL)) {
            this.setUseSSL(this.getBoolean(properties, string, HTTP_USE_SSL));
        }
        if (this.notNull(properties, string, HTTP_PRETTY_DEBUG)) {
            this.setPrettyDebugEnabled(this.getBoolean(properties, string, HTTP_PRETTY_DEBUG));
        }
        if (this.notNull(properties, string, HTTP_GZIP)) {
            this.setGZIPEnabled(this.getBoolean(properties, string, HTTP_GZIP));
        }
        if (this.notNull(properties, string, "http.proxyHost")) {
            this.setHttpProxyHost(this.getString(properties, string, "http.proxyHost"));
        } else if (this.notNull(properties, string, "http.proxyHost")) {
            this.setHttpProxyHost(this.getString(properties, string, "http.proxyHost"));
        }
        if (this.notNull(properties, string, HTTP_PROXY_USER)) {
            this.setHttpProxyUser(this.getString(properties, string, HTTP_PROXY_USER));
        }
        if (this.notNull(properties, string, HTTP_PROXY_PASSWORD)) {
            this.setHttpProxyPassword(this.getString(properties, string, HTTP_PROXY_PASSWORD));
        }
        if (this.notNull(properties, string, "http.proxyPort")) {
            this.setHttpProxyPort(this.getIntProperty(properties, string, "http.proxyPort"));
        } else if (this.notNull(properties, string, "http.proxyPort")) {
            this.setHttpProxyPort(this.getIntProperty(properties, string, "http.proxyPort"));
        }
        if (this.notNull(properties, string, HTTP_CONNECTION_TIMEOUT)) {
            this.setHttpConnectionTimeout(this.getIntProperty(properties, string, HTTP_CONNECTION_TIMEOUT));
        }
        if (this.notNull(properties, string, HTTP_READ_TIMEOUT)) {
            this.setHttpReadTimeout(this.getIntProperty(properties, string, HTTP_READ_TIMEOUT));
        }
        if (this.notNull(properties, string, HTTP_RETRY_COUNT)) {
            this.setHttpRetryCount(this.getIntProperty(properties, string, HTTP_RETRY_COUNT));
        }
        if (this.notNull(properties, string, HTTP_RETRY_INTERVAL_SECS)) {
            this.setHttpRetryIntervalSeconds(this.getIntProperty(properties, string, HTTP_RETRY_INTERVAL_SECS));
        }
        if (this.notNull(properties, string, HTTP_MAX_TOTAL_CONNECTIONS)) {
            this.setHttpMaxTotalConnections(this.getIntProperty(properties, string, HTTP_MAX_TOTAL_CONNECTIONS));
        }
        if (this.notNull(properties, string, HTTP_DEFAULT_MAX_PER_ROUTE)) {
            this.setHttpDefaultMaxPerRoute(this.getIntProperty(properties, string, HTTP_DEFAULT_MAX_PER_ROUTE));
        }
        if (this.notNull(properties, string, OAUTH_APP_ID)) {
            this.setOAuthAppId(this.getString(properties, string, OAUTH_APP_ID));
        }
        if (this.notNull(properties, string, OAUTH_APP_SECRET)) {
            this.setOAuthAppSecret(this.getString(properties, string, OAUTH_APP_SECRET));
        }
        if (this.notNull(properties, string, OAUTH_ACCESS_TOKEN)) {
            this.setOAuthAccessToken(this.getString(properties, string, OAUTH_ACCESS_TOKEN));
        }
        if (this.notNull(properties, string, OAUTH_PERMISSIONS)) {
            this.setOAuthPermissions(this.getString(properties, string, OAUTH_PERMISSIONS));
        }
        if (this.notNull(properties, string, OAUTH_CALLBACK_URL)) {
            this.setOAuthCallbackURL(this.getString(properties, string, OAUTH_CALLBACK_URL));
        }
        if (this.notNull(properties, string, SECURITY_APP_SECRET_PROOF_ENABLED)) {
            this.setAppSecretProofEnabled(this.getBoolean(properties, string, SECURITY_APP_SECRET_PROOF_ENABLED));
        }
        if (this.notNull(properties, string, SECURITY_APP_SECRET_PROOF_CACHE_SIZE)) {
            this.setAppSecretProofCacheSize(this.getIntProperty(properties, string, SECURITY_APP_SECRET_PROOF_CACHE_SIZE));
        }
        if (this.notNull(properties, string, CLIENT_VERSION)) {
            this.setClientVersion(this.getString(properties, string, CLIENT_VERSION));
        }
        if (this.notNull(properties, string, CLIENT_URL)) {
            this.setClientURL(this.getString(properties, string, CLIENT_URL));
        }
        if (this.notNull(properties, string, HTTP_USER_AGENT)) {
            this.setUserAgent(this.getString(properties, string, HTTP_USER_AGENT));
        }
        if (this.notNull(properties, string, OAUTH_AUTHORIZATION_URL)) {
            this.setOAuthAuthorizationURL(this.getString(properties, string, OAUTH_AUTHORIZATION_URL));
        }
        if (this.notNull(properties, string, OAUTH_ACCESS_TOKEN_URL)) {
            this.setOAuthAccessTokenURL(this.getString(properties, string, OAUTH_ACCESS_TOKEN_URL));
        }
        if (this.notNull(properties, string, OAUTH_ACCESS_TOKEN_INFO_URL)) {
            this.setOAuthAccessTokenInfoURL(this.getString(properties, string, OAUTH_ACCESS_TOKEN_INFO_URL));
        }
        if (this.notNull(properties, string, OAUTH_DEVICE_TOKEN_URL)) {
            this.setOAuthDeviceTokenURL(this.getString(properties, string, OAUTH_DEVICE_TOKEN_URL));
        }
        if (this.notNull(properties, string, REST_BASE_URL)) {
            this.setRestBaseURL(this.getString(properties, string, REST_BASE_URL));
        }
        if (this.notNull(properties, string, VIDEO_BASE_URL)) {
            this.setVideoBaseURL(this.getString(properties, string, VIDEO_BASE_URL));
        }
        if (this.notNull(properties, string, JSON_STORE_ENABLED)) {
            this.setJSONStoreEnabled(this.getBoolean(properties, string, JSON_STORE_ENABLED));
        }
        if (this.notNull(properties, string, MBEAN_ENABLED)) {
            this.setMBeanEnabled(this.getBoolean(properties, string, MBEAN_ENABLED));
        }
        this.cacheInstance();
    }

    protected boolean getBoolean(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string + string2);
        return Boolean.valueOf(string3);
    }

    protected int getIntProperty(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string + string2);
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected String getString(Properties properties, String string, String string2) {
        return properties.getProperty(string + string2);
    }

    protected Object readResolve() {
        return super.readResolve();
    }
}

