/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.auth;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.auth.AccessToken;
import be.maximvdw.featherboardcore.facebook.auth.AuthOption;
import be.maximvdw.featherboardcore.facebook.auth.AuthType;
import be.maximvdw.featherboardcore.facebook.auth.Authorization;
import be.maximvdw.featherboardcore.facebook.auth.DeviceCode;
import be.maximvdw.featherboardcore.facebook.auth.DialogAuthOption;
import be.maximvdw.featherboardcore.facebook.auth.NullAuthOption;
import be.maximvdw.featherboardcore.facebook.auth.OAuthSupport;
import be.maximvdw.featherboardcore.facebook.auth.Security;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpClientWrapper;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.logging.Logger;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JLRUCache;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class OAuthAuthorization
implements Authorization,
OAuthSupport,
Security,
Serializable {
    private static final long serialVersionUID = 2548925849295080874L;
    private static final Logger logger = Logger.getLogger(OAuthAuthorization.class);
    public static final String HMAC_SHA_256 = "HmacSHA256";
    private final Configuration conf;
    private static transient HttpClientWrapper http;
    private String appId = "";
    private String appSecret;
    private AccessToken oauthToken;
    private String permissions;
    private String callbackURL;
    private boolean appSecretProofEnabled;
    private transient z_F4JLRUCache<String, String> appSecretProofCache;

    public OAuthAuthorization(Configuration configuration) {
        this.conf = configuration;
        http = new HttpClientWrapper(configuration);
        this.setOAuthAppId(configuration.getOAuthAppId(), configuration.getOAuthAppSecret());
        if (configuration.getOAuthPermissions() != null) {
            this.setOAuthPermissions(configuration.getOAuthPermissions());
        }
        if (configuration.getOAuthAccessToken() != null) {
            this.setOAuthAccessToken(new AccessToken(configuration.getOAuthAccessToken(), null));
        }
        this.setAppSecretProofEnabled(configuration.isAppSecretProofEnabled());
        this.appSecretProofCache = new z_F4JLRUCache(configuration.getAppSecretProofCacheSize());
    }

    private void ensureTokenIsAvailable() {
        if (null == this.oauthToken) {
            throw new IllegalStateException("No Token available.");
        }
    }

    public boolean isEnabled() {
        return null != this.oauthToken;
    }

    public String getOAuthAuthorizationURL(String string) {
        return this.getOAuthAuthorizationURL(string, new NullAuthOption());
    }

    public String getOAuthAuthorizationURL(String string, String string2) {
        return this.getOAuthAuthorizationURL(string, new DialogAuthOption().state(string2));
    }

    public String getOAuthAuthorizationURL(String string, AuthOption authOption) {
        this.callbackURL = string;
        String string2 = this.conf.getOAuthAuthorizationURL() + "?client_id=" + this.appId + "&redirect_uri=" + string;
        if (this.permissions != null) {
            string2 = string2 + "&scope=" + this.permissions;
        }
        if (authOption != null) {
            string2 = string2 + authOption.getQuery("&");
        }
        return string2;
    }

    public String getOAuthReAuthenticationURL(String string, String string2) {
        if (string2 == null) {
            logger.warn("strongly encourage to use 'nonce' parameter, especially when requesting reauthenticate.");
        }
        return this.getOAuthAuthorizationURL(string, new DialogAuthOption().authType(AuthType.REAUTHENTICATE).authNonce(string2));
    }

    public AccessToken getOAuthAccessToken(String string) {
        String string2 = this.getExchangeAccessTokenURL(string);
        HttpResponse httpResponse = http.get(string2);
        if (httpResponse.getStatusCode() != 200) {
            throw new FacebookException("authorization failed.");
        }
        this.oauthToken = new AccessToken(httpResponse);
        return this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(String string, String string2) {
        this.callbackURL = string2;
        return this.getOAuthAccessToken(string);
    }

    protected String getExchangeAccessTokenURL(String string) {
        return this.conf.getOAuthAccessTokenURL() + "?client_id=" + this.appId + "&client_secret=" + this.appSecret + "&redirect_uri=" + this.callbackURL + "&code=" + string;
    }

    public AccessToken getOAuthAccessToken() {
        this.ensureTokenIsAvailable();
        return this.oauthToken;
    }

    public AccessToken getOAuthAppAccessToken() {
        String string = this.getAppAccessTokenURL();
        HttpResponse httpResponse = http.get(string);
        if (httpResponse.getStatusCode() != 200) {
            throw new FacebookException("authorization failed.");
        }
        this.oauthToken = new AccessToken(httpResponse);
        return this.oauthToken;
    }

    private String getAppAccessTokenURL() {
        return this.conf.getOAuthAccessTokenURL() + "?client_id=" + this.appId + "&client_secret=" + this.appSecret + "&grant_type=client_credentials";
    }

    public DeviceCode getOAuthDeviceCode() {
        String string = this.getDeviceCodeURL();
        HttpResponse httpResponse = http.get(string);
        if (httpResponse.getStatusCode() != 200) {
            throw new FacebookException("generate a device code failed");
        }
        return new DeviceCode(httpResponse);
    }

    private String getDeviceCodeURL() {
        return this.conf.getOAuthDeviceTokenURL() + "?type=device_code" + "&client_id=" + this.appId + "&scope=" + this.permissions;
    }

    public AccessToken getOAuthDeviceToken(DeviceCode deviceCode) {
        String string = this.getDeviceTokenURL(deviceCode.getCode());
        HttpResponse httpResponse = http.get(string);
        if (httpResponse.getStatusCode() != 200) {
            throw new FacebookException("authorization failed.");
        }
        this.oauthToken = new AccessToken(httpResponse);
        return this.oauthToken;
    }

    private String getDeviceTokenURL(String string) {
        return this.conf.getOAuthDeviceTokenURL() + "?type=device_token" + "&client_id=" + this.appId + "&code=" + string;
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.oauthToken = accessToken;
    }

    public void setOAuthAccessToken(AccessToken accessToken, String string) {
        this.oauthToken = accessToken;
        this.callbackURL = string;
    }

    public String getOAuthCallbackURL() {
        return this.callbackURL;
    }

    public void setOAuthCallbackURL(String string) {
        this.callbackURL = string;
    }

    public void setOAuthAppId(String string, String string2) {
        this.appId = string != null ? string : "";
        this.appSecret = string2 != null ? string2 : "";
    }

    public void setOAuthPermissions(String string) {
        this.permissions = string;
    }

    public AccessToken extendTokenExpiration(String string) {
        String string2 = this.getExtendTokenURL(string);
        HttpResponse httpResponse = http.get(string2);
        if (httpResponse.getStatusCode() != 200) {
            throw new FacebookException("token expiration extention failed.");
        }
        this.oauthToken = new AccessToken(httpResponse);
        return this.oauthToken;
    }

    public AccessToken extendTokenExpiration() {
        return this.extendTokenExpiration(this.oauthToken.getToken());
    }

    protected String getExtendTokenURL(String string) {
        return this.conf.getOAuthAccessTokenURL() + "?grant_type=fb_exchange_token" + "&client_id=" + this.appId + "&client_secret=" + this.appSecret + "&fb_exchange_token=" + string;
    }

    public AccessToken getOAuthAccessTokenInfo(String string) {
        String string2 = this.getAccessTokenInfoURL(string);
        HttpResponse httpResponse = http.get(string2);
        if (httpResponse.getStatusCode() != 200) {
            throw new FacebookException("authorization failed.");
        }
        return new AccessToken(httpResponse);
    }

    public AccessToken getOAuthAccessTokenInfo() {
        return this.getOAuthAccessTokenInfo(this.oauthToken.getToken());
    }

    protected String getAccessTokenInfoURL(String string) {
        return this.conf.getOAuthAccessTokenInfoURL() + "?client_id=" + this.appId + "&access_token=" + string;
    }

    public void setAppSecretProofEnabled(boolean bl2) {
        this.appSecretProofEnabled = bl2;
    }

    public boolean isAppSecretProofEnabled() {
        return this.appSecretProofEnabled;
    }

    public String generateAppSecretProof() {
        Object object;
        Object object2;
        if (this.appSecret == null || !this.isEnabled()) {
            throw new IllegalStateException("App Secret and Access Token are required.");
        }
        String string = this.oauthToken.getToken();
        String string2 = this.appSecretProofCache.get(string);
        if (string2 != null) {
            return string2;
        }
        Object object3 = null;
        try {
            object2 = Mac.getInstance(HMAC_SHA_256);
            object = new SecretKeySpec(this.appSecret.getBytes("UTF-8"), HMAC_SHA_256);
            ((Mac)object2).init((Key)object);
            object3 = ((Mac)object2).doFinal(string.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException();
        }
        object2 = new StringBuilder();
        for (SecretKeySpec secretKeySpec : object3) {
            ((StringBuilder)object2).append(Integer.toString((secretKeySpec & 0xFF) + 256, 16).substring(1));
        }
        object = ((StringBuilder)object2).toString();
        this.appSecretProofCache.put(string, (String)object);
        return object;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.appId == null ? 0 : this.appId.hashCode());
        n3 = 31 * n3 + (this.appSecret == null ? 0 : this.appSecret.hashCode());
        n3 = 31 * n3 + (this.callbackURL == null ? 0 : this.callbackURL.hashCode());
        n3 = 31 * n3 + (this.conf == null ? 0 : this.conf.hashCode());
        n3 = 31 * n3 + (this.oauthToken == null ? 0 : this.oauthToken.hashCode());
        n3 = 31 * n3 + (this.permissions == null ? 0 : this.permissions.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OAuthAuthorization oAuthAuthorization = (OAuthAuthorization)object;
        if (this.appId == null ? oAuthAuthorization.appId != null : !this.appId.equals(oAuthAuthorization.appId)) {
            return false;
        }
        if (this.appSecret == null ? oAuthAuthorization.appSecret != null : !this.appSecret.equals(oAuthAuthorization.appSecret)) {
            return false;
        }
        if (this.callbackURL == null ? oAuthAuthorization.callbackURL != null : !this.callbackURL.equals(oAuthAuthorization.callbackURL)) {
            return false;
        }
        if (this.oauthToken == null ? oAuthAuthorization.oauthToken != null : !this.oauthToken.equals(oAuthAuthorization.oauthToken)) {
            return false;
        }
        return !(this.permissions == null ? oAuthAuthorization.permissions != null : !this.permissions.equals(oAuthAuthorization.permissions));
    }

    public String toString() {
        return "OAuthAuthorization [appId=" + this.appId + ", appSecret=****************" + ", oauthToken=" + this.oauthToken + ", permissions=" + this.permissions + ", callbackURL=" + this.callbackURL + "]";
    }
}

