/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook;

import be.maximvdw.featherboardcore.facebook.Facebook;
import be.maximvdw.featherboardcore.facebook.auth.AccessToken;
import be.maximvdw.featherboardcore.facebook.auth.Authorization;
import be.maximvdw.featherboardcore.facebook.auth.AuthorizationFactory;
import be.maximvdw.featherboardcore.facebook.auth.OAuthAuthorization;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.conf.ConfigurationContext;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class FacebookFactory
implements Serializable {
    private static final Constructor<Facebook> FACEBOOK_CONSTRUCTOR;
    static final Authorization DEFAULT_AUTHORIZATION;
    private static final Facebook SINGLETON;
    private static final long serialVersionUID = 5193900138477709155L;
    private final Configuration conf;

    public FacebookFactory() {
        this(ConfigurationContext.getInstance());
    }

    public FacebookFactory(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = configuration;
    }

    public FacebookFactory(String string) {
        this(ConfigurationContext.getInstance(string));
    }

    public Facebook getInstance() {
        return this.getInstance(AuthorizationFactory.getInstance(this.conf));
    }

    public Facebook getInstance(AccessToken accessToken) {
        String string = this.conf.getOAuthAppId();
        String string2 = this.conf.getOAuthAppSecret();
        if (null == string && null == string2) {
            throw new IllegalStateException("App id and App secret not supplied.");
        }
        OAuthAuthorization oAuthAuthorization = new OAuthAuthorization(this.conf);
        oAuthAuthorization.setOAuthAccessToken(accessToken);
        return this.getInstance(oAuthAuthorization);
    }

    public Facebook getInstance(Authorization authorization) {
        try {
            return FACEBOOK_CONSTRUCTOR.newInstance(this.conf, authorization);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    public static Facebook getSingleton() {
        return SINGLETON;
    }

    static {
        Object object;
        DEFAULT_AUTHORIZATION = AuthorizationFactory.getInstance(ConfigurationContext.getInstance());
        String string = null;
        if (ConfigurationContext.getInstance().isGAE()) {
            object = "be.maximvdw.featherboardcore.facebook.AppEngineFacebookImpl";
            try {
                Class.forName("be.maximvdw.featherboardcore.facebook.AppEngineFacebookImpl");
                string = "be.maximvdw.featherboardcore.facebook.AppEngineFacebookImpl";
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (string == null) {
            string = "be.maximvdw.featherboardcore.facebook.FacebookImpl";
        }
        try {
            Class<?> clazz = Class.forName(string);
            object = clazz.getDeclaredConstructor(Configuration.class, Authorization.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        FACEBOOK_CONSTRUCTOR = object;
        try {
            SINGLETON = FACEBOOK_CONSTRUCTOR.newInstance(ConfigurationContext.getInstance(), DEFAULT_AUTHORIZATION);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }
}

