/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboard.user;

import be.maximvdw.featherboard.user.FBPlayerData;
import be.maximvdw.featherboard.user.FBPlayerManagerLoadedEvent;
import be.maximvdw.featherboardcore.c.c;
import be.maximvdw.featherboardcore.o.f;
import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.EbeanServerFactory;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.config.DataSourceConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.SQLitePlatform;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.ddl.DdlGenerator;
import com.avaje.ebeaninternal.server.lib.sql.TransactionIsolation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.PersistenceException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class FBPlayerManager
extends be.maximvdw.featherboardcore.h.a {
    private static FBPlayerManager instance = null;
    private Map<String, FBPlayerData> players = new ConcurrentHashMap<String, FBPlayerData>();
    private EbeanServer database = null;

    public FBPlayerManager(Plugin plugin) {
        super(plugin);
        instance = this;
        this.loadDatabase();
        this.loadPlayers();
    }

    public void loadPlayers() {
        this.players.clear();
        try {
            for (Player player : be.maximvdw.featherboardcore.p.a.a.b()) {
                this.addPlayerData((OfflinePlayer)player);
            }
        }
        catch (Exception exception) {
            f.a(exception);
        }
        new FBPlayerManagerLoadedEvent();
    }

    public List<Class<?>> getDatabaseClasses() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(FBPlayerData.class);
        return arrayList;
    }

    public void loadDatabase() {
        if (c.b().getConfigurationSection("database") == null) {
            f.d("Configuration file outdated! Unable to use toggle persistence!");
            return;
        }
        if (!c.b().getBoolean("database.persistent")) {
            f.c("Toggle persistence is disabled!");
            return;
        }
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.setDefaultServer(false);
        serverConfig.setRegister(false);
        serverConfig.setClasses(this.getDatabaseClasses());
        serverConfig.setName(c.b().getString("database.database"));
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setDriver(c.b().getString("database.driver"));
        dataSourceConfig.setUrl(c.b().getString("database.url"));
        dataSourceConfig.setUsername(c.b().getString("database.username"));
        dataSourceConfig.setPassword(c.b().getString("database.password"));
        dataSourceConfig.setIsolationLevel(TransactionIsolation.getLevel((String)c.b().getString("database.isolation")));
        if (dataSourceConfig.getDriver().toLowerCase().contains("sqlite")) {
            serverConfig.setDatabasePlatform((DatabasePlatform)new SQLitePlatform());
            serverConfig.getDatabasePlatform().getDbDdlSyntax().setIdentity("");
        }
        serverConfig.setDataSourceConfig(dataSourceConfig);
        dataSourceConfig.setUrl(this.replaceDatabaseString(dataSourceConfig.getUrl()));
        this.getPlugin().getDataFolder().mkdirs();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.setDatabase(EbeanServerFactory.create((ServerConfig)serverConfig));
        try {
            int n2 = this.getDatabase().find(FBPlayerData.class).findRowCount();
            f.c("Database contains " + n2 + " player records");
        }
        catch (PersistenceException persistenceException) {
            f.d("Initializing database for the first time ...");
            SpiEbeanServer spiEbeanServer = (SpiEbeanServer)this.getDatabase();
            DdlGenerator ddlGenerator = spiEbeanServer.getDdlGenerator();
            ddlGenerator.runScript(false, ddlGenerator.generateCreateDdl());
        }
        this.getPlugin().getServer().getScheduler().runTaskTimerAsynchronously(this.getPlugin(), (Runnable)new a(), c.b().getLong("database.save-interval"), c.b().getLong("database.save-interval"));
    }

    private String replaceDatabaseString(String string) {
        string = string.replaceAll("\\{DIR\\}", this.getPlugin().getDataFolder().getPath().replaceAll("\\\\", "/") + "/");
        string = string.replaceAll("\\{NAME\\}", this.getPlugin().getDescription().getName().replaceAll("[^\\w_-]", ""));
        return string;
    }

    public static FBPlayerManager getInstance() {
        return instance;
    }

    public static void setInstance(FBPlayerManager fBPlayerManager) {
        instance = fBPlayerManager;
    }

    public synchronized FBPlayerData addPlayerData(OfflinePlayer offlinePlayer) {
        FBPlayerData fBPlayerData;
        FBPlayerData fBPlayerData2 = new FBPlayerData(offlinePlayer);
        if (this.getDatabase() != null && (fBPlayerData = (FBPlayerData)this.getDatabase().find(FBPlayerData.class).where().ieq("player", be.maximvdw.featherboardcore.p.a.a.c() ? offlinePlayer.getUniqueId().toString() : offlinePlayer.getName()).findUnique()) != null) {
            fBPlayerData2 = fBPlayerData;
        }
        if (be.maximvdw.featherboardcore.p.a.a.c()) {
            if (!this.players.containsKey(offlinePlayer.getUniqueId().toString())) {
                this.players.put(offlinePlayer.getUniqueId().toString(), fBPlayerData2);
            }
        } else if (!this.players.containsKey(offlinePlayer.getName())) {
            this.players.put(offlinePlayer.getName().toString(), fBPlayerData2);
        }
        return fBPlayerData2;
    }

    public FBPlayerData getPlayerData(OfflinePlayer offlinePlayer) {
        String string = offlinePlayer.getName();
        if (be.maximvdw.featherboardcore.p.a.a.c()) {
            string = offlinePlayer.getUniqueId().toString();
        }
        if (this.players.containsKey(string)) {
            return this.players.get(string);
        }
        return this.addPlayerData(offlinePlayer);
    }

    @EventHandler
    public void onPlayerJoin(final PlayerJoinEvent playerJoinEvent) {
        Bukkit.getScheduler().runTaskAsynchronously(this.getPlugin(), new Runnable(){

            @Override
            public void run() {
                FBPlayerManager.this.addPlayerData((OfflinePlayer)playerJoinEvent.getPlayer());
            }
        });
    }

    @EventHandler
    public void onPlayerQuit(final PlayerQuitEvent playerQuitEvent) {
        Bukkit.getScheduler().runTaskAsynchronously(this.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try {
                    if (be.maximvdw.featherboardcore.p.a.a.c()) {
                        FBPlayerData fBPlayerData;
                        if (FBPlayerManager.this.getDatabase() != null && (fBPlayerData = (FBPlayerData)FBPlayerManager.this.players.get(playerQuitEvent.getPlayer().getUniqueId().toString())).isDirty()) {
                            if (fBPlayerData.getId() == 0) {
                                FBPlayerManager.this.getDatabase().save((Object)fBPlayerData);
                            } else {
                                FBPlayerManager.this.getDatabase().update((Object)fBPlayerData);
                            }
                        }
                        FBPlayerManager.this.players.remove(playerQuitEvent.getPlayer().getUniqueId().toString());
                    } else {
                        FBPlayerData fBPlayerData;
                        if (FBPlayerManager.this.getDatabase() != null && (fBPlayerData = (FBPlayerData)FBPlayerManager.this.players.get(playerQuitEvent.getPlayer().getName())).isDirty()) {
                            if (fBPlayerData.getId() == 0) {
                                FBPlayerManager.this.getDatabase().save((Object)fBPlayerData);
                            } else {
                                FBPlayerManager.this.getDatabase().update((Object)fBPlayerData);
                            }
                        }
                        FBPlayerManager.this.players.remove(playerQuitEvent.getPlayer().getName());
                    }
                }
                catch (Exception exception) {
                    f.b(exception);
                }
            }
        });
    }

    public EbeanServer getDatabase() {
        return this.database;
    }

    public void setDatabase(EbeanServer ebeanServer) {
        this.database = ebeanServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() {
        if (this.getDatabase() == null) {
            return;
        }
        f.c("Saving all player states ...");
        HashMap<String, FBPlayerData> hashMap = new HashMap<String, FBPlayerData>(this.players);
        Transaction transaction = this.getDatabase().beginTransaction();
        try {
            for (String string : hashMap.keySet()) {
                if (string != null) {
                    FBPlayerData fBPlayerData = (FBPlayerData)hashMap.get(string);
                    if (fBPlayerData.isDirty()) {
                        if (fBPlayerData.getId() == 0) {
                            this.getDatabase().save((Object)fBPlayerData);
                        } else {
                            this.getDatabase().update((Object)fBPlayerData);
                        }
                        fBPlayerData.setDirty(false);
                    }
                    if (fBPlayerData.getOfflinePlayer().isOnline()) continue;
                    this.players.remove(string);
                    continue;
                }
                this.players.remove(string);
            }
            transaction.commit();
            f.c("Saving done!");
        }
        catch (Exception exception) {
            f.b(exception);
        }
        finally {
            transaction.end();
        }
    }

    class a
    implements Runnable {
        a() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Transaction transaction = FBPlayerManager.this.getDatabase().beginTransaction();
            try {
                HashMap hashMap = new HashMap(FBPlayerManager.this.players);
                for (String string : hashMap.keySet()) {
                    if (string != null) {
                        FBPlayerData fBPlayerData = (FBPlayerData)hashMap.get(string);
                        if (fBPlayerData.isDirty()) {
                            if (fBPlayerData.getId() == 0) {
                                FBPlayerManager.this.getDatabase().save((Object)fBPlayerData);
                            } else {
                                FBPlayerManager.this.getDatabase().update((Object)fBPlayerData);
                            }
                            fBPlayerData.setDirty(false);
                        }
                        if (fBPlayerData.getOfflinePlayer().isOnline()) continue;
                        FBPlayerManager.this.players.remove(string);
                        continue;
                    }
                    FBPlayerManager.this.players.remove(string);
                }
                transaction.commit();
            }
            catch (Exception exception) {
                f.b(exception);
            }
            finally {
                transaction.end();
            }
        }
    }
}

